/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.BoatDispenseItemBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.EquipmentDispenseItemBehavior;
import net.minecraft.core.dispenser.MinecartDispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.core.dispenser.ShulkerBoxDispenseBehavior;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.WitherSkullBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.ItemAbilities;
import org.slf4j.Logger;

public interface DispenseItemBehavior {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DispenseItemBehavior NOOP = (p_302424_, p_123401_) -> p_123401_;

    public ItemStack dispense(BlockSource var1, ItemStack var2);

    public static void bootStrap() {
        DispenserBlock.registerProjectileBehavior((ItemLike)Items.ARROW);
        DispenserBlock.registerProjectileBehavior((ItemLike)Items.TIPPED_ARROW);
        DispenserBlock.registerProjectileBehavior((ItemLike)Items.SPECTRAL_ARROW);
        DispenserBlock.registerProjectileBehavior((ItemLike)Items.EGG);
        DispenserBlock.registerProjectileBehavior((ItemLike)Items.BLUE_EGG);
        DispenserBlock.registerProjectileBehavior((ItemLike)Items.BROWN_EGG);
        DispenserBlock.registerProjectileBehavior((ItemLike)Items.SNOWBALL);
        DispenserBlock.registerProjectileBehavior((ItemLike)Items.EXPERIENCE_BOTTLE);
        DispenserBlock.registerProjectileBehavior((ItemLike)Items.SPLASH_POTION);
        DispenserBlock.registerProjectileBehavior((ItemLike)Items.LINGERING_POTION);
        DispenserBlock.registerProjectileBehavior((ItemLike)Items.FIREWORK_ROCKET);
        DispenserBlock.registerProjectileBehavior((ItemLike)Items.FIRE_CHARGE);
        DispenserBlock.registerProjectileBehavior((ItemLike)Items.WIND_CHARGE);
        DefaultDispenseItemBehavior defaultdispenseitembehavior = new DefaultDispenseItemBehavior(){

            public ItemStack execute(BlockSource p_338275_, ItemStack p_338216_) {
                Direction direction = (Direction)p_338275_.state().getValue((Property)DispenserBlock.FACING);
                EntityType<?> entitytype = ((SpawnEggItem)p_338216_.getItem()).getType((HolderLookup.Provider)p_338275_.level().registryAccess(), p_338216_);
                try {
                    entitytype.spawn(p_338275_.level(), p_338216_, null, p_338275_.pos().relative(direction), EntitySpawnReason.DISPENSER, direction != Direction.UP, false);
                }
                catch (Exception exception) {
                    LOGGER.error("Error while dispensing spawn egg from dispenser at {}", (Object)p_338275_.pos(), (Object)exception);
                    return ItemStack.EMPTY;
                }
                p_338216_.shrink(1);
                p_338275_.level().gameEvent(null, GameEvent.ENTITY_PLACE, p_338275_.pos());
                return p_338216_;
            }
        };
        for (SpawnEggItem spawneggitem : SpawnEggItem.eggs()) {
            DispenserBlock.registerBehavior((ItemLike)spawneggitem, (DispenseItemBehavior)defaultdispenseitembehavior);
        }
        DispenserBlock.registerBehavior((ItemLike)Items.ARMOR_STAND, (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            public ItemStack execute(BlockSource p_338813_, ItemStack p_338809_) {
                Consumer<ArmorStand> consumer;
                Direction direction = (Direction)p_338813_.state().getValue((Property)DispenserBlock.FACING);
                BlockPos blockpos = p_338813_.pos().relative(direction);
                ServerLevel serverlevel = p_338813_.level();
                ArmorStand armorstand = EntityType.ARMOR_STAND.spawn(serverlevel, consumer = EntityType.appendDefaultStackConfig(p_392593_ -> p_392593_.setYRot(direction.toYRot()), serverlevel, p_338809_, null), blockpos, EntitySpawnReason.DISPENSER, false, false);
                if (armorstand != null) {
                    p_338809_.shrink(1);
                }
                return p_338809_;
            }
        });
        DispenserBlock.registerBehavior((ItemLike)Items.CHEST, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            public ItemStack execute(BlockSource p_338360_, ItemStack p_338306_) {
                BlockPos blockpos = p_338360_.pos().relative((Direction)p_338360_.state().getValue((Property)DispenserBlock.FACING));
                for (AbstractChestedHorse abstractchestedhorse : p_338360_.level().getEntitiesOfClass(AbstractChestedHorse.class, new AABB(blockpos), p_409122_ -> p_409122_.isAlive() && !p_409122_.hasChest())) {
                    if (!abstractchestedhorse.isTamed() || !abstractchestedhorse.getSlot(499).set(p_338306_)) continue;
                    p_338306_.shrink(1);
                    this.setSuccess(true);
                    return p_338306_;
                }
                return super.execute(p_338360_, p_338306_);
            }
        });
        DispenserBlock.registerBehavior((ItemLike)Items.OAK_BOAT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.OAK_BOAT)));
        DispenserBlock.registerBehavior((ItemLike)Items.SPRUCE_BOAT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.SPRUCE_BOAT)));
        DispenserBlock.registerBehavior((ItemLike)Items.BIRCH_BOAT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.BIRCH_BOAT)));
        DispenserBlock.registerBehavior((ItemLike)Items.JUNGLE_BOAT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.JUNGLE_BOAT)));
        DispenserBlock.registerBehavior((ItemLike)Items.DARK_OAK_BOAT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.DARK_OAK_BOAT)));
        DispenserBlock.registerBehavior((ItemLike)Items.ACACIA_BOAT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.ACACIA_BOAT)));
        DispenserBlock.registerBehavior((ItemLike)Items.CHERRY_BOAT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.CHERRY_BOAT)));
        DispenserBlock.registerBehavior((ItemLike)Items.MANGROVE_BOAT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.MANGROVE_BOAT)));
        DispenserBlock.registerBehavior((ItemLike)Items.PALE_OAK_BOAT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.PALE_OAK_BOAT)));
        DispenserBlock.registerBehavior((ItemLike)Items.BAMBOO_RAFT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.BAMBOO_RAFT)));
        DispenserBlock.registerBehavior((ItemLike)Items.OAK_CHEST_BOAT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.OAK_CHEST_BOAT)));
        DispenserBlock.registerBehavior((ItemLike)Items.SPRUCE_CHEST_BOAT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.SPRUCE_CHEST_BOAT)));
        DispenserBlock.registerBehavior((ItemLike)Items.BIRCH_CHEST_BOAT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.BIRCH_CHEST_BOAT)));
        DispenserBlock.registerBehavior((ItemLike)Items.JUNGLE_CHEST_BOAT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.JUNGLE_CHEST_BOAT)));
        DispenserBlock.registerBehavior((ItemLike)Items.DARK_OAK_CHEST_BOAT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.DARK_OAK_CHEST_BOAT)));
        DispenserBlock.registerBehavior((ItemLike)Items.ACACIA_CHEST_BOAT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.ACACIA_CHEST_BOAT)));
        DispenserBlock.registerBehavior((ItemLike)Items.CHERRY_CHEST_BOAT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.CHERRY_CHEST_BOAT)));
        DispenserBlock.registerBehavior((ItemLike)Items.MANGROVE_CHEST_BOAT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.MANGROVE_CHEST_BOAT)));
        DispenserBlock.registerBehavior((ItemLike)Items.PALE_OAK_CHEST_BOAT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.PALE_OAK_CHEST_BOAT)));
        DispenserBlock.registerBehavior((ItemLike)Items.BAMBOO_CHEST_RAFT, (DispenseItemBehavior)((Object)new BoatDispenseItemBehavior(EntityType.BAMBOO_CHEST_RAFT)));
        DefaultDispenseItemBehavior dispenseitembehavior = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            public ItemStack execute(BlockSource p_338193_, ItemStack p_338600_) {
                DispensibleContainerItem dispensiblecontaineritem = (DispensibleContainerItem)((Object)p_338600_.getItem());
                BlockPos blockpos = p_338193_.pos().relative((Direction)p_338193_.state().getValue((Property)DispenserBlock.FACING));
                ServerLevel level = p_338193_.level();
                if (dispensiblecontaineritem.emptyContents(null, level, blockpos, null, p_338600_)) {
                    dispensiblecontaineritem.checkExtraContent(null, level, p_338600_, blockpos);
                    return this.consumeWithRemainder(p_338193_, p_338600_, new ItemStack(Items.BUCKET));
                }
                return this.defaultDispenseItemBehavior.dispense(p_338193_, p_338600_);
            }
        };
        DispenserBlock.registerBehavior((ItemLike)Items.LAVA_BUCKET, (DispenseItemBehavior)dispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.WATER_BUCKET, (DispenseItemBehavior)dispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.POWDER_SNOW_BUCKET, (DispenseItemBehavior)dispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.SALMON_BUCKET, (DispenseItemBehavior)dispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.COD_BUCKET, (DispenseItemBehavior)dispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.PUFFERFISH_BUCKET, (DispenseItemBehavior)dispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.TROPICAL_FISH_BUCKET, (DispenseItemBehavior)dispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.AXOLOTL_BUCKET, (DispenseItemBehavior)dispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.TADPOLE_BUCKET, (DispenseItemBehavior)dispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)Items.BUCKET, (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            public ItemStack execute(BlockSource p_338297_, ItemStack p_338735_) {
                BlockPos blockpos;
                ServerLevel levelaccessor = p_338297_.level();
                BlockState blockstate = levelaccessor.getBlockState(blockpos = p_338297_.pos().relative((Direction)p_338297_.state().getValue((Property)DispenserBlock.FACING)));
                Block block = blockstate.getBlock();
                if (block instanceof BucketPickup) {
                    BucketPickup bucketpickup = (BucketPickup)((Object)block);
                    ItemStack itemstack = bucketpickup.pickupBlock(null, levelaccessor, blockpos, blockstate);
                    if (itemstack.isEmpty()) {
                        return super.execute(p_338297_, p_338735_);
                    }
                    levelaccessor.gameEvent(null, GameEvent.FLUID_PICKUP, blockpos);
                    Item item = itemstack.getItem();
                    return this.consumeWithRemainder(p_338297_, p_338735_, new ItemStack(item));
                }
                return super.execute(p_338297_, p_338735_);
            }
        });
        DispenserBlock.registerBehavior((ItemLike)Items.FLINT_AND_STEEL, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource p_338850_, ItemStack p_338251_) {
                ServerLevel serverlevel = p_338850_.level();
                this.setSuccess(true);
                Direction direction = (Direction)p_338850_.state().getValue((Property)DispenserBlock.FACING);
                BlockPos blockpos = p_338850_.pos().relative(direction);
                BlockState blockstate = serverlevel.getBlockState(blockpos);
                if (BaseFireBlock.canBePlacedAt(serverlevel, blockpos, direction)) {
                    serverlevel.setBlockAndUpdate(blockpos, BaseFireBlock.getState((BlockGetter)((Object)serverlevel), blockpos));
                    serverlevel.gameEvent(null, GameEvent.BLOCK_PLACE, blockpos);
                } else {
                    BlockState blockState = blockstate.getToolModifiedState(new UseOnContext((Level)serverlevel, null, InteractionHand.MAIN_HAND, p_338251_, new BlockHitResult(blockpos.getCenter(), direction.getOpposite(), blockpos, false)), ItemAbilities.FIRESTARTER_LIGHT, false);
                    if (blockState instanceof BlockState) {
                        BlockState blockstate2 = blockState;
                        serverlevel.setBlockAndUpdate(blockpos, blockstate2);
                        serverlevel.gameEvent(null, GameEvent.BLOCK_CHANGE, blockpos);
                    } else if (blockstate.isFlammable((BlockGetter)((Object)serverlevel), blockpos, ((Direction)p_338850_.state().getValue((Property)DispenserBlock.FACING)).getOpposite())) {
                        if (blockstate.onCaughtFire(serverlevel, blockpos, ((Direction)p_338850_.state().getValue((Property)DispenserBlock.FACING)).getOpposite(), null)) {
                            if (blockstate.getBlock() instanceof TntBlock) {
                                serverlevel.removeBlock(blockpos, false);
                            }
                        } else {
                            this.setSuccess(false);
                        }
                    } else {
                        this.setSuccess(false);
                    }
                }
                if (this.isSuccess()) {
                    p_338251_.hurtAndBreak(1, serverlevel, null, p_397432_ -> {});
                }
                return p_338251_;
            }
        });
        DispenserBlock.registerBehavior((ItemLike)Items.BONE_MEAL, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource p_338386_, ItemStack p_338526_) {
                this.setSuccess(true);
                ServerLevel level = p_338386_.level();
                BlockPos blockpos = p_338386_.pos().relative((Direction)p_338386_.state().getValue((Property)DispenserBlock.FACING));
                if (!BoneMealItem.growCrop(p_338526_, level, blockpos) && !BoneMealItem.growWaterPlant(p_338526_, level, blockpos, null)) {
                    this.setSuccess(false);
                } else if (!level.isClientSide) {
                    level.levelEvent(1505, blockpos, 15);
                }
                return p_338526_;
            }
        });
        DispenserBlock.registerBehavior((ItemLike)Blocks.TNT, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource p_338494_, ItemStack p_338444_) {
                ServerLevel serverlevel = p_338494_.level();
                if (!serverlevel.getGameRules().getBoolean(GameRules.RULE_TNT_EXPLODES)) {
                    this.setSuccess(false);
                    return p_338444_;
                }
                BlockPos blockpos = p_338494_.pos().relative((Direction)p_338494_.state().getValue((Property)DispenserBlock.FACING));
                PrimedTnt primedtnt = new PrimedTnt((Level)serverlevel, (double)blockpos.getX() + 0.5, (double)blockpos.getY(), (double)blockpos.getZ() + 0.5, null);
                serverlevel.addFreshEntity((Entity)primedtnt);
                serverlevel.playSound(null, primedtnt.getX(), primedtnt.getY(), primedtnt.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                serverlevel.gameEvent(null, GameEvent.ENTITY_PLACE, blockpos);
                p_338444_.shrink(1);
                this.setSuccess(true);
                return p_338444_;
            }
        });
        DispenserBlock.registerBehavior((ItemLike)Items.WITHER_SKELETON_SKULL, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource p_302450_, ItemStack p_123524_) {
                ServerLevel level = p_302450_.level();
                Direction direction = (Direction)p_302450_.state().getValue((Property)DispenserBlock.FACING);
                BlockPos blockpos = p_302450_.pos().relative(direction);
                if (level.isEmptyBlock(blockpos) && WitherSkullBlock.canSpawnMob((Level)level, (BlockPos)blockpos, (ItemStack)p_123524_)) {
                    level.setBlock(blockpos, (BlockState)((Object)Blocks.WITHER_SKELETON_SKULL.defaultBlockState().setValue((Property)SkullBlock.ROTATION, Integer.valueOf(RotationSegment.convertToSegment((Direction)direction)))), 3);
                    level.gameEvent(null, GameEvent.BLOCK_PLACE, blockpos);
                    BlockEntity blockentity = level.getBlockEntity(blockpos);
                    if (blockentity instanceof SkullBlockEntity) {
                        WitherSkullBlock.checkSpawn((Level)level, (BlockPos)blockpos, (SkullBlockEntity)((SkullBlockEntity)blockentity));
                    }
                    p_123524_.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(EquipmentDispenseItemBehavior.dispenseEquipment(p_302450_, p_123524_));
                }
                return p_123524_;
            }
        });
        DispenserBlock.registerBehavior((ItemLike)Blocks.CARVED_PUMPKIN, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource p_302430_, ItemStack p_123462_) {
                ServerLevel level = p_302430_.level();
                BlockPos blockpos = p_302430_.pos().relative((Direction)p_302430_.state().getValue((Property)DispenserBlock.FACING));
                CarvedPumpkinBlock carvedpumpkinblock = (CarvedPumpkinBlock)Blocks.CARVED_PUMPKIN;
                if (level.isEmptyBlock(blockpos) && carvedpumpkinblock.canSpawnGolem((LevelReader)((Object)level), blockpos)) {
                    if (!level.isClientSide) {
                        level.setBlock(blockpos, carvedpumpkinblock.defaultBlockState(), 3);
                        level.gameEvent(null, GameEvent.BLOCK_PLACE, blockpos);
                    }
                    p_123462_.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(EquipmentDispenseItemBehavior.dispenseEquipment(p_302430_, p_123462_));
                }
                return p_123462_;
            }
        });
        DispenserBlock.registerBehavior((ItemLike)Blocks.SHULKER_BOX.asItem(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
        for (DyeColor dyecolor : DyeColor.values()) {
            DispenserBlock.registerBehavior((ItemLike)ShulkerBoxBlock.getBlockByColor((DyeColor)dyecolor).asItem(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
        }
        DispenserBlock.registerBehavior((ItemLike)Items.GLASS_BOTTLE.asItem(), (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            private ItemStack takeLiquid(BlockSource p_397959_, ItemStack p_397930_, ItemStack p_397455_) {
                p_397959_.level().gameEvent(null, GameEvent.FLUID_PICKUP, p_397959_.pos());
                return this.consumeWithRemainder(p_397959_, p_397930_, p_397455_);
            }

            public ItemStack execute(BlockSource p_302463_, ItemStack p_123530_) {
                this.setSuccess(false);
                ServerLevel serverlevel = p_302463_.level();
                BlockPos blockpos = p_302463_.pos().relative((Direction)p_302463_.state().getValue((Property)DispenserBlock.FACING));
                BlockState blockstate = serverlevel.getBlockState(blockpos);
                if (blockstate.is(BlockTags.BEEHIVES, p_397621_ -> p_397621_.hasProperty((Property)BeehiveBlock.HONEY_LEVEL) && p_397621_.getBlock() instanceof BeehiveBlock) && (Integer)blockstate.getValue((Property)BeehiveBlock.HONEY_LEVEL) >= 5) {
                    ((BeehiveBlock)((Object)blockstate.getBlock())).releaseBeesAndResetHoneyLevel(serverlevel, blockstate, blockpos, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
                    this.setSuccess(true);
                    return this.takeLiquid(p_302463_, p_123530_, new ItemStack(Items.HONEY_BOTTLE));
                }
                if (serverlevel.getFluidState(blockpos).is(FluidTags.WATER)) {
                    this.setSuccess(true);
                    return this.takeLiquid(p_302463_, p_123530_, PotionContents.createItemStack(Items.POTION, Potions.WATER));
                }
                return super.execute(p_302463_, p_123530_);
            }
        });
        DispenserBlock.registerBehavior((ItemLike)Items.GLOWSTONE, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            public ItemStack execute(BlockSource p_302425_, ItemStack p_123536_) {
                Direction direction = (Direction)p_302425_.state().getValue((Property)DispenserBlock.FACING);
                BlockPos blockpos = p_302425_.pos().relative(direction);
                ServerLevel level = p_302425_.level();
                BlockState blockstate = level.getBlockState(blockpos);
                this.setSuccess(true);
                if (blockstate.is(Blocks.RESPAWN_ANCHOR)) {
                    if ((Integer)blockstate.getValue((Property)RespawnAnchorBlock.CHARGE) != 4) {
                        RespawnAnchorBlock.charge(null, (Level)level, (BlockPos)blockpos, (BlockState)blockstate);
                        p_123536_.shrink(1);
                    } else {
                        this.setSuccess(false);
                    }
                    return p_123536_;
                }
                return super.execute(p_302425_, p_123536_);
            }
        });
        DispenserBlock.registerBehavior((ItemLike)Items.SHEARS.asItem(), (DispenseItemBehavior)((Object)new ShearsDispenseItemBehavior()));
        DispenserBlock.registerBehavior((ItemLike)Items.BRUSH.asItem(), (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource p_302452_, ItemStack p_123542_) {
                BlockPos blockpos;
                ServerLevel serverlevel = p_302452_.level();
                List list = serverlevel.getEntitiesOfClass(Armadillo.class, new AABB(blockpos = p_302452_.pos().relative((Direction)p_302452_.state().getValue((Property)DispenserBlock.FACING))), EntitySelector.NO_SPECTATORS);
                if (list.isEmpty()) {
                    this.setSuccess(false);
                    return p_123542_;
                }
                for (Armadillo armadillo : list) {
                    if (!armadillo.brushOffScute()) continue;
                    p_123542_.hurtAndBreak(16, serverlevel, null, p_397327_ -> {});
                    return p_123542_;
                }
                this.setSuccess(false);
                return p_123542_;
            }
        });
        DispenserBlock.registerBehavior((ItemLike)Items.HONEYCOMB, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            public ItemStack execute(BlockSource p_302433_, ItemStack p_123548_) {
                BlockPos blockpos = p_302433_.pos().relative((Direction)p_302433_.state().getValue((Property)DispenserBlock.FACING));
                ServerLevel level = p_302433_.level();
                BlockState blockstate = level.getBlockState(blockpos);
                Optional<BlockState> optional = HoneycombItem.getWaxed(blockstate);
                if (optional.isPresent()) {
                    level.setBlockAndUpdate(blockpos, optional.get());
                    level.levelEvent(3003, blockpos, 0);
                    p_123548_.shrink(1);
                    this.setSuccess(true);
                    return p_123548_;
                }
                return super.execute(p_302433_, p_123548_);
            }
        });
        DispenserBlock.registerBehavior((ItemLike)Items.POTION, (DispenseItemBehavior)new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            public ItemStack execute(BlockSource p_302423_, ItemStack p_123557_) {
                PotionContents potioncontents = p_123557_.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
                if (!potioncontents.is(Potions.WATER)) {
                    return this.defaultDispenseItemBehavior.dispense(p_302423_, p_123557_);
                }
                ServerLevel serverlevel = p_302423_.level();
                BlockPos blockpos = p_302423_.pos();
                BlockPos blockpos1 = p_302423_.pos().relative((Direction)p_302423_.state().getValue((Property)DispenserBlock.FACING));
                if (!serverlevel.getBlockState(blockpos1).is(BlockTags.CONVERTABLE_TO_MUD)) {
                    return this.defaultDispenseItemBehavior.dispense(p_302423_, p_123557_);
                }
                if (!serverlevel.isClientSide) {
                    for (int i = 0; i < 5; ++i) {
                        serverlevel.sendParticles(ParticleTypes.SPLASH, (double)blockpos.getX() + serverlevel.random.nextDouble(), blockpos.getY() + 1, (double)blockpos.getZ() + serverlevel.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                    }
                }
                serverlevel.playSound(null, blockpos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                serverlevel.gameEvent(null, GameEvent.FLUID_PLACE, blockpos);
                serverlevel.setBlockAndUpdate(blockpos1, Blocks.MUD.defaultBlockState());
                return this.consumeWithRemainder(p_302423_, p_123557_, new ItemStack(Items.GLASS_BOTTLE));
            }
        });
        DispenserBlock.registerBehavior((ItemLike)Items.MINECART, (DispenseItemBehavior)((Object)new MinecartDispenseItemBehavior(EntityType.MINECART)));
        DispenserBlock.registerBehavior((ItemLike)Items.CHEST_MINECART, (DispenseItemBehavior)((Object)new MinecartDispenseItemBehavior(EntityType.CHEST_MINECART)));
        DispenserBlock.registerBehavior((ItemLike)Items.FURNACE_MINECART, (DispenseItemBehavior)((Object)new MinecartDispenseItemBehavior(EntityType.FURNACE_MINECART)));
        DispenserBlock.registerBehavior((ItemLike)Items.TNT_MINECART, (DispenseItemBehavior)((Object)new MinecartDispenseItemBehavior(EntityType.TNT_MINECART)));
        DispenserBlock.registerBehavior((ItemLike)Items.HOPPER_MINECART, (DispenseItemBehavior)((Object)new MinecartDispenseItemBehavior(EntityType.HOPPER_MINECART)));
        DispenserBlock.registerBehavior((ItemLike)Items.COMMAND_BLOCK_MINECART, (DispenseItemBehavior)((Object)new MinecartDispenseItemBehavior(EntityType.COMMAND_BLOCK_MINECART)));
    }
}

