/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.IShearable;

public class ShearsDispenseItemBehavior
extends OptionalDispenseItemBehavior {
    protected ItemStack execute(BlockSource p_302443_, ItemStack p_123581_) {
        ServerLevel serverlevel = p_302443_.level();
        if (!serverlevel.isClientSide()) {
            BlockPos blockpos = p_302443_.pos().relative((Direction)p_302443_.state().getValue((Property)DispenserBlock.FACING));
            this.setSuccess(CommonHooks.tryDispenseShearsHarvestBlock((BlockSource)p_302443_, (ItemStack)p_123581_, (ServerLevel)serverlevel, (BlockPos)blockpos) || ShearsDispenseItemBehavior.tryShearBeehive(serverlevel, blockpos) || ShearsDispenseItemBehavior.tryShearLivingEntity(serverlevel, blockpos, p_123581_));
            if (this.isSuccess()) {
                p_123581_.hurtAndBreak(1, serverlevel, null, p_348118_ -> {});
            }
        }
        return p_123581_;
    }

    private static boolean tryShearBeehive(ServerLevel p_123577_, BlockPos p_123578_) {
        int i;
        BlockState blockstate = p_123577_.getBlockState(p_123578_);
        if (blockstate.is(BlockTags.BEEHIVES, p_202454_ -> p_202454_.hasProperty((Property)BeehiveBlock.HONEY_LEVEL) && p_202454_.getBlock() instanceof BeehiveBlock) && (i = ((Integer)blockstate.getValue((Property)BeehiveBlock.HONEY_LEVEL)).intValue()) >= 5) {
            p_123577_.playSound(null, p_123578_, SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            BeehiveBlock.dropHoneycomb(p_123577_, p_123578_);
            ((BeehiveBlock)((Object)blockstate.getBlock())).releaseBeesAndResetHoneyLevel(p_123577_, blockstate, p_123578_, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
            p_123577_.gameEvent(null, GameEvent.SHEAR, p_123578_);
            return true;
        }
        return false;
    }

    private static boolean tryShearLivingEntity(ServerLevel p_123583_, BlockPos p_123584_, ItemStack p_372883_) {
        for (LivingEntity livingentity : p_123583_.getEntitiesOfClass(LivingEntity.class, new AABB(p_123584_), EntitySelector.NO_SPECTATORS)) {
            IShearable shearable;
            if (!(livingentity instanceof IShearable) || !(shearable = (IShearable)livingentity).isShearable(null, p_372883_, (Level)p_123583_, p_123584_)) continue;
            shearable.onSheared(null, p_372883_, (Level)p_123583_, p_123584_).forEach(drop -> shearable.spawnShearedDrop(p_123583_, p_123584_, drop));
            p_123583_.gameEvent(null, GameEvent.SHEAR, p_123584_);
            return true;
        }
        return false;
    }
}

