/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public interface DataProvider {
    public static final AtomicInteger INDENT_WIDTH = new AtomicInteger(2);
    public static final ToIntFunction<String> FIXED_ORDER_FIELDS = (ToIntFunction)Util.make(new Object2IntOpenHashMap(), p_236070_ -> {
        p_236070_.put((Object)"neoforge:conditions", -1);
        p_236070_.put((Object)"neoforge:definition_type", 0);
        p_236070_.put((Object)"neoforge:ingredient_type", 0);
        p_236070_.put((Object)"type", 0);
        p_236070_.put((Object)"parent", 1);
        p_236070_.defaultReturnValue(2);
    });
    public static final Comparator<String> KEY_COMPARATOR = Comparator.comparingInt(FIXED_ORDER_FIELDS).thenComparing(p_236077_ -> p_236077_);
    public static final Logger LOGGER = LogUtils.getLogger();

    public CompletableFuture<?> run(CachedOutput var1);

    public String getName();

    public static <T> CompletableFuture<?> saveAll(CachedOutput p_371210_, Codec<T> p_371684_, PackOutput.PathProvider p_371226_, Map<ResourceLocation, T> p_371316_) {
        return DataProvider.saveAll(p_371210_, p_371684_, arg_0 -> ((PackOutput.PathProvider)p_371226_).json(arg_0), p_371316_);
    }

    public static <T, E> CompletableFuture<?> saveAll(CachedOutput p_387918_, Codec<E> p_387221_, Function<T, Path> p_386916_, Map<T, E> p_388894_) {
        return DataProvider.saveAll(p_387918_, (E p_386289_) -> (JsonElement)p_387221_.encodeStart((DynamicOps)JsonOps.INSTANCE, p_386289_).getOrThrow(), p_386916_, p_388894_);
    }

    public static <T, E> CompletableFuture<?> saveAll(CachedOutput p_388708_, Function<E, JsonElement> p_387101_, Function<T, Path> p_386894_, Map<T, E> p_388538_) {
        return CompletableFuture.allOf((CompletableFuture[])p_388538_.entrySet().stream().map(p_386293_ -> {
            Path path = (Path)p_386894_.apply(p_386293_.getKey());
            JsonElement jsonelement = (JsonElement)p_387101_.apply(p_386293_.getValue());
            return DataProvider.saveStable(p_388708_, jsonelement, path);
        }).toArray(CompletableFuture[]::new));
    }

    public static <T> CompletableFuture<?> saveStable(CachedOutput p_298323_, HolderLookup.Provider p_323556_, Codec<T> p_299231_, T p_298793_, Path p_298236_) {
        RegistryOps registryops = p_323556_.createSerializationContext(JsonOps.INSTANCE);
        return DataProvider.saveStable(p_298323_, registryops, p_299231_, p_298793_, p_298236_);
    }

    public static <T> CompletableFuture<?> saveStable(CachedOutput p_371223_, Codec<T> p_371552_, T p_371267_, Path p_371229_) {
        return DataProvider.saveStable(p_371223_, (DynamicOps<JsonElement>)JsonOps.INSTANCE, p_371552_, p_371267_, p_371229_);
    }

    private static <T> CompletableFuture<?> saveStable(CachedOutput p_371845_, DynamicOps<JsonElement> p_371225_, Codec<T> p_371373_, T p_371681_, Path p_371818_) {
        JsonElement jsonelement = (JsonElement)p_371373_.encodeStart(p_371225_, p_371681_).getOrThrow();
        return DataProvider.saveStable(p_371845_, jsonelement, p_371818_);
    }

    public static CompletableFuture<?> saveStable(CachedOutput p_253653_, JsonElement p_254542_, Path p_254467_) {
        return CompletableFuture.runAsync(() -> {
            try {
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                HashingOutputStream hashingoutputstream = new HashingOutputStream(Hashing.sha1(), (OutputStream)bytearrayoutputstream);
                try (JsonWriter jsonwriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)hashingoutputstream, StandardCharsets.UTF_8));){
                    jsonwriter.setSerializeNulls(false);
                    jsonwriter.setIndent(" ".repeat(Math.max(0, INDENT_WIDTH.get())));
                    GsonHelper.writeValue((JsonWriter)jsonwriter, (JsonElement)p_254542_, KEY_COMPARATOR);
                }
                p_253653_.writeIfNeeded(p_254467_, bytearrayoutputstream.toByteArray(), hashingoutputstream.hash());
            }
            catch (IOException ioexception) {
                LOGGER.error("Failed to save file to {}", (Object)p_254467_, (Object)ioexception);
            }
        }, Util.backgroundExecutor().forName("saveStable"));
    }

    @FunctionalInterface
    public static interface Factory<T extends DataProvider> {
        public T create(PackOutput var1);
    }
}

