/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraft.SuppressForbidden;
import net.minecraft.Util;
import net.minecraft.gametest.framework.GameTestServer;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.JUnitLikeTestReporter;
import net.minecraft.gametest.framework.TestReporter;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.neoforged.neoforge.server.loading.ServerModLoader;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class GameTestMainUtil {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String DEFAULT_UNIVERSE_DIR = "gametestserver";
    private static final String LEVEL_NAME = "gametestworld";
    private static final OptionParser parser = new OptionParser();
    private static final OptionSpec<String> universe = parser.accepts("universe", "The path to where the test server world will be created. Any existing folder will be replaced.").withRequiredArg().defaultsTo((Object)"gametestserver", (Object[])new String[0]);
    private static final OptionSpec<File> report = parser.accepts("report", "Exports results in a junit-like XML report at the given path.").withRequiredArg().ofType(File.class);
    private static final OptionSpec<String> tests = parser.accepts("tests", "Which test(s) to run (namespaced ID selector using wildcards). Empty means run all.").withRequiredArg();
    private static final OptionSpec<Boolean> verify = parser.accepts("verify", "Runs the tests specified with `test` or `testNamespace` 100 times for each 90 degree rotation step").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]);
    private static final OptionSpec<String> packs = parser.accepts("packs", "A folder of datapacks to include in the world").withRequiredArg();
    private static final OptionSpec<Void> help = parser.accepts("help").forHelp();

    @SuppressForbidden(reason="Using System.err due to no bootstrap")
    public static void runGameTestServer(String[] p_397997_, Consumer<String> p_397859_) throws Exception {
        parser.allowsUnrecognizedOptions();
        OptionSet optionset = parser.parse(p_397997_);
        if (optionset.has(help)) {
            parser.printHelpOn((OutputStream)System.err);
        } else {
            if (((Boolean)optionset.valueOf(verify)).booleanValue() && !optionset.has(tests)) {
                LOGGER.error("Please specify a test selection to run the verify option. For example: --verify --tests example:test_something_*");
                System.exit(-1);
            }
            LOGGER.info("Running GameTestMain with cwd '{}', universe path '{}'", (Object)System.getProperty("user.dir"), optionset.valueOf(universe));
            if (optionset.has(report)) {
                GlobalTestReporter.replaceWith((TestReporter)new JUnitLikeTestReporter((File)report.value(optionset)));
            }
            Bootstrap.bootStrap();
            Util.startTimerHackThread();
            ServerModLoader.load();
            String s = (String)optionset.valueOf(universe);
            GameTestMainUtil.createOrResetDir(s);
            p_397859_.accept(s);
            if (optionset.has(packs)) {
                String s1 = (String)optionset.valueOf(packs);
                GameTestMainUtil.copyPacks(s, s1);
            }
            LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = LevelStorageSource.createDefault(Paths.get(s, new String[0])).createAccess(LEVEL_NAME);
            PackRepository packrepository = ServerPacksSource.createPackRepository(levelstoragesource$levelstorageaccess);
            MinecraftServer.spin(p_397467_ -> GameTestServer.create(p_397467_, levelstoragesource$levelstorageaccess, packrepository, GameTestMainUtil.optionalFromOption(optionset, tests), optionset.has(verify)));
        }
    }

    private static Optional<String> optionalFromOption(OptionSet p_397783_, OptionSpec<String> p_397817_) {
        return p_397783_.has(p_397817_) ? Optional.of((String)p_397783_.valueOf(p_397817_)) : Optional.empty();
    }

    private static void createOrResetDir(String p_397547_) throws IOException {
        Path path = Paths.get(p_397547_, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            FileUtils.deleteDirectory((File)path.toFile());
        }
        Files.createDirectories(path, new FileAttribute[0]);
    }

    private static void copyPacks(String p_397379_, String p_397134_) throws IOException {
        Path path1;
        Path path = Paths.get(p_397379_, new String[0]).resolve(LEVEL_NAME).resolve("datapacks");
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        if (Files.exists(path1 = Paths.get(p_397134_, new String[0]), new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(path1);){
                for (Path path2 : stream.toList()) {
                    Path path3 = path.resolve(path2.getFileName());
                    if (Files.isDirectory(path2, new LinkOption[0])) {
                        if (!Files.isRegularFile(path2.resolve("pack.mcmeta"), new LinkOption[0])) continue;
                        FileUtils.copyDirectory((File)path2.toFile(), (File)path3.toFile());
                        LOGGER.info("Included folder pack {}", (Object)path2.getFileName());
                        continue;
                    }
                    if (!path2.toString().endsWith(".zip")) continue;
                    Files.copy(path2, path3, new CopyOption[0]);
                    LOGGER.info("Included zip pack {}", (Object)path2.getFileName());
                }
            }
        }
    }
}

