/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.common.util.InsertingContents;

public class ComponentSerialization {
    public static final Codec<Component> CODEC = Codec.recursive((String)"Component", ComponentSerialization::createCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, Component> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries(CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<Component>> OPTIONAL_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs::optional);
    public static final StreamCodec<RegistryFriendlyByteBuf, Component> TRUSTED_STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistriesTrusted(CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<Component>> TRUSTED_OPTIONAL_STREAM_CODEC = TRUSTED_STREAM_CODEC.apply(ByteBufCodecs::optional);
    public static final StreamCodec<ByteBuf, Component> TRUSTED_CONTEXT_FREE_STREAM_CODEC = ByteBufCodecs.fromCodecTrusted(CODEC);

    public static Codec<Component> flatRestrictedCodec(final int p_394111_) {
        return new Codec<Component>(){

            public <T> DataResult<Pair<Component, T>> decode(DynamicOps<T> p_330684_, T p_331653_) {
                return CODEC.decode(p_330684_, p_331653_).flatMap(p_392612_ -> this.isTooLarge(p_330684_, (Component)p_392612_.getFirst()) ? DataResult.error(() -> "Component was too large: greater than max size " + p_394111_) : DataResult.success((Object)p_392612_));
            }

            public <T> DataResult<T> encode(Component p_330452_, DynamicOps<T> p_330865_, T p_331460_) {
                return CODEC.encodeStart(p_330865_, (Object)p_330452_);
            }

            private <T> boolean isTooLarge(DynamicOps<T> p_393757_, Component p_393963_) {
                DataResult dataresult = CODEC.encodeStart(1.asJsonOps(p_393757_), (Object)p_393963_);
                return dataresult.isSuccess() && GsonHelper.encodesLongerThan((JsonElement)((JsonElement)dataresult.getOrThrow()), (int)p_394111_);
            }

            private static <T> DynamicOps<JsonElement> asJsonOps(DynamicOps<T> p_330749_) {
                Object object;
                if (p_330749_ instanceof RegistryOps) {
                    RegistryOps registryops = (RegistryOps)p_330749_;
                    object = registryops.withParent(JsonOps.INSTANCE);
                } else {
                    object = JsonOps.INSTANCE;
                }
                return object;
            }
        };
    }

    private static MutableComponent createFromList(List<Component> p_304405_) {
        MutableComponent mutablecomponent = p_304405_.get(0).copy();
        for (int i = 1; i < p_304405_.size(); ++i) {
            mutablecomponent.append(p_304405_.get(i));
        }
        return mutablecomponent;
    }

    public static <T extends StringRepresentable, E> MapCodec<E> createLegacyComponentMatcher(T[] p_304815_, Function<T, MapCodec<? extends E>> p_304852_, Function<E, T> p_304510_, String p_307551_) {
        FuzzyCodec<Object> mapcodec = new FuzzyCodec<Object>(Stream.of(p_304815_).map(p_304852_).toList(), p_304601_ -> (MapEncoder)p_304852_.apply((StringRepresentable)p_304510_.apply(p_304601_)));
        Codec codec = StringRepresentable.fromValues(() -> p_304815_);
        MapCodec mapcodec1 = codec.dispatchMap(p_307551_, p_304510_, p_304852_);
        StrictEither<Object> mapcodec2 = new StrictEither<Object>(p_307551_, mapcodec1, mapcodec);
        return ExtraCodecs.orCompressed(mapcodec2, (MapCodec)mapcodec1);
    }

    private static Codec<Component> createCodec(Codec<Component> p_304554_) {
        ComponentContents.Type[] type = new ComponentContents.Type[]{PlainTextContents.TYPE, TranslatableContents.TYPE, KeybindContents.TYPE, ScoreContents.TYPE, SelectorContents.TYPE, NbtContents.TYPE, InsertingContents.TYPE};
        MapCodec mapcodec = ComponentSerialization.createLegacyComponentMatcher((StringRepresentable[])type, ComponentContents.Type::codec, ComponentContents::type, (String)"type");
        Codec codec = RecordCodecBuilder.create(p_337494_ -> p_337494_.group((App)mapcodec.forGetter(Component::getContents), (App)ExtraCodecs.nonEmptyList((Codec)p_304554_.listOf()).optionalFieldOf("extra", List.of()).forGetter(Component::getSiblings), (App)Style.Serializer.MAP_CODEC.forGetter(Component::getStyle)).apply((Applicative)p_337494_, MutableComponent::new));
        return Codec.either((Codec)Codec.either((Codec)Codec.STRING, (Codec)ExtraCodecs.nonEmptyList((Codec)p_304554_.listOf())), (Codec)codec).xmap(p_304547_ -> (Component)p_304547_.map(p_304568_ -> (Component)p_304568_.map(Component::literal, ComponentSerialization::createFromList), p_304887_ -> p_304887_), p_304501_ -> {
            String s = p_304501_.tryCollapseToString();
            return s != null ? Either.left((Object)Either.left((Object)s)) : Either.right((Object)p_304501_);
        });
    }

    static class FuzzyCodec<T>
    extends MapCodec<T> {
        private final List<MapCodec<? extends T>> codecs;
        private final Function<T, MapEncoder<? extends T>> encoderGetter;

        public FuzzyCodec(List<MapCodec<? extends T>> p_304495_, Function<T, MapEncoder<? extends T>> p_304594_) {
            this.codecs = p_304495_;
            this.encoderGetter = p_304594_;
        }

        public <S> DataResult<T> decode(DynamicOps<S> p_304922_, MapLike<S> p_304447_) {
            for (MapDecoder mapDecoder : this.codecs) {
                DataResult dataresult = mapDecoder.decode(p_304922_, p_304447_);
                if (!dataresult.result().isPresent()) continue;
                return dataresult;
            }
            return DataResult.error(() -> "No matching codec found");
        }

        public <S> RecordBuilder<S> encode(T p_304409_, DynamicOps<S> p_304945_, RecordBuilder<S> p_304823_) {
            MapEncoder<? extends T> mapencoder = this.encoderGetter.apply(p_304409_);
            return mapencoder.encode(p_304409_, p_304945_, p_304823_);
        }

        public <S> Stream<S> keys(DynamicOps<S> p_304770_) {
            return this.codecs.stream().flatMap(p_304401_ -> p_304401_.keys(p_304770_)).distinct();
        }

        public String toString() {
            return "FuzzyCodec[" + String.valueOf(this.codecs) + "]";
        }
    }

    static class StrictEither<T>
    extends MapCodec<T> {
        private final String typeFieldName;
        private final MapCodec<T> typed;
        private final MapCodec<T> fuzzy;

        public StrictEither(String p_307439_, MapCodec<T> p_307644_, MapCodec<T> p_307415_) {
            this.typeFieldName = p_307439_;
            this.typed = p_307644_;
            this.fuzzy = p_307415_;
        }

        public <O> DataResult<T> decode(DynamicOps<O> p_307279_, MapLike<O> p_307655_) {
            return p_307655_.get(this.typeFieldName) != null ? this.typed.decode(p_307279_, p_307655_) : this.fuzzy.decode(p_307279_, p_307655_);
        }

        public <O> RecordBuilder<O> encode(T p_307352_, DynamicOps<O> p_307510_, RecordBuilder<O> p_307297_) {
            return this.fuzzy.encode(p_307352_, p_307510_, p_307297_);
        }

        public <T1> Stream<T1> keys(DynamicOps<T1> p_307616_) {
            return Stream.concat(this.typed.keys(p_307616_), this.fuzzy.keys(p_307616_)).distinct();
        }
    }
}

