/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.codec;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.Utf8String;
import net.minecraft.network.VarInt;
import net.minecraft.network.VarLong;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegistryManager;
import net.neoforged.neoforge.registries.holdersets.HolderSetType;
import net.neoforged.neoforge.registries.holdersets.ICustomHolderSet;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public interface ByteBufCodecs {
    public static final int MAX_INITIAL_COLLECTION_SIZE = 65536;
    public static final StreamCodec<ByteBuf, Boolean> BOOL = new StreamCodec<ByteBuf, Boolean>(){

        public Boolean decode(ByteBuf p_320813_) {
            return p_320813_.readBoolean();
        }

        public void encode(ByteBuf p_319896_, Boolean p_320251_) {
            p_319896_.writeBoolean(p_320251_.booleanValue());
        }
    };
    public static final StreamCodec<ByteBuf, Byte> BYTE = new StreamCodec<ByteBuf, Byte>(){

        public Byte decode(ByteBuf p_320628_) {
            return p_320628_.readByte();
        }

        public void encode(ByteBuf p_320364_, Byte p_320618_) {
            p_320364_.writeByte((int)p_320618_.byteValue());
        }
    };
    public static final StreamCodec<ByteBuf, Float> ROTATION_BYTE = BYTE.map(Mth::unpackDegrees, Mth::packDegrees);
    public static final StreamCodec<ByteBuf, Short> SHORT = new StreamCodec<ByteBuf, Short>(){

        public Short decode(ByteBuf p_320513_) {
            return p_320513_.readShort();
        }

        public void encode(ByteBuf p_320028_, Short p_320388_) {
            p_320028_.writeShort((int)p_320388_.shortValue());
        }
    };
    public static final StreamCodec<ByteBuf, Integer> UNSIGNED_SHORT = new StreamCodec<ByteBuf, Integer>(){

        public Integer decode(ByteBuf p_320319_) {
            return p_320319_.readUnsignedShort();
        }

        public void encode(ByteBuf p_320669_, Integer p_320205_) {
            p_320669_.writeShort(p_320205_.intValue());
        }
    };
    public static final StreamCodec<ByteBuf, Integer> INT = new StreamCodec<ByteBuf, Integer>(){

        public Integer decode(ByteBuf p_320253_) {
            return p_320253_.readInt();
        }

        public void encode(ByteBuf p_320753_, Integer p_330380_) {
            p_320753_.writeInt(p_330380_.intValue());
        }
    };
    public static final StreamCodec<ByteBuf, Integer> VAR_INT = new StreamCodec<ByteBuf, Integer>(){

        public Integer decode(ByteBuf p_320759_) {
            return VarInt.read((ByteBuf)p_320759_);
        }

        public void encode(ByteBuf p_320314_, Integer p_341414_) {
            VarInt.write((ByteBuf)p_320314_, (int)p_341414_);
        }
    };
    public static final StreamCodec<ByteBuf, OptionalInt> OPTIONAL_VAR_INT = VAR_INT.map(p_378955_ -> p_378955_ == 0 ? OptionalInt.empty() : OptionalInt.of(p_378955_ - 1), p_378954_ -> p_378954_.isPresent() ? p_378954_.getAsInt() + 1 : 0);
    public static final StreamCodec<ByteBuf, Long> LONG = new StreamCodec<ByteBuf, Long>(){

        public Long decode(ByteBuf p_320635_) {
            return p_320635_.readLong();
        }

        public void encode(ByteBuf p_320545_, Long p_341419_) {
            p_320545_.writeLong(p_341419_.longValue());
        }
    };
    public static final StreamCodec<ByteBuf, Long> VAR_LONG = new StreamCodec<ByteBuf, Long>(){

        public Long decode(ByteBuf p_320259_) {
            return VarLong.read((ByteBuf)p_320259_);
        }

        public void encode(ByteBuf p_320199_, Long p_376100_) {
            VarLong.write((ByteBuf)p_320199_, (long)p_376100_);
        }
    };
    public static final StreamCodec<ByteBuf, Float> FLOAT = new StreamCodec<ByteBuf, Float>(){

        public Float decode(ByteBuf p_320599_) {
            return Float.valueOf(p_320599_.readFloat());
        }

        public void encode(ByteBuf p_320880_, Float p_376495_) {
            p_320880_.writeFloat(p_376495_.floatValue());
        }
    };
    public static final StreamCodec<ByteBuf, Double> DOUBLE = new StreamCodec<ByteBuf, Double>(){

        public Double decode(ByteBuf p_319947_) {
            return p_319947_.readDouble();
        }

        public void encode(ByteBuf p_320370_, Double p_376267_) {
            p_320370_.writeDouble(p_376267_.doubleValue());
        }
    };
    public static final StreamCodec<ByteBuf, byte[]> BYTE_ARRAY = new StreamCodec<ByteBuf, byte[]>(){

        public byte[] decode(ByteBuf p_332176_) {
            return FriendlyByteBuf.readByteArray(p_332176_);
        }

        public void encode(ByteBuf p_331068_, byte[] p_376625_) {
            FriendlyByteBuf.writeByteArray(p_331068_, p_376625_);
        }
    };
    public static final StreamCodec<ByteBuf, long[]> LONG_ARRAY = new StreamCodec<ByteBuf, long[]>(){

        public long[] decode(ByteBuf p_341393_) {
            return FriendlyByteBuf.readLongArray(p_341393_);
        }

        public void encode(ByteBuf p_340857_, long[] p_404761_) {
            FriendlyByteBuf.writeLongArray(p_340857_, p_404761_);
        }
    };
    public static final StreamCodec<ByteBuf, String> STRING_UTF8 = ByteBufCodecs.stringUtf8(Short.MAX_VALUE);
    public static final StreamCodec<ByteBuf, Tag> TAG = ByteBufCodecs.tagCodec(() -> NbtAccounter.create(0x200000L));
    public static final StreamCodec<ByteBuf, Tag> TRUSTED_TAG = ByteBufCodecs.tagCodec(NbtAccounter::unlimitedHeap);
    public static final StreamCodec<ByteBuf, CompoundTag> COMPOUND_TAG = ByteBufCodecs.compoundTagCodec(() -> NbtAccounter.create(0x200000L));
    public static final StreamCodec<ByteBuf, CompoundTag> TRUSTED_COMPOUND_TAG = ByteBufCodecs.compoundTagCodec(NbtAccounter::unlimitedHeap);
    public static final StreamCodec<ByteBuf, Optional<CompoundTag>> OPTIONAL_COMPOUND_TAG = new StreamCodec<ByteBuf, Optional<CompoundTag>>(){

        public Optional<CompoundTag> decode(ByteBuf p_324083_) {
            return Optional.ofNullable(FriendlyByteBuf.readNbt(p_324083_));
        }

        public void encode(ByteBuf p_324192_, Optional<CompoundTag> p_405809_) {
            FriendlyByteBuf.writeNbt(p_324192_, p_405809_.orElse(null));
        }
    };
    public static final StreamCodec<ByteBuf, Vector3f> VECTOR3F = new StreamCodec<ByteBuf, Vector3f>(){

        public Vector3f decode(ByteBuf p_324595_) {
            return FriendlyByteBuf.readVector3f(p_324595_);
        }

        public void encode(ByteBuf p_324147_, Vector3f p_404783_) {
            FriendlyByteBuf.writeVector3f(p_324147_, p_404783_);
        }
    };
    public static final StreamCodec<ByteBuf, Quaternionf> QUATERNIONF = new StreamCodec<ByteBuf, Quaternionf>(){

        public Quaternionf decode(ByteBuf p_324220_) {
            return FriendlyByteBuf.readQuaternion(p_324220_);
        }

        public void encode(ByteBuf p_323874_, Quaternionf p_405659_) {
            FriendlyByteBuf.writeQuaternion(p_323874_, p_405659_);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> CONTAINER_ID = new StreamCodec<ByteBuf, Integer>(){

        public Integer decode(ByteBuf p_331901_) {
            return FriendlyByteBuf.readContainerId(p_331901_);
        }

        public void encode(ByteBuf p_331539_, Integer p_405397_) {
            FriendlyByteBuf.writeContainerId(p_331539_, p_405397_);
        }
    };
    public static final StreamCodec<ByteBuf, PropertyMap> GAME_PROFILE_PROPERTIES = new StreamCodec<ByteBuf, PropertyMap>(){
        private static final int MAX_PROPERTY_NAME_LENGTH = 64;
        private static final int MAX_PROPERTY_VALUE_LENGTH = Short.MAX_VALUE;
        private static final int MAX_PROPERTY_SIGNATURE_LENGTH = 1024;
        private static final int MAX_PROPERTIES = 16;

        public PropertyMap decode(ByteBuf p_404660_) {
            int i = ByteBufCodecs.readCount(p_404660_, 16);
            PropertyMap propertymap = new PropertyMap();
            for (int j = 0; j < i; ++j) {
                String s = Utf8String.read((ByteBuf)p_404660_, (int)64);
                String s1 = Utf8String.read((ByteBuf)p_404660_, (int)Short.MAX_VALUE);
                String s2 = (String)FriendlyByteBuf.readNullable(p_404660_, p_412669_ -> Utf8String.read((ByteBuf)p_412669_, (int)1024));
                Property property = new Property(s, s1, s2);
                propertymap.put((Object)property.name(), (Object)property);
            }
            return propertymap;
        }

        public void encode(ByteBuf p_404856_, PropertyMap p_412748_) {
            ByteBufCodecs.writeCount(p_404856_, p_412748_.size(), 16);
            for (Property property : p_412748_.values()) {
                Utf8String.write((ByteBuf)p_404856_, (CharSequence)property.name(), (int)64);
                Utf8String.write((ByteBuf)p_404856_, (CharSequence)property.value(), (int)Short.MAX_VALUE);
                FriendlyByteBuf.writeNullable(p_404856_, property.signature(), (p_412215_, p_412085_) -> Utf8String.write((ByteBuf)p_412215_, (CharSequence)p_412085_, (int)1024));
            }
        }
    };
    public static final StreamCodec<ByteBuf, GameProfile> GAME_PROFILE = new StreamCodec<ByteBuf, GameProfile>(){

        public GameProfile decode(ByteBuf p_412429_) {
            UUID uuid = (UUID)UUIDUtil.STREAM_CODEC.decode((Object)p_412429_);
            String s = Utf8String.read((ByteBuf)p_412429_, (int)16);
            GameProfile gameprofile = new GameProfile(uuid, s);
            gameprofile.getProperties().putAll((Multimap)GAME_PROFILE_PROPERTIES.decode((Object)p_412429_));
            return gameprofile;
        }

        public void encode(ByteBuf p_412749_, GameProfile p_412071_) {
            UUIDUtil.STREAM_CODEC.encode((Object)p_412749_, (Object)p_412071_.getId());
            Utf8String.write((ByteBuf)p_412749_, (CharSequence)p_412071_.getName(), (int)16);
            GAME_PROFILE_PROPERTIES.encode((Object)p_412749_, (Object)p_412071_.getProperties());
        }
    };

    public static StreamCodec<ByteBuf, byte[]> byteArray(final int p_324182_) {
        return new StreamCodec<ByteBuf, byte[]>(){

            public byte[] decode(ByteBuf p_320167_) {
                return FriendlyByteBuf.readByteArray(p_320167_, p_324182_);
            }

            public void encode(ByteBuf p_320240_, byte[] p_341316_) {
                if (p_341316_.length > p_324182_) {
                    throw new EncoderException("ByteArray with size " + p_341316_.length + " is bigger than allowed " + p_324182_);
                }
                FriendlyByteBuf.writeByteArray(p_320240_, p_341316_);
            }
        };
    }

    public static StreamCodec<ByteBuf, String> stringUtf8(final int p_320693_) {
        return new StreamCodec<ByteBuf, String>(){

            public String decode(ByteBuf p_376272_) {
                return Utf8String.read((ByteBuf)p_376272_, (int)p_320693_);
            }

            public void encode(ByteBuf p_376553_, String p_404954_) {
                Utf8String.write((ByteBuf)p_376553_, (CharSequence)p_404954_, (int)p_320693_);
            }
        };
    }

    public static StreamCodec<ByteBuf, Tag> tagCodec(final Supplier<NbtAccounter> p_320506_) {
        return new StreamCodec<ByteBuf, Tag>(){

            public Tag decode(ByteBuf p_404669_) {
                Tag tag = FriendlyByteBuf.readNbt(p_404669_, (NbtAccounter)p_320506_.get());
                if (tag == null) {
                    throw new DecoderException("Expected non-null compound tag");
                }
                return tag;
            }

            public void encode(ByteBuf p_405814_, Tag p_405114_) {
                if (p_405114_ == EndTag.INSTANCE) {
                    throw new EncoderException("Expected non-null compound tag");
                }
                FriendlyByteBuf.writeNbt(p_405814_, p_405114_);
            }
        };
    }

    public static StreamCodec<ByteBuf, CompoundTag> compoundTagCodec(Supplier<NbtAccounter> p_331128_) {
        return ByteBufCodecs.tagCodec(p_331128_).map(p_339405_ -> {
            if (p_339405_ instanceof CompoundTag) {
                CompoundTag compoundtag = (CompoundTag)p_339405_;
                return compoundtag;
            }
            throw new DecoderException("Not a compound tag: " + String.valueOf(p_339405_));
        }, p_330975_ -> p_330975_);
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodecTrusted(Codec<T> p_331105_) {
        return ByteBufCodecs.fromCodec(p_331105_, NbtAccounter::unlimitedHeap);
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodec(Codec<T> p_320615_) {
        return ByteBufCodecs.fromCodec(p_320615_, () -> NbtAccounter.create(0x200000L));
    }

    public static <T> StreamCodec<ByteBuf, T> fromCodec(Codec<T> p_330943_, Supplier<NbtAccounter> p_330382_) {
        return ByteBufCodecs.tagCodec(p_330382_).map(p_337514_ -> p_330943_.parse((DynamicOps)NbtOps.INSTANCE, p_337514_).getOrThrow(p_339407_ -> new DecoderException("Failed to decode: " + p_339407_ + " " + String.valueOf(p_337514_))), p_337516_ -> (Tag)p_330943_.encodeStart((DynamicOps)NbtOps.INSTANCE, p_337516_).getOrThrow(p_339409_ -> new EncoderException("Failed to encode: " + p_339409_ + " " + String.valueOf(p_337516_))));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistriesTrusted(Codec<T> p_331713_) {
        return ByteBufCodecs.fromCodecWithRegistries(p_331713_, NbtAccounter::unlimitedHeap);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistries(Codec<T> p_323797_) {
        return ByteBufCodecs.fromCodecWithRegistries(p_323797_, () -> NbtAccounter.create(0x200000L));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> fromCodecWithRegistries(final Codec<T> p_331571_, Supplier<NbtAccounter> p_331922_) {
        final StreamCodec<ByteBuf, Tag> streamcodec = ByteBufCodecs.tagCodec(p_331922_);
        return new StreamCodec<RegistryFriendlyByteBuf, T>(){

            public T decode(RegistryFriendlyByteBuf p_404843_) {
                Tag tag = (Tag)streamcodec.decode((Object)p_404843_);
                RegistryOps registryops = p_404843_.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
                return p_331571_.parse((DynamicOps)registryops, (Object)tag).getOrThrow(p_405349_ -> new DecoderException("Failed to decode: " + p_405349_ + " " + String.valueOf(tag)));
            }

            public void encode(RegistryFriendlyByteBuf p_405226_, T p_404884_) {
                RegistryOps registryops = p_405226_.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
                Tag tag = (Tag)p_331571_.encodeStart((DynamicOps)registryops, p_404884_).getOrThrow(p_404687_ -> new EncoderException("Failed to encode: " + p_404687_ + " " + String.valueOf(p_404884_)));
                streamcodec.encode((Object)p_405226_, (Object)tag);
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec<B, Optional<V>> optional(final StreamCodec<B, V> p_320522_) {
        return new StreamCodec<B, Optional<V>>(){

            public Optional<V> decode(B p_332082_) {
                return p_332082_.readBoolean() ? Optional.of(p_320522_.decode(p_332082_)) : Optional.empty();
            }

            public void encode(B p_331172_, Optional<V> p_404749_) {
                if (p_404749_.isPresent()) {
                    p_331172_.writeBoolean(true);
                    p_320522_.encode(p_331172_, p_404749_.get());
                } else {
                    p_331172_.writeBoolean(false);
                }
            }
        };
    }

    public static int readCount(ByteBuf p_331813_, int p_331668_) {
        int i = VarInt.read((ByteBuf)p_331813_);
        if (i > p_331668_) {
            throw new DecoderException(i + " elements exceeded max size of: " + p_331668_);
        }
        return i;
    }

    public static void writeCount(ByteBuf p_330907_, int p_330535_, int p_331447_) {
        if (p_330535_ > p_331447_) {
            throw new EncoderException(p_330535_ + " elements exceeded max size of: " + p_331447_);
        }
        VarInt.write((ByteBuf)p_330907_, (int)p_330535_);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> collection(IntFunction<C> p_320579_, StreamCodec<? super B, V> p_319970_) {
        return ByteBufCodecs.collection(p_320579_, p_319970_, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> collection(final IntFunction<C> p_332198_, final StreamCodec<? super B, V> p_332183_, final int p_332173_) {
        return new StreamCodec<B, C>(){

            public C decode(B p_340809_) {
                int i = ByteBufCodecs.readCount(p_340809_, p_332173_);
                Collection c = (Collection)p_332198_.apply(Math.min(i, 65536));
                for (int j = 0; j < i; ++j) {
                    c.add(p_332183_.decode(p_340809_));
                }
                return c;
            }

            public void encode(B p_341417_, C p_405491_) {
                ByteBufCodecs.writeCount(p_341417_, p_405491_.size(), p_332173_);
                for (Object v : p_405491_) {
                    p_332183_.encode(p_341417_, v);
                }
            }
        };
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec.CodecOperation<B, V, C> collection(IntFunction<C> p_319808_) {
        return p_319785_ -> ByteBufCodecs.collection(p_319808_, p_319785_);
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, List<V>> list() {
        return p_320272_ -> ByteBufCodecs.collection(ArrayList::new, p_320272_);
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, List<V>> list(int p_330434_) {
        return p_329871_ -> ByteBufCodecs.collection(ArrayList::new, p_329871_, p_330434_);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> map(IntFunction<? extends M> p_320265_, StreamCodec<? super B, K> p_320113_, StreamCodec<? super B, V> p_320275_) {
        return ByteBufCodecs.map(p_320265_, p_320113_, p_320275_, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> map(final IntFunction<? extends M> p_331325_, final StreamCodec<? super B, K> p_331975_, final StreamCodec<? super B, V> p_331254_, final int p_330938_) {
        return new StreamCodec<B, M>(){

            public void encode(B p_364013_, M p_405567_) {
                ByteBufCodecs.writeCount(p_364013_, p_405567_.size(), p_330938_);
                p_405567_.forEach((p_404179_, p_404180_) -> {
                    p_331975_.encode(p_364013_, p_404179_);
                    p_331254_.encode(p_364013_, p_404180_);
                });
            }

            public M decode(B p_363037_) {
                int i = ByteBufCodecs.readCount(p_363037_, p_330938_);
                Map m = (Map)p_331325_.apply(Math.min(i, 65536));
                for (int j = 0; j < i; ++j) {
                    Object k = p_331975_.decode(p_363037_);
                    Object v = p_331254_.decode(p_363037_);
                    m.put(k, v);
                }
                return m;
            }
        };
    }

    public static <B extends ByteBuf, L, R> StreamCodec<B, Either<L, R>> either(final StreamCodec<? super B, L> p_331983_, final StreamCodec<? super B, R> p_332156_) {
        return new StreamCodec<B, Either<L, R>>(){

            public Either<L, R> decode(B p_376474_) {
                return p_376474_.readBoolean() ? Either.left((Object)p_331983_.decode(p_376474_)) : Either.right((Object)p_332156_.decode(p_376474_));
            }

            public void encode(B p_376188_, Either<L, R> p_405857_) {
                p_405857_.ifLeft(p_405092_ -> {
                    p_376188_.writeBoolean(true);
                    p_331983_.encode(p_376188_, p_405092_);
                }).ifRight(p_405207_ -> {
                    p_376188_.writeBoolean(false);
                    p_332156_.encode(p_376188_, p_405207_);
                });
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, V> lengthPrefixed(final int p_412184_, final BiFunction<B, ByteBuf, B> p_412396_) {
        return p_412029_ -> new StreamCodec<B, V>(){

            public V decode(B p_405291_) {
                int i = VarInt.read(p_405291_);
                if (i > p_412184_) {
                    throw new DecoderException("Buffer size " + i + " is larger than allowed limit of " + p_412184_);
                }
                int j = p_405291_.readerIndex();
                ByteBuf b = (ByteBuf)p_412396_.apply(p_405291_, p_405291_.slice(j, i));
                p_405291_.readerIndex(j + i);
                return p_412029_.decode((Object)b);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void encode(B p_405748_, V p_376503_) {
                ByteBuf b = (ByteBuf)p_412396_.apply(p_405748_, p_405748_.alloc().buffer());
                try {
                    p_412029_.encode((Object)b, p_376503_);
                    int i = b.readableBytes();
                    if (i > p_412184_) {
                        throw new EncoderException("Buffer size " + i + " is  larger than allowed limit of " + p_412184_);
                    }
                    VarInt.write(p_405748_, (int)i);
                    p_405748_.writeBytes(b);
                }
                finally {
                    b.release();
                }
            }
        };
    }

    public static <V> StreamCodec.CodecOperation<RegistryFriendlyByteBuf, V, V> lengthPrefixed(int p_412757_) {
        return ByteBufCodecs.lengthPrefixed(p_412757_, (p_412025_, p_412026_) -> new RegistryFriendlyByteBuf((ByteBuf)p_412026_, p_412025_.registryAccess()));
    }

    public static <T> StreamCodec<ByteBuf, T> idMapper(final IntFunction<T> p_320877_, final ToIntFunction<T> p_319985_) {
        return new StreamCodec<ByteBuf, T>(){

            public T decode(ByteBuf p_412599_) {
                int i = VarInt.read((ByteBuf)p_412599_);
                return p_320877_.apply(i);
            }

            public void encode(ByteBuf p_412292_, T p_405860_) {
                int i = p_319985_.applyAsInt(p_405860_);
                VarInt.write((ByteBuf)p_412292_, (int)i);
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> idMapper(IdMap<T> p_319822_) {
        return ByteBufCodecs.idMapper(arg_0 -> p_319822_.byIdOrThrow(arg_0), arg_0 -> p_319822_.getIdOrThrow(arg_0));
    }

    private static <T, R> StreamCodec<RegistryFriendlyByteBuf, R> registry(final ResourceKey<? extends Registry<T>> p_319942_, final Function<Registry<T>, IdMap<R>> p_320353_) {
        return new StreamCodec<RegistryFriendlyByteBuf, R>(){

            private IdMap<R> getRegistryOrThrow(RegistryFriendlyByteBuf p_405445_) {
                return (IdMap)p_320353_.apply(ByteBufCodecs.getSyncableRegistryOrThrow(p_405445_, p_319942_));
            }

            public R decode(RegistryFriendlyByteBuf p_376912_) {
                int i = VarInt.read((ByteBuf)p_376912_);
                return this.getRegistryOrThrow(p_376912_).byIdOrThrow(i);
            }

            public void encode(RegistryFriendlyByteBuf p_376382_, R p_412065_) {
                int i = this.getRegistryOrThrow(p_376382_).getIdOrThrow(p_412065_);
                VarInt.write((ByteBuf)p_376382_, (int)i);
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> registry(ResourceKey<? extends Registry<T>> p_320404_) {
        return ByteBufCodecs.registry(p_320404_, p_332056_ -> p_332056_);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holderRegistry(ResourceKey<? extends Registry<T>> p_320387_) {
        return ByteBufCodecs.registry(p_320387_, Registry::asHolderIdMap);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holder(final ResourceKey<? extends Registry<T>> p_320391_, final StreamCodec<? super RegistryFriendlyByteBuf, T> p_320595_) {
        return new StreamCodec<RegistryFriendlyByteBuf, Holder<T>>(){
            private static final int DIRECT_HOLDER_ID = 0;

            private IdMap<Holder<T>> getRegistryOrThrow(RegistryFriendlyByteBuf p_412135_) {
                return ByteBufCodecs.getSyncableRegistryOrThrow(p_412135_, p_320391_).asHolderIdMap();
            }

            public Holder<T> decode(RegistryFriendlyByteBuf p_405489_) {
                int i = VarInt.read((ByteBuf)p_405489_);
                return i == 0 ? Holder.direct(p_320595_.decode((Object)p_405489_)) : (Holder)this.getRegistryOrThrow(p_405489_).byIdOrThrow(i - 1);
            }

            public void encode(RegistryFriendlyByteBuf p_405433_, Holder<T> p_412205_) {
                switch (p_412205_.kind()) {
                    case REFERENCE: {
                        int i = this.getRegistryOrThrow(p_405433_).getIdOrThrow(p_412205_);
                        VarInt.write((ByteBuf)p_405433_, (int)(i + 1));
                        break;
                    }
                    case DIRECT: {
                        VarInt.write((ByteBuf)p_405433_, (int)0);
                        p_320595_.encode((Object)p_405433_, p_412205_.value());
                    }
                }
            }
        };
    }

    private static <T> Registry<T> getSyncableRegistryOrThrow(RegistryFriendlyByteBuf buffer, ResourceKey<? extends Registry<T>> registryKey) {
        Registry registry = buffer.registryAccess().lookupOrThrow(registryKey);
        if (RegistryManager.isNonSyncedBuiltInRegistry((Registry)registry)) {
            throw new CodecException("Cannot use ID syncing for non-synced built-in registry: " + String.valueOf(registry.key()));
        }
        return registry;
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>> holderSet(final ResourceKey<? extends Registry<T>> p_332137_) {
        return new StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>>(){
            private static final int NAMED_SET = -1;
            private final StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holderCodec;
            private final Map<HolderSetType, StreamCodec<RegistryFriendlyByteBuf, ? extends ICustomHolderSet<T>>> holderSetCodecs;
            {
                this.holderCodec = ByteBufCodecs.holderRegistry(p_332137_);
                this.holderSetCodecs = new ConcurrentHashMap();
            }

            private StreamCodec<RegistryFriendlyByteBuf, ? extends ICustomHolderSet<T>> holderSetCodec(HolderSetType type) {
                return this.holderSetCodecs.computeIfAbsent(type, key -> key.makeStreamCodec(p_332137_));
            }

            private <H extends ICustomHolderSet<T>> H cast(ICustomHolderSet<T> holderSet) {
                return (H)holderSet;
            }

            public HolderSet<T> decode(RegistryFriendlyByteBuf p_412249_) {
                int i = VarInt.read((ByteBuf)p_412249_) - 1;
                if (i < -1) {
                    return (HolderSet)this.holderSetCodec((HolderSetType)NeoForgeRegistries.HOLDER_SET_TYPES.byIdOrThrow(-2 - i)).decode((Object)p_412249_);
                }
                if (i == -1) {
                    Registry registry = p_412249_.registryAccess().lookupOrThrow(p_332137_);
                    return (HolderSet)registry.get(TagKey.create((ResourceKey)p_332137_, (ResourceLocation)((ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)p_412249_)))).orElseThrow();
                }
                ArrayList<Holder> list = new ArrayList<Holder>(Math.min(i, 65536));
                for (int j = 0; j < i; ++j) {
                    list.add((Holder)this.holderCodec.decode((Object)p_412249_));
                }
                return HolderSet.direct(list);
            }

            public void encode(RegistryFriendlyByteBuf p_412573_, HolderSet<T> p_412568_) {
                if (p_412573_.getConnectionType().isNeoForge() && p_412568_ instanceof ICustomHolderSet) {
                    ICustomHolderSet customHolderSet = (ICustomHolderSet)p_412568_;
                    VarInt.write((ByteBuf)p_412573_, (int)(-1 - NeoForgeRegistries.HOLDER_SET_TYPES.getId(customHolderSet.type())));
                    this.holderSetCodec(customHolderSet.type()).encode((Object)p_412573_, this.cast(customHolderSet));
                    return;
                }
                Optional optional = p_412568_.unwrapKey();
                if (optional.isPresent()) {
                    VarInt.write((ByteBuf)p_412573_, (int)0);
                    ResourceLocation.STREAM_CODEC.encode((Object)p_412573_, (Object)optional.get().location());
                } else {
                    VarInt.write((ByteBuf)p_412573_, (int)(p_412568_.size() + 1));
                    for (Holder holder : p_412568_) {
                        this.holderCodec.encode((Object)p_412573_, (Object)holder);
                    }
                }
            }
        };
    }
}

