/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.holdersets.ICustomHolderSet;

public class HolderSetCodec<E>
implements Codec<HolderSet<E>> {
    private final ResourceKey<? extends Registry<E>> registryKey;
    private final Codec<Holder<E>> elementCodec;
    private final Codec<List<Holder<E>>> homogenousListCodec;
    private final Codec<Either<TagKey<E>, List<Holder<E>>>> registryAwareCodec;
    private final Codec<ICustomHolderSet<E>> forgeDispatchCodec;
    private final Codec<Either<ICustomHolderSet<E>, Either<TagKey<E>, List<Holder<E>>>>> combinedCodec;

    private static <E> Codec<List<Holder<E>>> homogenousList(Codec<Holder<E>> p_206668_, boolean p_206669_) {
        Codec codec = p_206668_.listOf().validate(ExtraCodecs.ensureHomogenous(Holder::kind));
        return p_206669_ ? codec : ExtraCodecs.compactListCodec(p_206668_, (Codec)codec);
    }

    public static <E> Codec<HolderSet<E>> create(ResourceKey<? extends Registry<E>> p_206686_, Codec<Holder<E>> p_206687_, boolean p_206688_) {
        return new HolderSetCodec<E>(p_206686_, p_206687_, p_206688_);
    }

    private HolderSetCodec(ResourceKey<? extends Registry<E>> p_206660_, Codec<Holder<E>> p_206661_, boolean p_206662_) {
        this.registryKey = p_206660_;
        this.elementCodec = p_206661_;
        this.homogenousListCodec = HolderSetCodec.homogenousList(p_206661_, p_206662_);
        this.registryAwareCodec = Codec.either((Codec)TagKey.hashedCodec(p_206660_), this.homogenousListCodec);
        this.forgeDispatchCodec = NeoForgeRegistries.HOLDER_SET_TYPES.byNameCodec().dispatch(ICustomHolderSet::type, type -> type.makeCodec(p_206660_, p_206661_, p_206662_));
        this.combinedCodec = Codec.either(this.forgeDispatchCodec, this.registryAwareCodec);
    }

    public <T> DataResult<Pair<HolderSet<E>, T>> decode(DynamicOps<T> p_206696_, T p_206697_) {
        RegistryOps registryops;
        Optional optional;
        if (p_206696_ instanceof RegistryOps && (optional = (registryops = (RegistryOps)p_206696_).getter(this.registryKey)).isPresent()) {
            HolderGetter holdergetter = optional.get();
            return this.combinedCodec.decode(p_206696_, p_206697_).flatMap(p_337522_ -> {
                DataResult dataresult = (DataResult)((Either)p_337522_.getFirst()).map(DataResult::success, tagOrList -> (DataResult)tagOrList.map(p_332559_ -> HolderSetCodec.lookupTag(holdergetter, p_332559_), p_332564_ -> DataResult.success(HolderSet.direct(p_332564_))));
                return dataresult.map(p_332563_ -> Pair.of((Object)p_332563_, (Object)p_337522_.getSecond()));
            });
        }
        return this.decodeWithoutRegistry(p_206696_, p_206697_);
    }

    private static <E> DataResult<HolderSet<E>> lookupTag(HolderGetter<E> p_332757_, TagKey<E> p_332743_) {
        return p_332757_.get(p_332743_).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Missing tag: '" + String.valueOf(p_332743_.location()) + "' in '" + String.valueOf(p_332743_.registry().location()) + "'"));
    }

    public <T> DataResult<T> encode(HolderSet<E> p_206674_, DynamicOps<T> p_206675_, T p_206676_) {
        RegistryOps registryops;
        Optional optional;
        if (p_206675_ instanceof RegistryOps && (optional = (registryops = (RegistryOps)p_206675_).owner(this.registryKey)).isPresent()) {
            if (!p_206674_.canSerializeIn(optional.get())) {
                return DataResult.error(() -> "HolderSet " + String.valueOf(p_206674_) + " is not valid in current registry set");
            }
            if (p_206674_ instanceof ICustomHolderSet) {
                ICustomHolderSet customHolderSet = (ICustomHolderSet)p_206674_;
                return this.forgeDispatchCodec.encode((Object)customHolderSet, p_206675_, p_206676_);
            }
            return this.registryAwareCodec.encode((Object)p_206674_.unwrap().mapRight(List::copyOf), p_206675_, p_206676_);
        }
        return this.encodeWithoutRegistry(p_206674_, p_206675_, p_206676_);
    }

    private <T> DataResult<Pair<HolderSet<E>, T>> decodeWithoutRegistry(DynamicOps<T> p_206671_, T p_206672_) {
        return this.elementCodec.listOf().decode(p_206671_, p_206672_).flatMap(p_206666_ -> {
            ArrayList<Holder.Direct> list = new ArrayList<Holder.Direct>();
            for (Holder holder : (List)p_206666_.getFirst()) {
                if (!(holder instanceof Holder.Direct)) {
                    return DataResult.error(() -> "Can't decode element " + String.valueOf(holder) + " without registry");
                }
                Holder.Direct direct = (Holder.Direct)holder;
                list.add(direct);
            }
            return DataResult.success((Object)new Pair(HolderSet.direct(list), p_206666_.getSecond()));
        });
    }

    private <T> DataResult<T> encodeWithoutRegistry(HolderSet<E> p_206690_, DynamicOps<T> p_206691_, T p_206692_) {
        return this.homogenousListCodec.encode(p_206690_.stream().toList(), p_206691_, p_206692_);
    }
}

