/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.ServerFunctionLibrary;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleReloadInstance;
import net.minecraft.util.Unit;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.conditions.ConditionContext;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.resource.ContextAwareReloadListener;
import org.slf4j.Logger;

public class ReloadableServerResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final CompletableFuture<Unit> DATA_RELOAD_INITIAL_TASK = CompletableFuture.completedFuture(Unit.INSTANCE);
    private final ReloadableServerRegistries.Holder fullRegistryHolder;
    private final Commands commands;
    private final RecipeManager recipes;
    private final ServerAdvancementManager advancements;
    private final ServerFunctionLibrary functionLibrary;
    private final List<Registry.PendingTags<?>> postponedTags;
    private final HolderLookup.Provider registryLookup;
    private final ConditionContext context;

    private ReloadableServerResources(LayeredRegistryAccess<RegistryLayer> p_362982_, HolderLookup.Provider p_361583_, FeatureFlagSet p_250695_, Commands.CommandSelection p_206858_, List<Registry.PendingTags<?>> p_362624_, int p_206859_) {
        this.fullRegistryHolder = new ReloadableServerRegistries.Holder((HolderLookup.Provider)p_362982_.compositeAccess());
        this.postponedTags = p_362624_;
        this.recipes = new RecipeManager(p_361583_);
        this.commands = new Commands(p_206858_, CommandBuildContext.simple((HolderLookup.Provider)p_361583_, (FeatureFlagSet)p_250695_));
        this.advancements = new ServerAdvancementManager(p_361583_);
        this.functionLibrary = new ServerFunctionLibrary(p_206859_, this.commands.getDispatcher());
        this.registryLookup = p_361583_;
        this.context = new ConditionContext(this.postponedTags, (RegistryAccess)p_362982_.compositeAccess(), p_250695_);
    }

    public ServerFunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public ReloadableServerRegistries.Holder fullRegistries() {
        return this.fullRegistryHolder;
    }

    public RecipeManager getRecipeManager() {
        return this.recipes;
    }

    public Commands getCommands() {
        return this.commands;
    }

    public ServerAdvancementManager getAdvancements() {
        return this.advancements;
    }

    public List<PreparableReloadListener> listeners() {
        return List.of(this.recipes, this.functionLibrary, this.advancements);
    }

    public ICondition.IContext getConditionContext() {
        return this.context;
    }

    public HolderLookup.Provider getRegistryLookup() {
        return this.registryLookup;
    }

    public static CompletableFuture<ReloadableServerResources> loadResources(ResourceManager p_248588_, LayeredRegistryAccess<RegistryLayer> p_335667_, List<Registry.PendingTags<?>> p_363739_, FeatureFlagSet p_250212_, Commands.CommandSelection p_249301_, int p_251126_, Executor p_249136_, Executor p_249601_) {
        return ReloadableServerRegistries.reload(p_335667_, p_363739_, p_248588_, p_249136_).thenCompose(p_359514_ -> {
            ReloadableServerResources reloadableserverresources = new ReloadableServerResources(p_359514_.layers(), p_359514_.lookupWithUpdatedTags(), p_250212_, p_249301_, p_363739_, p_251126_);
            List listeners = EventHooks.onResourceReload((ReloadableServerResources)reloadableserverresources, (RegistryAccess)p_359514_.layers().compositeAccess());
            for (PreparableReloadListener rl : listeners) {
                if (!(rl instanceof ContextAwareReloadListener)) continue;
                ContextAwareReloadListener carl = (ContextAwareReloadListener)rl;
                carl.injectContext((ICondition.IContext)reloadableserverresources.context, reloadableserverresources.registryLookup);
            }
            return ((CompletableFuture)SimpleReloadInstance.create((ResourceManager)p_248588_, (List)listeners, (Executor)p_249136_, (Executor)p_249601_, DATA_RELOAD_INITIAL_TASK, (boolean)LOGGER.isDebugEnabled()).done().thenRun(() -> {
                reloadableserverresources.context.clear();
                listeners.forEach(rl -> {
                    if (rl instanceof ContextAwareReloadListener) {
                        ContextAwareReloadListener srl = (ContextAwareReloadListener)rl;
                        srl.injectContext(ICondition.IContext.EMPTY, (HolderLookup.Provider)RegistryAccess.EMPTY);
                    }
                });
            })).thenApply(p_214306_ -> reloadableserverresources);
        });
    }

    public void updateStaticRegistryTags() {
        this.postponedTags.forEach(Registry.PendingTags::apply);
        NeoForge.EVENT_BUS.post((Event)new TagsUpdatedEvent(this.registryLookup, false, false));
    }
}

