/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.RecipeBookType;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.internal.NeoForgeProxy;

public final class RecipeBookSettings {
    public static final StreamCodec<FriendlyByteBuf, RecipeBookSettings> STREAM_CODEC = StreamCodec.ofMember(RecipeBookSettings::write, RecipeBookSettings::read);
    private static final Map<RecipeBookType, Pair<String, String>> TAG_FIELDS = CommonHooks.buildRecipeBookTypeTagFields((Map)ImmutableMap.of((Object)((Object)RecipeBookType.CRAFTING), (Object)Pair.of((Object)"isGuiOpen", (Object)"isFilteringCraftable"), (Object)((Object)RecipeBookType.FURNACE), (Object)Pair.of((Object)"isFurnaceGuiOpen", (Object)"isFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.BLAST_FURNACE), (Object)Pair.of((Object)"isBlastingFurnaceGuiOpen", (Object)"isBlastingFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.SMOKER), (Object)Pair.of((Object)"isSmokerGuiOpen", (Object)"isSmokerFilteringCraftable")));
    private final Map<RecipeBookType, TypeSettings> states;

    private RecipeBookSettings(Map<RecipeBookType, TypeSettings> p_12730_) {
        this.states = p_12730_;
    }

    public RecipeBookSettings() {
        this(new EnumMap<RecipeBookType, TypeSettings>(RecipeBookType.class));
    }

    private TypeSettings getSettings(RecipeBookType p_380129_) {
        return this.states.getOrDefault((Object)p_380129_, TypeSettings.DEFAULT);
    }

    private void updateSettings(RecipeBookType p_379381_, UnaryOperator<TypeSettings> p_379491_) {
        this.states.compute(p_379381_, (p_379060_, p_379061_) -> {
            if (p_379061_ == null) {
                p_379061_ = TypeSettings.DEFAULT;
            }
            if ((p_379061_ = (TypeSettings)p_379491_.apply((TypeSettings)p_379061_)).equals(TypeSettings.DEFAULT)) {
                p_379061_ = null;
            }
            return p_379061_;
        });
    }

    public boolean isOpen(RecipeBookType p_12735_) {
        return this.getSettings((RecipeBookType)p_12735_).open;
    }

    public void setOpen(RecipeBookType p_12737_, boolean p_12738_) {
        this.updateSettings(p_12737_, p_379063_ -> p_379063_.setOpen(p_12738_));
    }

    public boolean isFiltering(RecipeBookType p_12755_) {
        return this.getSettings((RecipeBookType)p_12755_).filtering;
    }

    public void setFiltering(RecipeBookType p_12757_, boolean p_12758_) {
        this.updateSettings(p_12757_, p_379058_ -> p_379058_.setFiltering(p_12758_));
    }

    private static RecipeBookSettings read(FriendlyByteBuf p_12753_) {
        EnumMap<RecipeBookType, TypeSettings> map = new EnumMap<RecipeBookType, TypeSettings>(RecipeBookType.class);
        for (RecipeBookType recipebooktype : NeoForgeProxy.INSTANCE.getFilteredRecipeBookTypeValues()) {
            boolean flag = p_12753_.readBoolean();
            boolean flag1 = p_12753_.readBoolean();
            if (!flag && !flag1) continue;
            map.put(recipebooktype, new TypeSettings(flag, flag1));
        }
        return new RecipeBookSettings(map);
    }

    private void write(FriendlyByteBuf p_12762_) {
        for (RecipeBookType recipebooktype : RecipeBookType.values()) {
            TypeSettings recipebooksettings$typesettings = this.states.getOrDefault((Object)recipebooktype, TypeSettings.DEFAULT);
            p_12762_.writeBoolean(recipebooksettings$typesettings.open);
            p_12762_.writeBoolean(recipebooksettings$typesettings.filtering);
        }
    }

    public static RecipeBookSettings read(CompoundTag p_12742_) {
        EnumMap<RecipeBookType, TypeSettings> map = new EnumMap<RecipeBookType, TypeSettings>(RecipeBookType.class);
        TAG_FIELDS.forEach((p_409178_, p_409179_) -> {
            boolean flag = p_12742_.getBooleanOr((String)p_409179_.getFirst(), TypeSettings.DEFAULT.open());
            boolean flag1 = p_12742_.getBooleanOr((String)p_409179_.getSecond(), TypeSettings.DEFAULT.filtering());
            if (flag || flag1) {
                map.put((RecipeBookType)((Object)p_409178_), new TypeSettings(flag, flag1));
            }
        });
        return new RecipeBookSettings(map);
    }

    public void write(CompoundTag p_12760_) {
        TAG_FIELDS.forEach((p_379051_, p_379052_) -> {
            TypeSettings recipebooksettings$typesettings = this.states.getOrDefault(p_379051_, TypeSettings.DEFAULT);
            p_12760_.putBoolean((String)p_379052_.getFirst(), recipebooksettings$typesettings.open);
            p_12760_.putBoolean((String)p_379052_.getSecond(), recipebooksettings$typesettings.filtering);
        });
    }

    public RecipeBookSettings copy() {
        return new RecipeBookSettings(new EnumMap<RecipeBookType, TypeSettings>(this.states));
    }

    public void replaceFrom(RecipeBookSettings p_12733_) {
        this.states.clear();
        this.states.putAll(p_12733_.states);
    }

    public boolean equals(Object p_12764_) {
        return this == p_12764_ || p_12764_ instanceof RecipeBookSettings && this.states.equals(((RecipeBookSettings)p_12764_).states);
    }

    public int hashCode() {
        return this.states.hashCode();
    }

    record TypeSettings(boolean open, boolean filtering) {
        public static final TypeSettings DEFAULT = new TypeSettings(false, false);

        @Override
        public String toString() {
            return "[open=" + this.open + ", filtering=" + this.filtering + "]";
        }

        public TypeSettings setOpen(boolean p_379785_) {
            return new TypeSettings(p_379785_, this.filtering);
        }

        public TypeSettings setFiltering(boolean p_380039_) {
            return new TypeSettings(this.open, p_380039_);
        }
    }
}

