/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;
import net.neoforged.neoforge.registries.datamaps.builtin.RaidHeroGift;

public class GiveGiftToHero
extends Behavior<Villager> {
    private static final int THROW_GIFT_AT_DISTANCE = 5;
    private static final int MIN_TIME_BETWEEN_GIFTS = 600;
    private static final int MAX_TIME_BETWEEN_GIFTS = 6600;
    private static final int TIME_TO_DELAY_FOR_HEAD_TO_FINISH_TURNING = 20;
    @Deprecated
    private static final Map<ResourceKey<VillagerProfession>, ResourceKey<LootTable>> GIFTS = ImmutableMap.builder().put((Object)VillagerProfession.ARMORER, (Object)BuiltInLootTables.ARMORER_GIFT).put((Object)VillagerProfession.BUTCHER, (Object)BuiltInLootTables.BUTCHER_GIFT).put((Object)VillagerProfession.CARTOGRAPHER, (Object)BuiltInLootTables.CARTOGRAPHER_GIFT).put((Object)VillagerProfession.CLERIC, (Object)BuiltInLootTables.CLERIC_GIFT).put((Object)VillagerProfession.FARMER, (Object)BuiltInLootTables.FARMER_GIFT).put((Object)VillagerProfession.FISHERMAN, (Object)BuiltInLootTables.FISHERMAN_GIFT).put((Object)VillagerProfession.FLETCHER, (Object)BuiltInLootTables.FLETCHER_GIFT).put((Object)VillagerProfession.LEATHERWORKER, (Object)BuiltInLootTables.LEATHERWORKER_GIFT).put((Object)VillagerProfession.LIBRARIAN, (Object)BuiltInLootTables.LIBRARIAN_GIFT).put((Object)VillagerProfession.MASON, (Object)BuiltInLootTables.MASON_GIFT).put((Object)VillagerProfession.SHEPHERD, (Object)BuiltInLootTables.SHEPHERD_GIFT).put((Object)VillagerProfession.TOOLSMITH, (Object)BuiltInLootTables.TOOLSMITH_GIFT).put((Object)VillagerProfession.WEAPONSMITH, (Object)BuiltInLootTables.WEAPONSMITH_GIFT).build();
    private static final float SPEED_MODIFIER = 0.5f;
    private int timeUntilNextGift = 600;
    private boolean giftGivenDuringThisRun;
    private long timeSinceStart;

    public GiveGiftToHero(int p_22992_) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.INTERACTION_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryStatus.VALUE_PRESENT), p_22992_);
    }

    protected boolean checkExtraStartConditions(ServerLevel p_23003_, Villager p_23004_) {
        if (!this.isHeroVisible(p_23004_)) {
            return false;
        }
        if (this.timeUntilNextGift > 0) {
            --this.timeUntilNextGift;
            return false;
        }
        return true;
    }

    protected void start(ServerLevel p_23006_, Villager p_23007_, long p_23008_) {
        this.giftGivenDuringThisRun = false;
        this.timeSinceStart = p_23008_;
        Player player = this.getNearestTargetableHero(p_23007_).get();
        p_23007_.getBrain().setMemory(MemoryModuleType.INTERACTION_TARGET, (Object)player);
        BehaviorUtils.lookAtEntity((LivingEntity)((Object)p_23007_), (LivingEntity)player);
    }

    protected boolean canStillUse(ServerLevel p_23026_, Villager p_23027_, long p_23028_) {
        return this.isHeroVisible(p_23027_) && !this.giftGivenDuringThisRun;
    }

    protected void tick(ServerLevel p_23036_, Villager p_23037_, long p_23038_) {
        Player player = this.getNearestTargetableHero(p_23037_).get();
        BehaviorUtils.lookAtEntity((LivingEntity)((Object)p_23037_), (LivingEntity)player);
        if (this.isWithinThrowingDistance(p_23037_, player)) {
            if (p_23038_ - this.timeSinceStart > 20L) {
                this.throwGift(p_23036_, p_23037_, player);
                this.giftGivenDuringThisRun = true;
            }
        } else {
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)((Object)p_23037_), (Entity)player, (float)0.5f, (int)5);
        }
    }

    protected void stop(ServerLevel p_23046_, Villager p_23047_, long p_23048_) {
        this.timeUntilNextGift = GiveGiftToHero.calculateTimeUntilNextGift(p_23046_);
        p_23047_.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        p_23047_.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        p_23047_.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
    }

    private void throwGift(ServerLevel p_376445_, Villager p_23012_, LivingEntity p_23013_) {
        p_23012_.dropFromGiftLootTable(p_376445_, GiveGiftToHero.getLootTableToThrow(p_23012_), (p_409226_, p_409227_) -> BehaviorUtils.throwItem((LivingEntity)((Object)p_23012_), (ItemStack)p_409227_, (Vec3)p_23013_.position()));
    }

    private static ResourceKey<LootTable> getLootTableToThrow(Villager p_372869_) {
        if (p_372869_.isBaby()) {
            return BuiltInLootTables.BABY_VILLAGER_GIFT;
        }
        RaidHeroGift gift = (RaidHeroGift)p_372869_.getVillagerData().profession().getData(NeoForgeDataMaps.RAID_HERO_GIFTS);
        if (gift != null) {
            return gift.lootTable();
        }
        Optional optional = p_372869_.getVillagerData().profession().unwrapKey();
        return optional.isEmpty() ? BuiltInLootTables.UNEMPLOYED_GIFT : GIFTS.getOrDefault(optional.get(), BuiltInLootTables.UNEMPLOYED_GIFT);
    }

    private boolean isHeroVisible(Villager p_23030_) {
        return this.getNearestTargetableHero(p_23030_).isPresent();
    }

    private Optional<Player> getNearestTargetableHero(Villager p_23040_) {
        return p_23040_.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER).filter(this::isHero);
    }

    private boolean isHero(Player p_23018_) {
        return p_23018_.hasEffect(MobEffects.HERO_OF_THE_VILLAGE);
    }

    private boolean isWithinThrowingDistance(Villager p_23015_, Player p_23016_) {
        BlockPos blockpos = p_23016_.blockPosition();
        BlockPos blockpos1 = p_23015_.blockPosition();
        return blockpos1.closerThan((Vec3i)blockpos, 5.0);
    }

    private static int calculateTimeUntilNextGift(ServerLevel p_22994_) {
        return 600 + p_22994_.random.nextInt(6001);
    }
}

