/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;

public class StartAttacking {
    public static <E extends Mob> BehaviorControl<E> create(TargetFinder<E> p_376450_) {
        return StartAttacking.create((p_376522_, p_24212_) -> true, p_376450_);
    }

    public static <E extends Mob> BehaviorControl<E> create(StartAttackingCondition<E> p_376721_, TargetFinder<E> p_376774_) {
        return BehaviorBuilder.create((T p_258782_) -> p_258782_.group((App)p_258782_.absent(MemoryModuleType.ATTACK_TARGET), (App)p_258782_.registered(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE)).apply((Applicative)p_258782_, (p_258778_, p_258779_) -> (p_375684_, p_375685_, p_375686_) -> {
            if (!p_376721_.test(p_375684_, p_375685_)) {
                return false;
            }
            Optional<LivingEntity> optional = p_376774_.get(p_375684_, p_375685_);
            if (optional.isEmpty()) {
                return false;
            }
            LivingEntity livingentity = optional.get();
            if (!p_375685_.canAttack(livingentity)) {
                return false;
            }
            LivingChangeTargetEvent changeTargetEvent = CommonHooks.onLivingChangeTarget((LivingEntity)p_375685_, (LivingEntity)livingentity, (LivingChangeTargetEvent.ILivingTargetType)LivingChangeTargetEvent.LivingTargetType.BEHAVIOR_TARGET);
            if (changeTargetEvent.isCanceled() || changeTargetEvent.getNewAboutToBeSetTarget() == null) {
                return false;
            }
            p_258778_.set((Object)changeTargetEvent.getNewAboutToBeSetTarget());
            p_258779_.erase();
            return true;
        }));
    }

    @FunctionalInterface
    public static interface StartAttackingCondition<E> {
        public boolean test(ServerLevel var1, E var2);
    }

    @FunctionalInterface
    public static interface TargetFinder<E> {
        public Optional<? extends LivingEntity> get(ServerLevel var1, E var2);
    }
}

