/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.PigVariants;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class Pig
extends Animal
implements ItemSteerable {
    private static final EntityDataAccessor<Integer> DATA_BOOST_TIME = SynchedEntityData.defineId(Pig.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Holder<PigVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(Pig.class, EntityDataSerializers.PIG_VARIANT);
    private final ItemBasedSteering steering;

    public Pig(EntityType<? extends Pig> p_29462_, Level p_29463_) {
        super(p_29462_, p_29463_);
        this.steering = new ItemBasedSteering(this.entityData, DATA_BOOST_TIME);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)((Object)this)));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, p_336182_ -> p_336182_.is(Items.CARROT_ON_A_STICK), false));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, p_335406_ -> p_335406_.is(ItemTags.PIG_FOOD), false));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)((Object)this), Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)((Object)this)));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Player player;
        Entity entity;
        return this.isSaddled() && (entity = this.getFirstPassenger()) instanceof Player && (player = (Player)entity).isHolding(Items.CARROT_ON_A_STICK) ? player : super.getControllingPassenger();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_29480_) {
        if (DATA_BOOST_TIME.equals(p_29480_) && this.level().isClientSide) {
            this.steering.onSynced();
        }
        super.onSyncedDataUpdated(p_29480_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326097_) {
        super.defineSynchedData(p_326097_);
        p_326097_.define(DATA_BOOST_TIME, 0);
        p_326097_.define(DATA_VARIANT_ID, VariantUtils.getDefaultOrAny((RegistryAccess)this.registryAccess(), (ResourceKey)PigVariants.DEFAULT));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_29495_) {
        super.addAdditionalSaveData(p_29495_);
        VariantUtils.writeVariant((CompoundTag)p_29495_, this.getVariant());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_29478_) {
        super.readAdditionalSaveData(p_29478_);
        VariantUtils.readVariant((CompoundTag)p_29478_, (RegistryAccess)this.registryAccess(), Registries.PIG_VARIANT).ifPresent(this::setVariant);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.PIG_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource p_29502_) {
        return SoundEvents.PIG_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PIG_DEATH;
    }

    protected void playStepSound(BlockPos p_29492_, BlockState p_29493_) {
        this.playSound(SoundEvents.PIG_STEP, 0.15f, 1.0f);
    }

    @Override
    public InteractionResult mobInteract(Player p_29489_, InteractionHand p_29490_) {
        boolean flag = this.isFood(p_29489_.getItemInHand(p_29490_));
        if (!flag && this.isSaddled() && !this.isVehicle() && !p_29489_.isSecondaryUseActive()) {
            if (!this.level().isClientSide) {
                p_29489_.startRiding((Entity)((Object)this));
            }
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionresult = super.mobInteract(p_29489_, p_29490_);
        if (!interactionresult.consumesAction()) {
            ItemStack itemstack = p_29489_.getItemInHand(p_29490_);
            return this.isEquippableInSlot(itemstack, EquipmentSlot.SADDLE) ? itemstack.interactLivingEntity(p_29489_, (LivingEntity)((Object)this), p_29490_) : InteractionResult.PASS;
        }
        return interactionresult;
    }

    public boolean canUseSlot(EquipmentSlot p_397991_) {
        return p_397991_ != EquipmentSlot.SADDLE ? super.canUseSlot(p_397991_) : this.isAlive() && !this.isBaby();
    }

    protected boolean canDispenserEquipIntoSlot(EquipmentSlot p_397716_) {
        return p_397716_ == EquipmentSlot.SADDLE || super.canDispenserEquipIntoSlot(p_397716_);
    }

    protected Holder<SoundEvent> getEquipSound(EquipmentSlot p_397377_, ItemStack p_397787_, Equippable p_397153_) {
        return p_397377_ == EquipmentSlot.SADDLE ? SoundEvents.PIG_SADDLE : super.getEquipSound(p_397377_, p_397787_, p_397153_);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity p_29487_) {
        Direction direction = this.getMotionDirection();
        if (direction.getAxis() == Direction.Axis.Y) {
            return super.getDismountLocationForPassenger(p_29487_);
        }
        int[][] aint = DismountHelper.offsetsForDirection((Direction)direction);
        BlockPos blockpos = this.blockPosition();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Pose pose : p_29487_.getDismountPoses()) {
            AABB aabb = p_29487_.getLocalBoundsForPose(pose);
            for (int[] aint1 : aint) {
                blockpos$mutableblockpos.set(blockpos.getX() + aint1[0], blockpos.getY(), blockpos.getZ() + aint1[1]);
                double d0 = this.level().getBlockFloorHeight((BlockPos)blockpos$mutableblockpos);
                if (!DismountHelper.isBlockFloorValid((double)d0)) continue;
                Vec3 vec3 = Vec3.upFromBottomCenterOf((Vec3i)blockpos$mutableblockpos, (double)d0);
                if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)p_29487_, (AABB)aabb.move(vec3))) continue;
                p_29487_.setPose(pose);
                return vec3;
            }
        }
        return super.getDismountLocationForPassenger(p_29487_);
    }

    public void thunderHit(ServerLevel p_29473_, LightningBolt p_29474_) {
        if (p_29473_.getDifficulty() != Difficulty.PEACEFUL && EventHooks.canLivingConvert((LivingEntity)((Object)this), EntityType.ZOMBIFIED_PIGLIN, timer -> {})) {
            ZombifiedPiglin zombifiedpiglin = (ZombifiedPiglin)this.convertTo(EntityType.ZOMBIFIED_PIGLIN, ConversionParams.single((Mob)((Object)this), (boolean)false, (boolean)true), p_409326_ -> {
                if (this.getMainHandItem().isEmpty()) {
                    p_409326_.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack(Items.GOLDEN_SWORD));
                }
                p_409326_.setPersistenceRequired();
                EventHooks.onLivingConvert((LivingEntity)((Object)this), (LivingEntity)p_409326_);
            });
            if (zombifiedpiglin == null) {
                super.thunderHit(p_29473_, p_29474_);
            }
        } else {
            super.thunderHit(p_29473_, p_29474_);
        }
    }

    protected void tickRidden(Player p_278330_, Vec3 p_278267_) {
        super.tickRidden(p_278330_, p_278267_);
        this.setRot(p_278330_.getYRot(), p_278330_.getXRot() * 0.5f);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        this.steering.tickBoost();
    }

    protected Vec3 getRiddenInput(Player p_278309_, Vec3 p_275479_) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    protected float getRiddenSpeed(Player p_278258_) {
        return (float)(this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 0.225 * (double)this.steering.boostFactor());
    }

    public boolean boost() {
        return this.steering.boost(this.getRandom());
    }

    @Nullable
    public Pig getBreedOffspring(ServerLevel p_149001_, AgeableMob p_149002_) {
        Pig pig = EntityType.PIG.create(p_149001_, EntitySpawnReason.BREEDING);
        if (pig != null && p_149002_ instanceof Pig) {
            Pig pig1 = (Pig)p_149002_;
            pig.setVariant(this.random.nextBoolean() ? this.getVariant() : pig1.getVariant());
        }
        return pig;
    }

    @Override
    public boolean isFood(ItemStack p_29508_) {
        return p_29508_.is(ItemTags.PIG_FOOD);
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.6f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    private void setVariant(Holder<PigVariant> p_394027_) {
        this.entityData.set(DATA_VARIANT_ID, p_394027_);
    }

    public Holder<PigVariant> getVariant() {
        return this.entityData.get(DATA_VARIANT_ID);
    }

    @Nullable
    public <T> T get(DataComponentType<? extends T> p_397148_) {
        return (T)(p_397148_ == DataComponents.PIG_VARIANT ? Pig.castComponentValue(p_397148_, this.getVariant()) : super.get(p_397148_));
    }

    protected void applyImplicitComponents(DataComponentGetter p_397068_) {
        this.applyImplicitComponentIfPresent(p_397068_, DataComponents.PIG_VARIANT);
        super.applyImplicitComponents(p_397068_);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> p_397092_, T p_397408_) {
        if (p_397092_ == DataComponents.PIG_VARIANT) {
            this.setVariant((Holder)Pig.castComponentValue((DataComponentType)DataComponents.PIG_VARIANT, p_397408_));
            return true;
        }
        return super.applyImplicitComponent(p_397092_, p_397408_);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_394599_, DifficultyInstance p_393951_, EntitySpawnReason p_393505_, @Nullable SpawnGroupData p_394079_) {
        PigVariants.selectVariantToSpawn((RandomSource)this.random, (RegistryAccess)this.registryAccess(), (SpawnContext)SpawnContext.create((ServerLevelAccessor)p_394599_, (BlockPos)this.blockPosition())).ifPresent(this::setVariant);
        return super.finalizeSpawn(p_394599_, p_393951_, p_393505_, p_394079_);
    }
}

