/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sheep;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.sheep.SheepColorSpawnRules;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class Sheep
extends Animal
implements Shearable {
    private static final int EAT_ANIMATION_TICKS = 40;
    private static final EntityDataAccessor<Byte> DATA_WOOL_ID = SynchedEntityData.defineId(Sheep.class, EntityDataSerializers.BYTE);
    private static final Map<DyeColor, Integer> COLOR_BY_DYE = Util.makeEnumMap(DyeColor.class, Sheep::createSheepColor);
    private static final DyeColor DEFAULT_COLOR = DyeColor.WHITE;
    private static final boolean DEFAULT_SHEARED = false;
    private int eatAnimationTick;
    private EatBlockGoal eatBlockGoal;

    private static int createSheepColor(DyeColor p_405458_) {
        if (p_405458_ == DyeColor.WHITE) {
            return -1644826;
        }
        int i = p_405458_.getTextureDiffuseColor();
        float f = 0.75f;
        return ARGB.color((int)255, (int)Mth.floor((float)((float)ARGB.red((int)i) * 0.75f)), (int)Mth.floor((float)((float)ARGB.green((int)i) * 0.75f)), (int)Mth.floor((float)((float)ARGB.blue((int)i) * 0.75f)));
    }

    public static int getColor(DyeColor p_405314_) {
        return COLOR_BY_DYE.get((Object)p_405314_);
    }

    public Sheep(EntityType<? extends Sheep> p_405549_, Level p_405858_) {
        super(p_405549_, p_405858_);
    }

    protected void registerGoals() {
        this.eatBlockGoal = new EatBlockGoal((Mob)((Object)this));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)((Object)this)));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, p_404879_ -> p_404879_.is(ItemTags.SHEEP_FOOD), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)this.eatBlockGoal);
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)((Object)this), Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)((Object)this)));
    }

    @Override
    public boolean isFood(ItemStack p_404944_) {
        return p_404944_.is(ItemTags.SHEEP_FOOD);
    }

    @Override
    protected void customServerAiStep(ServerLevel p_404959_) {
        this.eatAnimationTick = this.eatBlockGoal.getEatAnimationTick();
        super.customServerAiStep(p_404959_);
    }

    @Override
    public void aiStep() {
        if (this.level().isClientSide) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.aiStep();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.23f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_404828_) {
        super.defineSynchedData(p_404828_);
        p_404828_.define(DATA_WOOL_ID, (byte)0);
    }

    @Override
    public void handleEntityEvent(byte p_405380_) {
        if (p_405380_ == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.handleEntityEvent(p_405380_);
        }
    }

    public float getHeadEatPositionScale(float p_405065_) {
        if (this.eatAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.eatAnimationTick >= 4 && this.eatAnimationTick <= 36) {
            return 1.0f;
        }
        return this.eatAnimationTick < 4 ? ((float)this.eatAnimationTick - p_405065_) / 4.0f : -((float)(this.eatAnimationTick - 40) - p_405065_) / 4.0f;
    }

    public float getHeadEatAngleScale(float p_405017_) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float f = ((float)(this.eatAnimationTick - 4) - p_405017_) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.sin((float)(f * 28.7f));
        }
        return this.eatAnimationTick > 0 ? 0.62831855f : this.getXRot(p_405017_) * ((float)Math.PI / 180);
    }

    @Override
    public InteractionResult mobInteract(Player p_404982_, InteractionHand p_404782_) {
        ItemStack itemstack = p_404982_.getItemInHand(p_404782_);
        return super.mobInteract(p_404982_, p_404782_);
    }

    @Override
    public void shear(ServerLevel p_405075_, SoundSource p_405077_, ItemStack p_405709_) {
        p_405075_.playSound(null, (Entity)((Object)this), SoundEvents.SHEEP_SHEAR, p_405077_, 1.0f, 1.0f);
        this.dropFromShearingLootTable(p_405075_, BuiltInLootTables.SHEAR_SHEEP, p_405709_, (p_405522_, p_405241_) -> {
            for (int i = 0; i < p_405241_.getCount(); ++i) {
                ItemEntity itementity = this.spawnAtLocation((ServerLevel)p_405522_, p_405241_.copyWithCount(1), 1.0f);
                if (itementity == null) continue;
                itementity.setDeltaMovement(itementity.getDeltaMovement().add((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)));
            }
        });
        this.setSheared(true);
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && !this.isSheared() && !this.isBaby();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_405242_) {
        super.addAdditionalSaveData(p_405242_);
        p_405242_.putBoolean("Sheared", this.isSheared());
        p_405242_.store("Color", DyeColor.LEGACY_ID_CODEC, this.getColor());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_404738_) {
        super.readAdditionalSaveData(p_404738_);
        this.setSheared(p_404738_.getBooleanOr("Sheared", false));
        this.setColor(p_404738_.read("Color", DyeColor.LEGACY_ID_CODEC).orElse(DEFAULT_COLOR));
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SHEEP_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource p_405795_) {
        return SoundEvents.SHEEP_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SHEEP_DEATH;
    }

    protected void playStepSound(BlockPos p_405483_, BlockState p_405036_) {
        this.playSound(SoundEvents.SHEEP_STEP, 0.15f, 1.0f);
    }

    public DyeColor getColor() {
        return DyeColor.byId(this.entityData.get(DATA_WOOL_ID) & 0xF);
    }

    public void setColor(DyeColor p_405801_) {
        byte b0 = this.entityData.get(DATA_WOOL_ID);
        this.entityData.set(DATA_WOOL_ID, (byte)(b0 & 0xF0 | p_405801_.getId() & 0xF));
    }

    @Nullable
    public <T> T get(DataComponentType<? extends T> p_405771_) {
        return (T)(p_405771_ == DataComponents.SHEEP_COLOR ? Sheep.castComponentValue(p_405771_, (Object)((Object)this.getColor())) : super.get(p_405771_));
    }

    protected void applyImplicitComponents(DataComponentGetter p_404955_) {
        this.applyImplicitComponentIfPresent(p_404955_, DataComponents.SHEEP_COLOR);
        super.applyImplicitComponents(p_404955_);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> p_405881_, T p_405639_) {
        if (p_405881_ == DataComponents.SHEEP_COLOR) {
            this.setColor((DyeColor)((Object)Sheep.castComponentValue((DataComponentType)DataComponents.SHEEP_COLOR, p_405639_)));
            return true;
        }
        return super.applyImplicitComponent(p_405881_, p_405639_);
    }

    public boolean isSheared() {
        return (this.entityData.get(DATA_WOOL_ID) & 0x10) != 0;
    }

    public void setSheared(boolean p_405726_) {
        byte b0 = this.entityData.get(DATA_WOOL_ID);
        if (p_405726_) {
            this.entityData.set(DATA_WOOL_ID, (byte)(b0 | 0x10));
        } else {
            this.entityData.set(DATA_WOOL_ID, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    public static DyeColor getRandomSheepColor(ServerLevelAccessor p_405871_, BlockPos p_404848_) {
        Holder holder = p_405871_.getBiome(p_404848_);
        return SheepColorSpawnRules.getSheepColor((Holder)holder, (RandomSource)p_405871_.getRandom());
    }

    @Nullable
    public Sheep getBreedOffspring(ServerLevel p_405425_, AgeableMob p_404874_) {
        Sheep sheep = EntityType.SHEEP.create(p_405425_, EntitySpawnReason.BREEDING);
        if (sheep != null) {
            DyeColor dyecolor = this.getColor();
            DyeColor dyecolor1 = ((Sheep)p_404874_).getColor();
            sheep.setColor(DyeColor.getMixedColor(p_405425_, dyecolor, dyecolor1));
        }
        return sheep;
    }

    public void ate() {
        super.ate();
        this.setSheared(false);
        if (this.isBaby()) {
            this.ageUp(60);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_404937_, DifficultyInstance p_405503_, EntitySpawnReason p_405554_, @Nullable SpawnGroupData p_405662_) {
        this.setColor(Sheep.getRandomSheepColor(p_404937_, this.blockPosition()));
        return super.finalizeSpawn(p_404937_, p_405503_, p_405554_, p_405662_);
    }
}

