/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.wither;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class WitherBoss
extends Monster
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> DATA_TARGET_A = SynchedEntityData.defineId(WitherBoss.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_TARGET_B = SynchedEntityData.defineId(WitherBoss.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_TARGET_C = SynchedEntityData.defineId(WitherBoss.class, EntityDataSerializers.INT);
    private static final List<EntityDataAccessor<Integer>> DATA_TARGETS = ImmutableList.of(DATA_TARGET_A, DATA_TARGET_B, DATA_TARGET_C);
    private static final EntityDataAccessor<Integer> DATA_ID_INV = SynchedEntityData.defineId(WitherBoss.class, EntityDataSerializers.INT);
    private static final int INVULNERABLE_TICKS = 220;
    private static final int DEFAULT_INVULNERABLE_TICKS = 0;
    private final float[] xRotHeads = new float[2];
    private final float[] yRotHeads = new float[2];
    private final float[] xRotOHeads = new float[2];
    private final float[] yRotOHeads = new float[2];
    private final int[] nextHeadUpdate = new int[2];
    private final int[] idleHeadUpdates = new int[2];
    private int destroyBlocksTick;
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    private static final TargetingConditions.Selector LIVING_ENTITY_SELECTOR = (p_404443_, p_404444_) -> !p_404443_.getType().is(EntityTypeTags.WITHER_FRIENDS) && p_404443_.attackable();
    private static final TargetingConditions TARGETING_CONDITIONS = TargetingConditions.forCombat().range(20.0).selector(LIVING_ENTITY_SELECTOR);

    public WitherBoss(EntityType<? extends WitherBoss> p_31437_, Level p_31438_) {
        super(p_31437_, p_31438_);
        this.moveControl = new FlyingMoveControl((Mob)((Object)this), 10, false);
        this.setHealth(this.getMaxHealth());
        this.xpReward = 50;
    }

    protected PathNavigation createNavigation(Level p_186262_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)((Object)this), p_186262_);
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        return flyingpathnavigation;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new WitherDoNothingGoal());
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 40, 20.0f));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)((Object)this), Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)((Object)this)));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)((Object)this), LivingEntity.class, 0, false, false, LIVING_ENTITY_SELECTOR));
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326207_) {
        super.defineSynchedData(p_326207_);
        p_326207_.define(DATA_TARGET_A, 0);
        p_326207_.define(DATA_TARGET_B, 0);
        p_326207_.define(DATA_TARGET_C, 0);
        p_326207_.define(DATA_ID_INV, 0);
    }

    public void addAdditionalSaveData(CompoundTag p_31485_) {
        super.addAdditionalSaveData(p_31485_);
        p_31485_.putInt("Invul", this.getInvulnerableTicks());
    }

    public void readAdditionalSaveData(CompoundTag p_31474_) {
        super.readAdditionalSaveData(p_31474_);
        this.setInvulnerableTicks(p_31474_.getIntOr("Invul", 0));
        if (this.hasCustomName()) {
            this.bossEvent.setName(this.getDisplayName());
        }
    }

    public void setCustomName(@Nullable Component p_31476_) {
        super.setCustomName(p_31476_);
        this.bossEvent.setName(this.getDisplayName());
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.WITHER_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_31500_) {
        return SoundEvents.WITHER_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.WITHER_DEATH;
    }

    @Override
    public void aiStep() {
        Entity entity;
        Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.6, 1.0);
        if (!this.level().isClientSide && this.getAlternativeTarget(0) > 0 && (entity = this.level().getEntity(this.getAlternativeTarget(0))) != null) {
            double d0 = vec3.y;
            if (this.getY() < entity.getY() || !this.isPowered() && this.getY() < entity.getY() + 5.0) {
                d0 = Math.max(0.0, d0);
                d0 += 0.3 - d0 * (double)0.6f;
            }
            vec3 = new Vec3(vec3.x, d0, vec3.z);
            Vec3 vec31 = new Vec3(entity.getX() - this.getX(), 0.0, entity.getZ() - this.getZ());
            if (vec31.horizontalDistanceSqr() > 9.0) {
                Vec3 vec32 = vec31.normalize();
                vec3 = vec3.add(vec32.x * 0.3 - vec3.x * 0.6, 0.0, vec32.z * 0.3 - vec3.z * 0.6);
            }
        }
        this.setDeltaMovement(vec3);
        if (vec3.horizontalDistanceSqr() > 0.05) {
            this.setYRot((float)Mth.atan2((double)vec3.z, (double)vec3.x) * 57.295776f - 90.0f);
        }
        super.aiStep();
        for (int i = 0; i < 2; ++i) {
            this.yRotOHeads[i] = this.yRotHeads[i];
            this.xRotOHeads[i] = this.xRotHeads[i];
        }
        for (int j = 0; j < 2; ++j) {
            int k = this.getAlternativeTarget(j + 1);
            Entity entity1 = null;
            if (k > 0) {
                entity1 = this.level().getEntity(k);
            }
            if (entity1 != null) {
                double d9 = this.getHeadX(j + 1);
                double d1 = this.getHeadY(j + 1);
                double d3 = this.getHeadZ(j + 1);
                double d4 = entity1.getX() - d9;
                double d5 = entity1.getEyeY() - d1;
                double d6 = entity1.getZ() - d3;
                double d7 = Math.sqrt(d4 * d4 + d6 * d6);
                float f1 = (float)(Mth.atan2((double)d6, (double)d4) * 180.0 / 3.1415927410125732) - 90.0f;
                float f2 = (float)(-(Mth.atan2((double)d5, (double)d7) * 180.0 / 3.1415927410125732));
                this.xRotHeads[j] = this.rotlerp(this.xRotHeads[j], f2, 40.0f);
                this.yRotHeads[j] = this.rotlerp(this.yRotHeads[j], f1, 10.0f);
                continue;
            }
            this.yRotHeads[j] = this.rotlerp(this.yRotHeads[j], this.yBodyRot, 10.0f);
        }
        boolean flag = this.isPowered();
        for (int l = 0; l < 3; ++l) {
            double d8 = this.getHeadX(l);
            double d10 = this.getHeadY(l);
            double d2 = this.getHeadZ(l);
            float f = 0.3f * this.getScale();
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, d8 + this.random.nextGaussian() * (double)f, d10 + this.random.nextGaussian() * (double)f, d2 + this.random.nextGaussian() * (double)f, 0.0, 0.0, 0.0);
            if (!flag || this.level().random.nextInt(4) != 0) continue;
            this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.7f, (float)0.7f, (float)0.5f), d8 + this.random.nextGaussian() * (double)f, d10 + this.random.nextGaussian() * (double)f, d2 + this.random.nextGaussian() * (double)f, 0.0, 0.0, 0.0);
        }
        if (this.getInvulnerableTicks() > 0) {
            float f3 = 3.3f * this.getScale();
            for (int i1 = 0; i1 < 3; ++i1) {
                this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.7f, (float)0.7f, (float)0.9f), this.getX() + this.random.nextGaussian(), this.getY() + (double)(this.random.nextFloat() * f3), this.getZ() + this.random.nextGaussian(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void customServerAiStep(ServerLevel p_376675_) {
        if (this.getInvulnerableTicks() > 0) {
            int j = this.getInvulnerableTicks() - 1;
            this.bossEvent.setProgress(1.0f - (float)j / 220.0f);
            if (j <= 0) {
                p_376675_.explode((Entity)((Object)this), this.getX(), this.getEyeY(), this.getZ(), 7.0f, false, Level.ExplosionInteraction.MOB);
                if (!this.isSilent()) {
                    p_376675_.globalLevelEvent(1023, this.blockPosition(), 0);
                }
            }
            this.setInvulnerableTicks(j);
            if (this.tickCount % 10 == 0) {
                this.heal(10.0f);
            }
        } else {
            super.customServerAiStep(p_376675_);
            for (int i = 1; i < 3; ++i) {
                int k;
                if (this.tickCount < this.nextHeadUpdate[i - 1]) continue;
                this.nextHeadUpdate[i - 1] = this.tickCount + 10 + this.random.nextInt(10);
                if (p_376675_.getDifficulty() == Difficulty.NORMAL || p_376675_.getDifficulty() == Difficulty.HARD) {
                    int n = i - 1;
                    int n2 = this.idleHeadUpdates[n];
                    this.idleHeadUpdates[n] = n2 + 1;
                    if (n2 > 15) {
                        float f = 10.0f;
                        float f1 = 5.0f;
                        double d0 = Mth.nextDouble((RandomSource)this.random, (double)(this.getX() - 10.0), (double)(this.getX() + 10.0));
                        double d1 = Mth.nextDouble((RandomSource)this.random, (double)(this.getY() - 5.0), (double)(this.getY() + 5.0));
                        double d2 = Mth.nextDouble((RandomSource)this.random, (double)(this.getZ() - 10.0), (double)(this.getZ() + 10.0));
                        this.performRangedAttack(i + 1, d0, d1, d2, true);
                        this.idleHeadUpdates[i - 1] = 0;
                    }
                }
                if ((k = this.getAlternativeTarget(i)) > 0) {
                    LivingEntity livingentity = (LivingEntity)p_376675_.getEntity(k);
                    if (livingentity != null && this.canAttack(livingentity) && !(this.distanceToSqr(livingentity) > 900.0) && this.hasLineOfSight(livingentity)) {
                        this.performRangedAttack(i + 1, livingentity);
                        this.nextHeadUpdate[i - 1] = this.tickCount + 40 + this.random.nextInt(20);
                        this.idleHeadUpdates[i - 1] = 0;
                        continue;
                    }
                    this.setAlternativeTarget(i, 0);
                    continue;
                }
                List list = p_376675_.getNearbyEntities(LivingEntity.class, TARGETING_CONDITIONS, (LivingEntity)((Object)this), this.getBoundingBox().inflate(20.0, 8.0, 20.0));
                if (list.isEmpty()) continue;
                LivingEntity livingentity1 = (LivingEntity)list.get(this.random.nextInt(list.size()));
                this.setAlternativeTarget(i, livingentity1.getId());
            }
            if (this.getTarget() != null) {
                this.setAlternativeTarget(0, this.getTarget().getId());
            } else {
                this.setAlternativeTarget(0, 0);
            }
            if (this.destroyBlocksTick > 0) {
                --this.destroyBlocksTick;
                if (this.destroyBlocksTick == 0 && EventHooks.canEntityGrief((ServerLevel)p_376675_, (Entity)((Object)this))) {
                    boolean flag = false;
                    int l = Mth.floor((float)(this.getBbWidth() / 2.0f + 1.0f));
                    int i1 = Mth.floor((float)this.getBbHeight());
                    for (BlockPos blockpos : BlockPos.betweenClosed((int)(this.getBlockX() - l), (int)this.getBlockY(), (int)(this.getBlockZ() - l), (int)(this.getBlockX() + l), (int)(this.getBlockY() + i1), (int)(this.getBlockZ() + l))) {
                        BlockState blockstate = p_376675_.getBlockState(blockpos);
                        if (!blockstate.canEntityDestroy((BlockGetter)((Object)this.level()), blockpos, (Entity)((Object)this)) || !EventHooks.onEntityDestroyBlock((LivingEntity)((Object)this), (BlockPos)blockpos, (BlockState)blockstate)) continue;
                        flag = p_376675_.destroyBlock(blockpos, true, (Entity)((Object)this)) || flag;
                    }
                    if (flag) {
                        p_376675_.levelEvent(null, 1022, this.blockPosition(), 0);
                    }
                }
            }
            if (this.tickCount % 20 == 0) {
                this.heal(1.0f);
            }
            this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
        }
    }

    @Deprecated
    public static boolean canDestroy(BlockState p_31492_) {
        return !p_31492_.isAir() && !p_31492_.is(BlockTags.WITHER_IMMUNE);
    }

    public void makeInvulnerable() {
        this.setInvulnerableTicks(220);
        this.bossEvent.setProgress(0.0f);
        this.setHealth(this.getMaxHealth() / 3.0f);
    }

    public void makeStuckInBlock(BlockState p_31471_, Vec3 p_31472_) {
    }

    public void startSeenByPlayer(ServerPlayer p_31483_) {
        super.startSeenByPlayer(p_31483_);
        this.bossEvent.addPlayer(p_31483_);
    }

    public void stopSeenByPlayer(ServerPlayer p_31488_) {
        super.stopSeenByPlayer(p_31488_);
        this.bossEvent.removePlayer(p_31488_);
    }

    private double getHeadX(int p_31515_) {
        if (p_31515_ <= 0) {
            return this.getX();
        }
        float f = (this.yBodyRot + (float)(180 * (p_31515_ - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.cos((float)f);
        return this.getX() + (double)f1 * 1.3 * (double)this.getScale();
    }

    private double getHeadY(int p_31517_) {
        float f = p_31517_ <= 0 ? 3.0f : 2.2f;
        return this.getY() + (double)(f * this.getScale());
    }

    private double getHeadZ(int p_31519_) {
        if (p_31519_ <= 0) {
            return this.getZ();
        }
        float f = (this.yBodyRot + (float)(180 * (p_31519_ - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.sin((float)f);
        return this.getZ() + (double)f1 * 1.3 * (double)this.getScale();
    }

    private float rotlerp(float p_31443_, float p_31444_, float p_31445_) {
        float f = Mth.wrapDegrees((float)(p_31444_ - p_31443_));
        if (f > p_31445_) {
            f = p_31445_;
        }
        if (f < -p_31445_) {
            f = -p_31445_;
        }
        return p_31443_ + f;
    }

    private void performRangedAttack(int p_31458_, LivingEntity p_31459_) {
        this.performRangedAttack(p_31458_, p_31459_.getX(), p_31459_.getY() + (double)p_31459_.getEyeHeight() * 0.5, p_31459_.getZ(), p_31458_ == 0 && this.random.nextFloat() < 0.001f);
    }

    private void performRangedAttack(int p_31449_, double p_31450_, double p_31451_, double p_31452_, boolean p_31453_) {
        if (!this.isSilent()) {
            this.level().levelEvent(null, 1024, this.blockPosition(), 0);
        }
        double d0 = this.getHeadX(p_31449_);
        double d1 = this.getHeadY(p_31449_);
        double d2 = this.getHeadZ(p_31449_);
        double d3 = p_31450_ - d0;
        double d4 = p_31451_ - d1;
        double d5 = p_31452_ - d2;
        Vec3 vec3 = new Vec3(d3, d4, d5);
        WitherSkull witherskull = new WitherSkull(this.level(), (LivingEntity)((Object)this), vec3.normalize());
        witherskull.setOwner((Entity)((Object)this));
        if (p_31453_) {
            witherskull.setDangerous(true);
        }
        witherskull.setPos(d0, d1, d2);
        this.level().addFreshEntity(witherskull);
    }

    public void performRangedAttack(LivingEntity p_31468_, float p_31469_) {
        this.performRangedAttack(0, p_31468_);
    }

    public boolean hurtServer(ServerLevel p_376615_, DamageSource p_376766_, float p_376552_) {
        Entity entity;
        if (this.isInvulnerableTo(p_376615_, p_376766_)) {
            return false;
        }
        if (p_376766_.is((TagKey<DamageType>)DamageTypeTags.WITHER_IMMUNE_TO) || p_376766_.getEntity() instanceof WitherBoss) {
            return false;
        }
        if (this.getInvulnerableTicks() > 0 && !p_376766_.is((TagKey<DamageType>)DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        if (this.isPowered() && ((entity = p_376766_.getDirectEntity()) instanceof AbstractArrow || entity instanceof WindCharge)) {
            return false;
        }
        Entity entity1 = p_376766_.getEntity();
        if (entity1 != null && entity1.getType().is(EntityTypeTags.WITHER_FRIENDS)) {
            return false;
        }
        if (this.destroyBlocksTick <= 0) {
            this.destroyBlocksTick = 20;
        }
        for (int i = 0; i < this.idleHeadUpdates.length; ++i) {
            this.idleHeadUpdates[i] = this.idleHeadUpdates[i] + 3;
        }
        return super.hurtServer(p_376615_, p_376766_, p_376552_);
    }

    protected void dropCustomDeathLoot(ServerLevel p_348644_, DamageSource p_31464_, boolean p_31466_) {
        super.dropCustomDeathLoot(p_348644_, p_31464_, p_31466_);
        ItemEntity itementity = this.spawnAtLocation(p_348644_, Items.NETHER_STAR);
        if (itementity != null) {
            itementity.setExtendedLifetime();
        }
    }

    public void checkDespawn() {
        if (EventHooks.checkMobDespawn((Mob)((Object)this))) {
            return;
        }
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard();
        } else {
            this.noActionTime = 0;
        }
    }

    public boolean addEffect(MobEffectInstance p_182397_, @Nullable Entity p_182398_) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 300.0).add(Attributes.MOVEMENT_SPEED, 0.6f).add(Attributes.FLYING_SPEED, 0.6f).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.ARMOR, 4.0);
    }

    public float[] getHeadYRots() {
        return this.yRotHeads;
    }

    public float[] getHeadXRots() {
        return this.xRotHeads;
    }

    public int getInvulnerableTicks() {
        return this.entityData.get(DATA_ID_INV);
    }

    public void setInvulnerableTicks(int p_31511_) {
        this.entityData.set(DATA_ID_INV, p_31511_);
    }

    public int getAlternativeTarget(int p_31513_) {
        return this.entityData.get(DATA_TARGETS.get(p_31513_));
    }

    public void setAlternativeTarget(int p_31455_, int p_31456_) {
        this.entityData.set(DATA_TARGETS.get(p_31455_), p_31456_);
    }

    public boolean isPowered() {
        return this.getHealth() <= this.getMaxHealth() / 2.0f;
    }

    protected boolean canRide(Entity p_31508_) {
        return false;
    }

    public boolean canUsePortal(boolean p_352936_) {
        return false;
    }

    public boolean canBeAffected(MobEffectInstance p_31495_) {
        return p_31495_.is(MobEffects.WITHER) ? false : super.canBeAffected(p_31495_);
    }

    class WitherDoNothingGoal
    extends Goal {
        public WitherDoNothingGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return WitherBoss.this.getInvulnerableTicks() > 0;
        }
    }
}

