/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;

public class GrindstoneMenu
extends AbstractContainerMenu {
    public static final int MAX_NAME_LENGTH = 35;
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private final Container resultSlots = new ResultContainer();
    final Container repairSlots = new SimpleContainer(2){

        public void setChanged() {
            super.setChanged();
            GrindstoneMenu.this.slotsChanged((Container)this);
        }
    };
    private final ContainerLevelAccess access;
    private int xp = -1;

    public GrindstoneMenu(int p_39563_, Inventory p_39564_) {
        this(p_39563_, p_39564_, ContainerLevelAccess.NULL);
    }

    public GrindstoneMenu(int p_39566_, Inventory p_39567_, final ContainerLevelAccess p_39568_) {
        super(MenuType.GRINDSTONE, p_39566_);
        this.access = p_39568_;
        this.addSlot(new Slot(this, this.repairSlots, 0, 49, 19){

            @Override
            public boolean mayPlace(ItemStack p_39607_) {
                return p_39607_.isDamageableItem() || EnchantmentHelper.hasAnyEnchantments(p_39607_) || p_39607_.canGrindstoneRepair();
            }
        });
        this.addSlot(new Slot(this, this.repairSlots, 1, 49, 40){

            @Override
            public boolean mayPlace(ItemStack p_39616_) {
                return p_39616_.isDamageableItem() || EnchantmentHelper.hasAnyEnchantments(p_39616_) || p_39616_.canGrindstoneRepair();
            }
        });
        this.addSlot(new Slot(this.resultSlots, 2, 129, 34){

            @Override
            public boolean mayPlace(ItemStack p_39630_) {
                return false;
            }

            @Override
            public void onTake(Player p_150574_, ItemStack p_150575_) {
                if (CommonHooks.onGrindstoneTake((Container)GrindstoneMenu.this.repairSlots, (ContainerLevelAccess)p_39568_, this::getExperienceAmount)) {
                    return;
                }
                p_39568_.execute((p_39634_, p_39635_) -> {
                    if (p_39634_ instanceof ServerLevel) {
                        ExperienceOrb.award((ServerLevel)p_39634_, Vec3.atCenterOf((Vec3i)p_39635_), this.getExperienceAmount((Level)p_39634_));
                    }
                    p_39634_.levelEvent(1042, p_39635_, 0);
                });
                GrindstoneMenu.this.repairSlots.setItem(0, ItemStack.EMPTY);
                GrindstoneMenu.this.repairSlots.setItem(1, ItemStack.EMPTY);
            }

            private int getExperienceAmount(Level p_39632_) {
                if (GrindstoneMenu.this.xp > -1) {
                    return GrindstoneMenu.this.xp;
                }
                int i = 0;
                i += this.getExperienceFromItem(GrindstoneMenu.this.repairSlots.getItem(0));
                if ((i += this.getExperienceFromItem(GrindstoneMenu.this.repairSlots.getItem(1))) > 0) {
                    int j = (int)Math.ceil((double)i / 2.0);
                    return j + p_39632_.random.nextInt(j);
                }
                return 0;
            }

            private int getExperienceFromItem(ItemStack p_39637_) {
                int i = 0;
                ItemEnchantments itemenchantments = EnchantmentHelper.getEnchantmentsForCrafting(p_39637_);
                for (Object2IntMap.Entry entry : itemenchantments.entrySet()) {
                    Holder holder = (Holder)entry.getKey();
                    int j = entry.getIntValue();
                    if (holder.is(EnchantmentTags.CURSE)) continue;
                    i += ((Enchantment)holder.value()).getMinCost(j);
                }
                return i;
            }
        });
        this.addStandardInventorySlots(p_39567_, 8, 84);
    }

    @Override
    public void slotsChanged(Container p_39570_) {
        super.slotsChanged(p_39570_);
        if (p_39570_ == this.repairSlots) {
            this.createResult();
        }
    }

    private void createResult() {
        this.xp = CommonHooks.onGrindstoneChange((ItemStack)this.repairSlots.getItem(0), (ItemStack)this.repairSlots.getItem(1), (Container)this.resultSlots, (int)-1);
        if (this.xp == Integer.MIN_VALUE) {
            this.resultSlots.setItem(0, this.computeResult(this.repairSlots.getItem(0), this.repairSlots.getItem(1)));
        }
        this.broadcastChanges();
    }

    private ItemStack computeResult(ItemStack p_332654_, ItemStack p_332736_) {
        boolean flag;
        boolean bl = flag = !p_332654_.isEmpty() || !p_332736_.isEmpty();
        if (!flag) {
            return ItemStack.EMPTY;
        }
        if (p_332654_.getCount() <= 1 && p_332736_.getCount() <= 1) {
            boolean flag1;
            boolean bl2 = flag1 = !p_332654_.isEmpty() && !p_332736_.isEmpty();
            if (!flag1) {
                ItemStack itemstack = !p_332654_.isEmpty() ? p_332654_ : p_332736_;
                return !EnchantmentHelper.hasAnyEnchantments(itemstack) ? ItemStack.EMPTY : this.removeNonCursesFrom(itemstack.copy());
            }
            return this.mergeItems(p_332654_, p_332736_);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack mergeItems(ItemStack p_332723_, ItemStack p_332686_) {
        ItemStack itemstack;
        if (!p_332723_.is(p_332686_.getItem())) {
            return ItemStack.EMPTY;
        }
        int i = Math.max(p_332723_.getMaxDamage(), p_332686_.getMaxDamage());
        int j = p_332723_.getMaxDamage() - p_332723_.getDamageValue();
        int k = p_332686_.getMaxDamage() - p_332686_.getDamageValue();
        int l = j + k + i * 5 / 100;
        int i1 = 1;
        if (!p_332723_.isDamageableItem() || !p_332723_.isCombineRepairable()) {
            if (p_332723_.getMaxStackSize() < 2 || !ItemStack.matches(p_332723_, p_332686_)) {
                return ItemStack.EMPTY;
            }
            i1 = 2;
        }
        if ((itemstack = p_332723_.copyWithCount(i1)).isDamageableItem()) {
            itemstack.set(DataComponents.MAX_DAMAGE, i);
            itemstack.setDamageValue(Math.max(i - l, 0));
            if (!p_332686_.isCombineRepairable()) {
                itemstack.setDamageValue(p_332723_.getDamageValue());
            }
        }
        this.mergeEnchantsFrom(itemstack, p_332686_);
        return this.removeNonCursesFrom(itemstack);
    }

    private void mergeEnchantsFrom(ItemStack p_332680_, ItemStack p_332800_) {
        EnchantmentHelper.updateEnchantments(p_332680_, p_344370_ -> {
            ItemEnchantments itemenchantments = EnchantmentHelper.getEnchantmentsForCrafting(p_332800_);
            for (Object2IntMap.Entry entry : itemenchantments.entrySet()) {
                Holder holder = (Holder)entry.getKey();
                if (holder.is(EnchantmentTags.CURSE) && p_344370_.getLevel(holder) != 0) continue;
                p_344370_.upgrade(holder, entry.getIntValue());
            }
        });
    }

    private ItemStack removeNonCursesFrom(ItemStack p_332709_) {
        ItemEnchantments itemenchantments = EnchantmentHelper.updateEnchantments(p_332709_, p_330066_ -> p_330066_.removeIf(p_344368_ -> !p_344368_.is(EnchantmentTags.CURSE)));
        if (p_332709_.is(Items.ENCHANTED_BOOK) && itemenchantments.isEmpty()) {
            p_332709_ = p_332709_.transmuteCopy(Items.BOOK);
        }
        int i = 0;
        for (int j = 0; j < itemenchantments.size(); ++j) {
            i = AnvilMenu.calculateIncreasedRepairCost(i);
        }
        p_332709_.set(DataComponents.REPAIR_COST, i);
        return p_332709_;
    }

    @Override
    public void removed(Player p_39586_) {
        super.removed(p_39586_);
        this.access.execute((p_39575_, p_39576_) -> this.clearContainer(p_39586_, this.repairSlots));
    }

    @Override
    public boolean stillValid(Player p_39572_) {
        return GrindstoneMenu.stillValid(this.access, p_39572_, Blocks.GRINDSTONE);
    }

    @Override
    public ItemStack quickMoveStack(Player p_39588_, int p_39589_) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(p_39589_);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            ItemStack itemstack2 = this.repairSlots.getItem(0);
            ItemStack itemstack3 = this.repairSlots.getItem(1);
            if (p_39589_ == 2) {
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (p_39589_ != 0 && p_39589_ != 1 ? (!itemstack2.isEmpty() && !itemstack3.isEmpty() ? (p_39589_ >= 3 && p_39589_ < 30 ? !this.moveItemStackTo(itemstack1, 30, 39, false) : p_39589_ >= 30 && p_39589_ < 39 && !this.moveItemStackTo(itemstack1, 3, 30, false)) : !this.moveItemStackTo(itemstack1, 0, 2, false)) : !this.moveItemStackTo(itemstack1, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(p_39588_, itemstack1);
        }
        return itemstack;
    }
}

