/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public class BowItem
extends ProjectileWeaponItem {
    public static final int MAX_DRAW_DURATION = 20;
    public static final int DEFAULT_RANGE = 15;

    public BowItem(Item.Properties p_40660_) {
        super(p_40660_);
    }

    @Override
    public boolean releaseUsing(ItemStack p_40667_, Level p_40668_, LivingEntity p_40669_, int p_40670_) {
        if (!(p_40669_ instanceof Player)) {
            return false;
        }
        Player player = (Player)p_40669_;
        ItemStack itemstack = player.getProjectile(p_40667_);
        if (itemstack.isEmpty()) {
            return false;
        }
        int i = this.getUseDuration(p_40667_, p_40669_) - p_40670_;
        if ((i = EventHooks.onArrowLoose((ItemStack)p_40667_, (Level)p_40668_, (Player)player, (int)i, (!itemstack.isEmpty() ? 1 : 0) != 0)) < 0) {
            return false;
        }
        float f = BowItem.getPowerForTime(i);
        if ((double)f < 0.1) {
            return false;
        }
        List<ItemStack> list = BowItem.draw(p_40667_, itemstack, player);
        if (p_40668_ instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)p_40668_;
            if (!list.isEmpty()) {
                this.shoot(serverlevel, player, player.getUsedItemHand(), p_40667_, list, f * 3.0f, 1.0f, f == 1.0f, null);
            }
        }
        p_40668_.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (p_40668_.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return true;
    }

    @Override
    protected void shootProjectile(LivingEntity p_331372_, Projectile p_332000_, int p_330631_, float p_331251_, float p_331199_, float p_330857_, @Nullable LivingEntity p_331572_) {
        p_332000_.shootFromRotation(p_331372_, p_331372_.getXRot(), p_331372_.getYRot() + p_330857_, 0.0f, p_331251_, p_331199_);
    }

    public static float getPowerForTime(int p_40662_) {
        float f = (float)p_40662_ / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Override
    public int getUseDuration(ItemStack p_40680_, LivingEntity p_345962_) {
        return 72000;
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack p_40678_) {
        return ItemUseAnimation.BOW;
    }

    @Override
    public InteractionResult use(Level p_40672_, Player p_40673_, InteractionHand p_40674_) {
        ItemStack itemstack;
        boolean flag = !p_40673_.getProjectile(itemstack = p_40673_.getItemInHand(p_40674_)).isEmpty();
        InteractionResult ret = EventHooks.onArrowNock((ItemStack)itemstack, (Level)p_40672_, (Player)p_40673_, (InteractionHand)p_40674_, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (!p_40673_.hasInfiniteMaterials() && !flag) {
            return InteractionResult.FAIL;
        }
        p_40673_.startUsingItem(p_40674_);
        return InteractionResult.CONSUME;
    }

    @Override
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    @Override
    public int getDefaultProjectileRange() {
        return 15;
    }
}

