/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class MapItem
extends Item {
    public static final int IMAGE_WIDTH = 128;
    public static final int IMAGE_HEIGHT = 128;

    public MapItem(Item.Properties p_42847_) {
        super(p_42847_);
    }

    public static ItemStack create(ServerLevel p_412948_, int p_42888_, int p_42889_, byte p_42890_, boolean p_42891_, boolean p_42892_) {
        ItemStack itemstack = new ItemStack(Items.FILLED_MAP);
        MapId mapid = MapItem.createNewSavedData(p_412948_, p_42888_, p_42889_, p_42890_, p_42891_, p_42892_, p_412948_.dimension());
        itemstack.set(DataComponents.MAP_ID, mapid);
        return itemstack;
    }

    @Nullable
    public static MapItemSavedData getSavedData(@Nullable MapId p_324036_, Level p_151130_) {
        return p_324036_ == null ? null : p_151130_.getMapData(p_324036_);
    }

    @Nullable
    public static MapItemSavedData getSavedData(ItemStack p_42854_, Level p_42855_) {
        Item map = p_42854_.getItem();
        if (map instanceof MapItem) {
            return ((MapItem)map).getCustomMapData(p_42854_, p_42855_);
        }
        return null;
    }

    @Nullable
    protected MapItemSavedData getCustomMapData(ItemStack p_42854_, Level p_42855_) {
        MapId mapid = (MapId)p_42854_.get(DataComponents.MAP_ID);
        return MapItem.getSavedData(mapid, p_42855_);
    }

    private static MapId createNewSavedData(ServerLevel p_412947_, int p_151122_, int p_151123_, int p_151124_, boolean p_151125_, boolean p_151126_, ResourceKey<Level> p_151127_) {
        MapItemSavedData mapitemsaveddata = MapItemSavedData.createFresh((double)p_151122_, (double)p_151123_, (byte)((byte)p_151124_), (boolean)p_151125_, (boolean)p_151126_, p_151127_);
        MapId mapid = p_412947_.getFreeMapId();
        p_412947_.setMapData(mapid, mapitemsaveddata);
        return mapid;
    }

    public void update(Level p_42894_, Entity p_42895_, MapItemSavedData p_42896_) {
        if (p_42894_.dimension() == p_42896_.dimension && p_42895_ instanceof Player) {
            int i = 1 << p_42896_.scale;
            int j = p_42896_.centerX;
            int k = p_42896_.centerZ;
            int l = Mth.floor((double)(p_42895_.getX() - (double)j)) / i + 64;
            int i1 = Mth.floor((double)(p_42895_.getZ() - (double)k)) / i + 64;
            int j1 = 128 / i;
            if (p_42894_.dimensionType().hasCeiling()) {
                j1 /= 2;
            }
            MapItemSavedData.HoldingPlayer mapitemsaveddata$holdingplayer = p_42896_.getHoldingPlayer((Player)p_42895_);
            ++mapitemsaveddata$holdingplayer.step;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
            boolean flag = false;
            for (int k1 = l - j1 + 1; k1 < l + j1; ++k1) {
                if ((k1 & 0xF) != (mapitemsaveddata$holdingplayer.step & 0xF) && !flag) continue;
                flag = false;
                double d0 = 0.0;
                for (int l1 = i1 - j1 - 1; l1 < i1 + j1; ++l1) {
                    double d3;
                    double d2;
                    if (k1 < 0 || l1 < -1 || k1 >= 128 || l1 >= 128) continue;
                    int i2 = Mth.square((int)(k1 - l)) + Mth.square((int)(l1 - i1));
                    boolean flag1 = i2 > (j1 - 2) * (j1 - 2);
                    int j2 = (j / i + k1 - 64) * i;
                    int k2 = (k / i + l1 - 64) * i;
                    LinkedHashMultiset multiset = LinkedHashMultiset.create();
                    LevelChunk levelchunk = p_42894_.getChunk(SectionPos.blockToSectionCoord((int)j2), SectionPos.blockToSectionCoord((int)k2));
                    if (levelchunk.isEmpty()) continue;
                    int l2 = 0;
                    double d1 = 0.0;
                    if (p_42894_.dimensionType().hasCeiling()) {
                        int i3 = j2 + k2 * 231871;
                        if (((i3 = i3 * i3 * 31287121 + i3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)Blocks.DIRT.defaultBlockState().getMapColor((BlockGetter)((Object)p_42894_), BlockPos.ZERO), 10);
                        } else {
                            multiset.add((Object)Blocks.STONE.defaultBlockState().getMapColor((BlockGetter)((Object)p_42894_), BlockPos.ZERO), 100);
                        }
                        d1 = 100.0;
                    } else {
                        for (int i4 = 0; i4 < i; ++i4) {
                            for (int j3 = 0; j3 < i; ++j3) {
                                BlockState blockstate;
                                blockpos$mutableblockpos.set(j2 + i4, 0, k2 + j3);
                                int k3 = levelchunk.getHeight(Heightmap.Types.WORLD_SURFACE, blockpos$mutableblockpos.getX(), blockpos$mutableblockpos.getZ()) + 1;
                                if (k3 <= p_42894_.getMinY()) {
                                    blockstate = Blocks.BEDROCK.defaultBlockState();
                                } else {
                                    do {
                                        blockpos$mutableblockpos.setY(--k3);
                                    } while ((blockstate = levelchunk.getBlockState((BlockPos)blockpos$mutableblockpos)).getMapColor((BlockGetter)((Object)p_42894_), (BlockPos)blockpos$mutableblockpos) == MapColor.NONE && k3 > p_42894_.getMinY());
                                    if (k3 > p_42894_.getMinY() && !blockstate.getFluidState().isEmpty()) {
                                        BlockState blockstate1;
                                        int l3 = k3 - 1;
                                        blockpos$mutableblockpos1.set((Vec3i)blockpos$mutableblockpos);
                                        do {
                                            blockpos$mutableblockpos1.setY(l3--);
                                            blockstate1 = levelchunk.getBlockState((BlockPos)blockpos$mutableblockpos1);
                                            ++l2;
                                        } while (l3 > p_42894_.getMinY() && !blockstate1.getFluidState().isEmpty());
                                        blockstate = this.getCorrectStateForFluidBlock(p_42894_, blockstate, (BlockPos)blockpos$mutableblockpos);
                                    }
                                }
                                p_42896_.checkBanners((BlockGetter)((Object)p_42894_), blockpos$mutableblockpos.getX(), blockpos$mutableblockpos.getZ());
                                d1 += (double)k3 / (double)(i * i);
                                multiset.add((Object)blockstate.getMapColor((BlockGetter)((Object)p_42894_), (BlockPos)blockpos$mutableblockpos));
                            }
                        }
                    }
                    MapColor mapcolor = (MapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MapColor.NONE);
                    MapColor.Brightness mapcolor$brightness = mapcolor == MapColor.WATER ? ((d2 = (double)(l2 /= i * i) * 0.1 + (double)(k1 + l1 & 1) * 0.2) < 0.5 ? MapColor.Brightness.HIGH : (d2 > 0.9 ? MapColor.Brightness.LOW : MapColor.Brightness.NORMAL)) : ((d3 = (d1 - d0) * 4.0 / (double)(i + 4) + ((double)(k1 + l1 & 1) - 0.5) * 0.4) > 0.6 ? MapColor.Brightness.HIGH : (d3 < -0.6 ? MapColor.Brightness.LOW : MapColor.Brightness.NORMAL));
                    d0 = d1;
                    if (l1 < 0 || i2 >= j1 * j1 || flag1 && (k1 + l1 & 1) == 0) continue;
                    flag |= p_42896_.updateColor(k1, l1, mapcolor.getPackedId(mapcolor$brightness));
                }
            }
        }
    }

    private BlockState getCorrectStateForFluidBlock(Level p_42901_, BlockState p_42902_, BlockPos p_42903_) {
        FluidState fluidstate = p_42902_.getFluidState();
        return !fluidstate.isEmpty() && !p_42902_.isFaceSturdy((BlockGetter)((Object)p_42901_), p_42903_, Direction.UP) ? fluidstate.createLegacyBlock() : p_42902_;
    }

    private static boolean isBiomeWatery(boolean[] p_212252_, int p_212253_, int p_212254_) {
        return p_212252_[p_212254_ * 128 + p_212253_];
    }

    public static void renderBiomePreviewMap(ServerLevel p_42851_, ItemStack p_42852_) {
        MapItemSavedData mapitemsaveddata = MapItem.getSavedData(p_42852_, (Level)p_42851_);
        if (mapitemsaveddata != null && p_42851_.dimension() == mapitemsaveddata.dimension) {
            int i = 1 << mapitemsaveddata.scale;
            int j = mapitemsaveddata.centerX;
            int k = mapitemsaveddata.centerZ;
            boolean[] aboolean = new boolean[16384];
            int l = j / i - 64;
            int i1 = k / i - 64;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int j1 = 0; j1 < 128; ++j1) {
                for (int k1 = 0; k1 < 128; ++k1) {
                    Holder holder = p_42851_.getBiome((BlockPos)blockpos$mutableblockpos.set((l + k1) * i, 0, (i1 + j1) * i));
                    aboolean[j1 * 128 + k1] = holder.is(BiomeTags.WATER_ON_MAP_OUTLINES);
                }
            }
            for (int j2 = 1; j2 < 127; ++j2) {
                for (int k2 = 1; k2 < 127; ++k2) {
                    int l2 = 0;
                    for (int l1 = -1; l1 < 2; ++l1) {
                        for (int i2 = -1; i2 < 2; ++i2) {
                            if (l1 == 0 && i2 == 0 || !MapItem.isBiomeWatery(aboolean, j2 + l1, k2 + i2)) continue;
                            ++l2;
                        }
                    }
                    MapColor.Brightness mapcolor$brightness = MapColor.Brightness.LOWEST;
                    MapColor mapcolor = MapColor.NONE;
                    if (MapItem.isBiomeWatery(aboolean, j2, k2)) {
                        mapcolor = MapColor.COLOR_ORANGE;
                        if (l2 > 7 && k2 % 2 == 0) {
                            switch ((j2 + (int)(Mth.sin((float)((float)k2 + 0.0f)) * 7.0f)) / 8 % 5) {
                                case 0: 
                                case 4: {
                                    mapcolor$brightness = MapColor.Brightness.LOW;
                                    break;
                                }
                                case 1: 
                                case 3: {
                                    mapcolor$brightness = MapColor.Brightness.NORMAL;
                                    break;
                                }
                                case 2: {
                                    mapcolor$brightness = MapColor.Brightness.HIGH;
                                }
                            }
                        } else if (l2 > 7) {
                            mapcolor = MapColor.NONE;
                        } else if (l2 > 5) {
                            mapcolor$brightness = MapColor.Brightness.NORMAL;
                        } else if (l2 > 3) {
                            mapcolor$brightness = MapColor.Brightness.LOW;
                        } else if (l2 > 1) {
                            mapcolor$brightness = MapColor.Brightness.LOW;
                        }
                    } else if (l2 > 0) {
                        mapcolor = MapColor.COLOR_BROWN;
                        mapcolor$brightness = l2 > 3 ? MapColor.Brightness.NORMAL : MapColor.Brightness.LOWEST;
                    }
                    if (mapcolor == MapColor.NONE) continue;
                    mapitemsaveddata.setColor(j2, k2, mapcolor.getPackedId(mapcolor$brightness));
                }
            }
        }
    }

    @Override
    public void inventoryTick(ItemStack p_42870_, ServerLevel p_401792_, Entity p_42872_, @Nullable EquipmentSlot p_401885_) {
        MapItemSavedData mapitemsaveddata = MapItem.getSavedData(p_42870_, (Level)p_401792_);
        if (mapitemsaveddata != null) {
            if (p_42872_ instanceof Player) {
                Player player = (Player)p_42872_;
                mapitemsaveddata.tickCarriedBy(player, p_42870_);
            }
            if (!mapitemsaveddata.locked && p_401885_ != null && p_401885_.getType() == EquipmentSlot.Type.HAND) {
                this.update(p_401792_, p_42872_, mapitemsaveddata);
            }
        }
    }

    @Override
    public void onCraftedPostProcess(ItemStack p_42913_, Level p_42914_) {
        MapPostProcessing mappostprocessing = (MapPostProcessing)p_42913_.remove(DataComponents.MAP_POST_PROCESSING);
        if (mappostprocessing != null && p_42914_ instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)p_42914_;
            switch (mappostprocessing) {
                case LOCK: {
                    MapItem.lockMap(p_42913_, serverlevel);
                    break;
                }
                case SCALE: {
                    MapItem.scaleMap(p_42913_, serverlevel);
                }
            }
        }
    }

    private static void scaleMap(ItemStack p_42857_, ServerLevel p_412941_) {
        MapItemSavedData mapitemsaveddata = MapItem.getSavedData(p_42857_, (Level)p_412941_);
        if (mapitemsaveddata != null) {
            MapId mapid = p_412941_.getFreeMapId();
            p_412941_.setMapData(mapid, mapitemsaveddata.scaled());
            p_42857_.set(DataComponents.MAP_ID, mapid);
        }
    }

    private static void lockMap(ItemStack p_42899_, ServerLevel p_412943_) {
        MapItemSavedData mapitemsaveddata = MapItem.getSavedData(p_42899_, (Level)p_412943_);
        if (mapitemsaveddata != null) {
            MapId mapid = p_412943_.getFreeMapId();
            MapItemSavedData mapitemsaveddata1 = mapitemsaveddata.locked();
            p_412943_.setMapData(mapid, mapitemsaveddata1);
            p_42899_.set(DataComponents.MAP_ID, mapid);
        }
    }

    @Override
    public InteractionResult useOn(UseOnContext p_42885_) {
        BlockState blockstate = p_42885_.getLevel().getBlockState(p_42885_.getClickedPos());
        if (blockstate.is(BlockTags.BANNERS)) {
            MapItemSavedData mapitemsaveddata;
            if (!p_42885_.getLevel().isClientSide && (mapitemsaveddata = MapItem.getSavedData(p_42885_.getItemInHand(), p_42885_.getLevel())) != null && !mapitemsaveddata.toggleBanner((LevelAccessor)p_42885_.getLevel(), p_42885_.getClickedPos())) {
                return InteractionResult.FAIL;
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(p_42885_);
    }
}

