/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ARGB;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.AttributeUtil;

public record PotionContents(Optional<Holder<Potion>> potion, Optional<Integer> customColor, List<MobEffectInstance> customEffects, Optional<String> customName) implements ConsumableListener,
TooltipProvider
{
    private final List<MobEffectInstance> customEffects;
    public static final PotionContents EMPTY = new PotionContents(Optional.empty(), Optional.empty(), List.of(), Optional.empty());
    private static final Component NO_EFFECT = Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY);
    public static final int BASE_POTION_COLOR = -13083194;
    private static final Codec<PotionContents> FULL_CODEC = RecordCodecBuilder.create(p_372777_ -> p_372777_.group((App)Potion.CODEC.optionalFieldOf("potion").forGetter(PotionContents::potion), (App)Codec.INT.optionalFieldOf("custom_color").forGetter(PotionContents::customColor), (App)MobEffectInstance.CODEC.listOf().optionalFieldOf("custom_effects", List.of()).forGetter(PotionContents::customEffects), (App)Codec.STRING.optionalFieldOf("custom_name").forGetter(PotionContents::customName)).apply((Applicative)p_372777_, PotionContents::new));
    public static final Codec<PotionContents> CODEC = Codec.withAlternative(FULL_CODEC, (Codec)Potion.CODEC, PotionContents::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, PotionContents> STREAM_CODEC = StreamCodec.composite((StreamCodec)Potion.STREAM_CODEC.apply(ByteBufCodecs::optional), PotionContents::potion, (StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs::optional), PotionContents::customColor, (StreamCodec)MobEffectInstance.STREAM_CODEC.apply(ByteBufCodecs.list()), PotionContents::customEffects, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs::optional), PotionContents::customName, PotionContents::new);

    public PotionContents(Holder<Potion> p_331208_) {
        this(Optional.of(p_331208_), Optional.empty(), List.of(), Optional.empty());
    }

    public static ItemStack createItemStack(Item p_330388_, Holder<Potion> p_331030_) {
        ItemStack itemstack = new ItemStack(p_330388_);
        itemstack.set(DataComponents.POTION_CONTENTS, new PotionContents(p_331030_));
        return itemstack;
    }

    public boolean is(Holder<Potion> p_331328_) {
        return this.potion.isPresent() && this.potion.get().is(p_331328_) && this.customEffects.isEmpty();
    }

    public Iterable<MobEffectInstance> getAllEffects() {
        if (this.potion.isEmpty()) {
            return this.customEffects;
        }
        return this.customEffects.isEmpty() ? this.potion.get().value().getEffects() : Iterables.concat((Iterable)this.potion.get().value().getEffects(), this.customEffects);
    }

    public void forEachEffect(Consumer<MobEffectInstance> p_331190_, float p_394070_) {
        if (this.potion.isPresent()) {
            for (MobEffectInstance mobeffectinstance : this.potion.get().value().getEffects()) {
                p_331190_.accept(mobeffectinstance.withScaledDuration(p_394070_));
            }
        }
        for (MobEffectInstance mobeffectinstance1 : this.customEffects) {
            p_331190_.accept(mobeffectinstance1.withScaledDuration(p_394070_));
        }
    }

    public PotionContents withPotion(Holder<Potion> p_330288_) {
        return new PotionContents(Optional.of(p_330288_), this.customColor, this.customEffects, this.customName);
    }

    public PotionContents withEffectAdded(MobEffectInstance p_332083_) {
        return new PotionContents(this.potion, this.customColor, Util.copyAndAdd(this.customEffects, p_332083_), this.customName);
    }

    public int getColor() {
        return this.getColorOr(-13083194);
    }

    public int getColorOr(int p_388208_) {
        return this.customColor.isPresent() ? this.customColor.get().intValue() : PotionContents.getColorOptional(this.getAllEffects()).orElse(p_388208_);
    }

    public Component getName(String p_372972_) {
        String s = this.customName.or(() -> this.potion.map(p_372776_ -> ((Potion)p_372776_.value()).name())).orElse("empty");
        return Component.translatable((String)(p_372972_ + s));
    }

    public static OptionalInt getColorOptional(Iterable<MobEffectInstance> p_332699_) {
        int i = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        for (MobEffectInstance mobeffectinstance : p_332699_) {
            if (!mobeffectinstance.isVisible()) continue;
            int i1 = mobeffectinstance.getEffect().value().getColor();
            int j1 = mobeffectinstance.getAmplifier() + 1;
            i += j1 * ARGB.red((int)i1);
            j += j1 * ARGB.green((int)i1);
            k += j1 * ARGB.blue((int)i1);
            l += j1;
        }
        return l == 0 ? OptionalInt.empty() : OptionalInt.of(ARGB.color((int)(i / l), (int)(j / l), (int)(k / l)));
    }

    public boolean hasEffects() {
        return !this.customEffects.isEmpty() ? true : this.potion.isPresent() && !this.potion.get().value().getEffects().isEmpty();
    }

    public List<MobEffectInstance> customEffects() {
        return Lists.transform(this.customEffects, MobEffectInstance::new);
    }

    public void applyToLivingEntity(LivingEntity p_366471_, float p_393741_) {
        Level level = p_366471_.level();
        if (level instanceof ServerLevel) {
            Player player;
            ServerLevel serverlevel = (ServerLevel)level;
            Player player1 = p_366471_ instanceof Player ? (player = (Player)p_366471_) : null;
            this.forEachEffect(p_376018_ -> {
                if (p_376018_.getEffect().value().isInstantenous()) {
                    p_376018_.getEffect().value().applyInstantenousEffect(serverlevel, player1, player1, p_366471_, p_376018_.getAmplifier(), 1.0);
                } else {
                    p_366471_.addEffect((MobEffectInstance)p_376018_);
                }
            }, p_393741_);
        }
    }

    public static void addPotionTooltip(Iterable<MobEffectInstance> p_331825_, Consumer<Component> p_331296_, float p_332038_, float p_332014_) {
        ArrayList list = Lists.newArrayList();
        boolean flag = true;
        for (MobEffectInstance mobeffectinstance : p_331825_) {
            flag = false;
            Holder<MobEffect> holder = mobeffectinstance.getEffect();
            int i = mobeffectinstance.getAmplifier();
            holder.value().createModifiers(i, (p_331556_, p_330860_) -> list.add(new Pair(p_331556_, p_330860_)));
            MutableComponent mutablecomponent = PotionContents.getPotionDescription(holder, i);
            if (!mobeffectinstance.endsWithin(20)) {
                mutablecomponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.formatDuration((MobEffectInstance)mobeffectinstance, (float)p_332038_, (float)p_332014_)});
            }
            p_331296_.accept((Component)mutablecomponent.withStyle(holder.value().getCategory().getTooltipFormatting()));
        }
        if (flag) {
            p_331296_.accept(NO_EFFECT);
        }
        if (!list.isEmpty()) {
            p_331296_.accept(CommonComponents.EMPTY);
            p_331296_.accept((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            AttributeUtil.addPotionTooltip((List)list, p_331296_);
            return;
        }
    }

    public static MutableComponent getPotionDescription(Holder<MobEffect> p_397215_, int p_397091_) {
        MutableComponent mutablecomponent = Component.translatable((String)p_397215_.value().getDescriptionId());
        return p_397091_ > 0 ? Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.translatable((String)("potion.potency." + p_397091_))}) : mutablecomponent;
    }

    public void onConsume(Level p_366836_, LivingEntity p_366750_, ItemStack p_366399_, Consumable p_366541_) {
        this.applyToLivingEntity(p_366750_, p_366399_.getOrDefault(DataComponents.POTION_DURATION_SCALE, Float.valueOf(1.0f)).floatValue());
    }

    public void addToTooltip(Item.TooltipContext p_399531_, Consumer<Component> p_399764_, TooltipFlag p_400075_, DataComponentGetter p_400022_) {
        PotionContents.addPotionTooltip(this.getAllEffects(), p_399764_, p_400022_.getOrDefault(DataComponents.POTION_DURATION_SCALE, Float.valueOf(1.0f)).floatValue(), p_399531_.tickRate());
    }
}

