/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.world.chunk.ForcedChunkManager;
import org.slf4j.Logger;

public class TicketStorage
extends SavedData {
    private static final int INITIAL_TICKET_LIST_CAPACITY = 4;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<Pair<ChunkPos, Ticket>> TICKET_ENTRY = Codec.mapPair((MapCodec)ChunkPos.CODEC.fieldOf("chunk_pos"), (MapCodec)Ticket.CODEC).codec();
    public static final Codec<TicketStorage> CODEC = RecordCodecBuilder.create(p_400948_ -> p_400948_.group((App)TICKET_ENTRY.listOf().optionalFieldOf("tickets", List.of()).forGetter(TicketStorage::packTickets)).and(ForcedChunkManager.defineExtraStorageParams()).apply((Applicative)p_400948_, (tickets, neoData) -> ForcedChunkManager.readStoredTickets(TicketStorage::fromPacked, (List)tickets, (List)neoData)));
    public static final SavedDataType<TicketStorage> TYPE = new SavedDataType<TicketStorage>("chunks", TicketStorage::new, CODEC, DataFixTypes.SAVED_DATA_FORCED_CHUNKS);
    private final Long2ObjectOpenHashMap<List<Ticket>> tickets;
    private final Long2ObjectOpenHashMap<List<Ticket>> deactivatedTickets;
    private LongSet chunksWithForcedTickets = new LongOpenHashSet();
    @Nullable
    private ChunkUpdated loadingChunkUpdatedListener;
    @Nullable
    private ChunkUpdated simulationChunkUpdatedListener;
    private final ForcedChunkManager.TicketTracker<BlockPos> blockForcedChunks = new ForcedChunkManager.TicketTracker(this, NeoForgeMod.BLOCK_TICKET, NeoForgeMod.BLOCK_WITH_NATURAL_SPAWNING_TICKET);
    private final ForcedChunkManager.TicketTracker<UUID> entityForcedChunks = new ForcedChunkManager.TicketTracker(this, NeoForgeMod.ENTITY_TICKET, NeoForgeMod.ENTITY_WITH_NATURAL_SPAWNING_TICKET);
    private LongSet chunksWithForceNaturalSpawning = new LongOpenHashSet();

    private TicketStorage(Long2ObjectOpenHashMap<List<Ticket>> p_393873_, Long2ObjectOpenHashMap<List<Ticket>> p_394615_) {
        this.tickets = p_393873_;
        this.deactivatedTickets = p_394615_;
        this.updateForcedChunks();
        this.updateForcedNaturalSpawning();
    }

    public TicketStorage() {
        this((Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap(4), (Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap());
    }

    private static TicketStorage fromPacked(List<Pair<ChunkPos, Ticket>> p_401113_) {
        Long2ObjectOpenHashMap long2objectopenhashmap = new Long2ObjectOpenHashMap();
        for (Pair<ChunkPos, Ticket> pair : p_401113_) {
            ChunkPos chunkpos = (ChunkPos)pair.getFirst();
            List list = (List)long2objectopenhashmap.computeIfAbsent(chunkpos.toLong(), p_393722_ -> new ObjectArrayList(4));
            list.add((Ticket)pair.getSecond());
        }
        return new TicketStorage((Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap(4), (Long2ObjectOpenHashMap<List<Ticket>>)long2objectopenhashmap);
    }

    private List<Pair<ChunkPos, Ticket>> packTickets() {
        ArrayList<Pair<ChunkPos, Ticket>> list = new ArrayList<Pair<ChunkPos, Ticket>>();
        this.forEachTicket((p_400946_, p_400947_) -> {
            if (p_400947_.getType().persist()) {
                list.add(new Pair(p_400946_, p_400947_));
            }
        });
        return list;
    }

    private void forEachTicket(BiConsumer<ChunkPos, Ticket> p_401023_) {
        TicketStorage.forEachTicket(p_401023_, this.tickets);
        TicketStorage.forEachTicket(p_401023_, this.deactivatedTickets);
    }

    private static void forEachTicket(BiConsumer<ChunkPos, Ticket> p_401366_, Long2ObjectOpenHashMap<List<Ticket>> p_401184_) {
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(p_401184_)) {
            ChunkPos chunkpos = new ChunkPos(entry.getLongKey());
            for (Ticket ticket : (List)entry.getValue()) {
                p_401366_.accept(chunkpos, ticket);
            }
        }
    }

    public void activateAllDeactivatedTickets() {
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.deactivatedTickets)) {
            for (Ticket ticket : (List)entry.getValue()) {
                this.addTicket(entry.getLongKey(), ticket);
            }
        }
        this.deactivatedTickets.clear();
    }

    public void setLoadingChunkUpdatedListener(@Nullable ChunkUpdated p_393504_) {
        this.loadingChunkUpdatedListener = p_393504_;
    }

    public void setSimulationChunkUpdatedListener(@Nullable ChunkUpdated p_394582_) {
        this.simulationChunkUpdatedListener = p_394582_;
    }

    public boolean hasTickets() {
        return !this.tickets.isEmpty();
    }

    public List<Ticket> getTickets(long p_393509_) {
        return (List)this.tickets.getOrDefault(p_393509_, List.of());
    }

    private List<Ticket> getOrCreateTickets(long p_394358_) {
        return (List)this.tickets.computeIfAbsent(p_394358_, p_393919_ -> new ObjectArrayList(4));
    }

    public void addTicketWithRadius(TicketType p_394465_, ChunkPos p_394654_, int p_393587_) {
        Ticket ticket = new Ticket(p_394465_, ChunkLevel.byStatus((FullChunkStatus)FullChunkStatus.FULL) - p_393587_);
        this.addTicket(p_394654_.toLong(), ticket);
    }

    public void addTicket(Ticket p_394208_, ChunkPos p_394290_) {
        this.addTicket(p_394290_.toLong(), p_394208_);
    }

    public boolean addTicket(long p_394247_, Ticket p_394469_) {
        List<Ticket> list = this.getOrCreateTickets(p_394247_);
        for (Ticket ticket : list) {
            if (!TicketStorage.isTicketSameTypeAndLevel(p_394469_, ticket)) continue;
            ticket.resetTicksLeft();
            this.setDirty();
            return false;
        }
        int i = TicketStorage.getTicketLevelAt(list, true);
        int j = TicketStorage.getTicketLevelAt(list, false);
        list.add(p_394469_);
        if (p_394469_.getType().doesSimulate() && p_394469_.getTicketLevel() < i && this.simulationChunkUpdatedListener != null) {
            this.simulationChunkUpdatedListener.update(p_394247_, p_394469_.getTicketLevel(), true);
        }
        if (p_394469_.getType().doesLoad() && p_394469_.getTicketLevel() < j && this.loadingChunkUpdatedListener != null) {
            this.loadingChunkUpdatedListener.update(p_394247_, p_394469_.getTicketLevel(), true);
        }
        if (p_394469_.getType().equals(TicketType.FORCED)) {
            this.chunksWithForcedTickets.add(p_394247_);
        }
        if (p_394469_.getType().forceNaturalSpawning()) {
            this.chunksWithForceNaturalSpawning.add(p_394247_);
        }
        this.setDirty();
        return true;
    }

    private static boolean isTicketSameTypeAndLevel(Ticket p_394344_, Ticket p_394181_) {
        return p_394181_.getType() == p_394344_.getType() && p_394181_.getTicketLevel() == p_394344_.getTicketLevel();
    }

    public int getTicketLevelAt(long p_393578_, boolean p_393891_) {
        return TicketStorage.getTicketLevelAt(this.getTickets(p_393578_), p_393891_);
    }

    private static int getTicketLevelAt(List<Ticket> p_394021_, boolean p_393941_) {
        Ticket ticket = TicketStorage.getLowestTicket(p_394021_, p_393941_);
        return ticket == null ? ChunkLevel.MAX_LEVEL + 1 : ticket.getTicketLevel();
    }

    @Nullable
    private static Ticket getLowestTicket(@Nullable List<Ticket> p_394073_, boolean p_394430_) {
        if (p_394073_ == null) {
            return null;
        }
        Ticket ticket = null;
        for (Ticket ticket1 : p_394073_) {
            if (ticket != null && ticket1.getTicketLevel() >= ticket.getTicketLevel()) continue;
            if (p_394430_ && ticket1.getType().doesSimulate()) {
                ticket = ticket1;
                continue;
            }
            if (p_394430_ || !ticket1.getType().doesLoad()) continue;
            ticket = ticket1;
        }
        return ticket;
    }

    public void removeTicketWithRadius(TicketType p_394013_, ChunkPos p_393657_, int p_394336_) {
        Ticket ticket = new Ticket(p_394013_, ChunkLevel.byStatus((FullChunkStatus)FullChunkStatus.FULL) - p_394336_);
        this.removeTicket(p_393657_.toLong(), ticket);
    }

    public void removeTicket(Ticket p_394399_, ChunkPos p_393510_) {
        this.removeTicket(p_393510_.toLong(), p_394399_);
    }

    public boolean removeTicket(long p_393896_, Ticket p_394054_) {
        List list = (List)this.tickets.get(p_393896_);
        if (list == null) {
            return false;
        }
        boolean flag = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Ticket ticket = (Ticket)iterator.next();
            if (!TicketStorage.isTicketSameTypeAndLevel(p_394054_, ticket)) continue;
            iterator.remove();
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        if (list.isEmpty()) {
            this.tickets.remove(p_393896_);
        }
        if (p_394054_.getType().doesSimulate() && this.simulationChunkUpdatedListener != null) {
            this.simulationChunkUpdatedListener.update(p_393896_, TicketStorage.getTicketLevelAt(list, true), false);
        }
        if (p_394054_.getType().doesLoad() && this.loadingChunkUpdatedListener != null) {
            this.loadingChunkUpdatedListener.update(p_393896_, TicketStorage.getTicketLevelAt(list, false), false);
        }
        if (p_394054_.getType().equals(TicketType.FORCED)) {
            this.updateForcedChunks();
        }
        if (p_394054_.getType().forceNaturalSpawning()) {
            this.updateForcedNaturalSpawning();
        }
        this.setDirty();
        return true;
    }

    private void updateForcedChunks() {
        this.chunksWithForcedTickets = this.getAllChunksWithTicketThat(p_393889_ -> p_393889_.getType().equals(TicketType.FORCED));
    }

    public String getTicketDebugString(long p_393749_, boolean p_394364_) {
        List<Ticket> list = this.getTickets(p_393749_);
        Ticket ticket = TicketStorage.getLowestTicket(list, p_394364_);
        return ticket == null ? "no_ticket" : ticket.toString();
    }

    public void purgeStaleTickets() {
        this.removeTicketIf(p_393626_ -> {
            p_393626_.decreaseTicksLeft();
            return p_393626_.isTimedOut();
        }, null);
        this.setDirty();
    }

    public void deactivateTicketsOnClosing() {
        this.removeTicketIf(p_394604_ -> p_394604_.getType() != TicketType.UNKNOWN, this.deactivatedTickets);
        this.blockForcedChunks.deactivateTicketsOnClosing();
        this.entityForcedChunks.deactivateTicketsOnClosing();
    }

    public void removeTicketIf(Predicate<Ticket> p_393810_, @Nullable Long2ObjectOpenHashMap<List<Ticket>> p_393746_) {
        ObjectIterator objectiterator = this.tickets.long2ObjectEntrySet().fastIterator();
        boolean flag = false;
        boolean updateNaturalSpawning = false;
        while (objectiterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectiterator.next();
            Iterator iterator = ((List)entry.getValue()).iterator();
            boolean flag1 = false;
            boolean flag2 = false;
            while (iterator.hasNext()) {
                Ticket ticket = (Ticket)iterator.next();
                if (!p_393810_.test(ticket)) continue;
                if (p_393746_ != null) {
                    List list = (List)p_393746_.computeIfAbsent(entry.getLongKey(), p_394107_ -> new ObjectArrayList(((List)entry.getValue()).size()));
                    list.add(ticket);
                }
                iterator.remove();
                if (ticket.getType().doesLoad()) {
                    flag2 = true;
                }
                if (ticket.getType().doesSimulate()) {
                    flag1 = true;
                }
                if (ticket.getType().equals(TicketType.FORCED)) {
                    flag = true;
                }
                if (!ticket.getType().forceNaturalSpawning()) continue;
                updateNaturalSpawning = true;
            }
            if (!flag2 && !flag1) continue;
            if (flag2 && this.loadingChunkUpdatedListener != null) {
                this.loadingChunkUpdatedListener.update(entry.getLongKey(), TicketStorage.getTicketLevelAt((List)entry.getValue(), false), false);
            }
            if (flag1 && this.simulationChunkUpdatedListener != null) {
                this.simulationChunkUpdatedListener.update(entry.getLongKey(), TicketStorage.getTicketLevelAt((List)entry.getValue(), true), false);
            }
            this.setDirty();
            if (!((List)entry.getValue()).isEmpty()) continue;
            objectiterator.remove();
        }
        if (flag) {
            this.updateForcedChunks();
        }
        if (updateNaturalSpawning) {
            this.updateForcedNaturalSpawning();
        }
    }

    public void replaceTicketLevelOfType(int p_393875_, TicketType p_394261_) {
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (Long2ObjectMap.Entry entry : this.tickets.long2ObjectEntrySet()) {
            for (Ticket ticket : (List)entry.getValue()) {
                if (ticket.getType() != p_394261_) continue;
                list.add(Pair.of((Object)ticket, (Object)entry.getLongKey()));
            }
        }
        for (Pair pair : list) {
            Long olong = (Long)pair.getSecond();
            Ticket ticket1 = (Ticket)pair.getFirst();
            this.removeTicket(olong, ticket1);
            TicketType tickettype = ticket1.getType();
            this.addTicket(olong, new Ticket(tickettype, p_393875_));
        }
    }

    public boolean updateChunkForced(ChunkPos p_394535_, boolean p_394618_) {
        Ticket ticket = new Ticket(TicketType.FORCED, ChunkMap.FORCED_TICKET_LEVEL);
        return p_394618_ ? this.addTicket(p_394535_.toLong(), ticket) : this.removeTicket(p_394535_.toLong(), ticket);
    }

    public LongSet getForceLoadedChunks() {
        return this.chunksWithForcedTickets;
    }

    private LongSet getAllChunksWithTicketThat(Predicate<Ticket> p_393731_) {
        LongOpenHashSet longopenhashset = new LongOpenHashSet();
        block0: for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.tickets)) {
            for (Ticket ticket : (List)entry.getValue()) {
                if (!p_393731_.test(ticket)) continue;
                longopenhashset.add(entry.getLongKey());
                continue block0;
            }
        }
        return longopenhashset;
    }

    public ForcedChunkManager.TicketTracker<BlockPos> getBlockForcedChunks() {
        return this.blockForcedChunks;
    }

    public ForcedChunkManager.TicketTracker<UUID> getEntityForcedChunks() {
        return this.entityForcedChunks;
    }

    private void updateForcedNaturalSpawning() {
        this.chunksWithForceNaturalSpawning = this.getAllChunksWithTicketThat(ticket -> ticket.getType().forceNaturalSpawning());
    }

    public boolean shouldForceNaturalSpawning(ChunkPos chunkPos) {
        return this.chunksWithForceNaturalSpawning.contains(chunkPos.toLong());
    }

    @FunctionalInterface
    public static interface ChunkUpdated {
        public void update(long var1, int var3, boolean var4);
    }
}

