/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TriState;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;

public class ChorusPlantBlock
extends PipeBlock {
    public static final MapCodec<ChorusPlantBlock> CODEC = ChorusPlantBlock.simpleCodec(ChorusPlantBlock::new);

    public MapCodec<ChorusPlantBlock> codec() {
        return CODEC;
    }

    public ChorusPlantBlock(BlockBehaviour.Properties p_51707_) {
        super(10.0f, p_51707_);
        this.registerDefaultState((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, Boolean.valueOf(false)))).setValue((Property)EAST, Boolean.valueOf(false)))).setValue((Property)SOUTH, Boolean.valueOf(false)))).setValue((Property)WEST, Boolean.valueOf(false)))).setValue((Property)UP, Boolean.valueOf(false)))).setValue((Property)DOWN, Boolean.valueOf(false))));
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_51709_) {
        return ChorusPlantBlock.getStateWithConnections((BlockGetter)((Object)p_51709_.getLevel()), p_51709_.getClickedPos(), this.defaultBlockState());
    }

    public static BlockState getStateWithConnections(BlockGetter p_51711_, BlockPos p_51712_, BlockState p_304771_) {
        BlockState blockstate = p_51711_.getBlockState(p_51712_.below());
        BlockState blockstate1 = p_51711_.getBlockState(p_51712_.above());
        BlockState blockstate2 = p_51711_.getBlockState(p_51712_.north());
        BlockState blockstate3 = p_51711_.getBlockState(p_51712_.east());
        BlockState blockstate4 = p_51711_.getBlockState(p_51712_.south());
        BlockState blockstate5 = p_51711_.getBlockState(p_51712_.west());
        Block block = p_304771_.getBlock();
        TriState soilDecision = blockstate.canSustainPlant(p_51711_, p_51712_.below(), Direction.UP, p_304771_);
        return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)p_304771_.trySetValue((Property)DOWN, Boolean.valueOf(blockstate.is(block) || blockstate.is(Blocks.CHORUS_FLOWER) || blockstate.is(Blocks.END_STONE) || soilDecision.isTrue())))).trySetValue((Property)UP, Boolean.valueOf(blockstate1.is(block) || blockstate1.is(Blocks.CHORUS_FLOWER))))).trySetValue((Property)NORTH, Boolean.valueOf(blockstate2.is(block) || blockstate2.is(Blocks.CHORUS_FLOWER))))).trySetValue((Property)EAST, Boolean.valueOf(blockstate3.is(block) || blockstate3.is(Blocks.CHORUS_FLOWER))))).trySetValue((Property)SOUTH, Boolean.valueOf(blockstate4.is(block) || blockstate4.is(Blocks.CHORUS_FLOWER))))).trySetValue((Property)WEST, Boolean.valueOf(blockstate5.is(block) || blockstate5.is(Blocks.CHORUS_FLOWER))));
    }

    protected BlockState updateShape(BlockState p_51728_, LevelReader p_374320_, ScheduledTickAccess p_374500_, BlockPos p_51732_, Direction p_51729_, BlockPos p_51733_, BlockState p_51730_, RandomSource p_374170_) {
        TriState soilDecision;
        boolean flag;
        if (!p_51728_.canSurvive(p_374320_, p_51732_)) {
            p_374500_.scheduleTick(p_51732_, (Block)((Object)this), 1);
            return super.updateShape(p_51728_, p_374320_, p_374500_, p_51732_, p_51729_, p_51733_, p_51730_, p_374170_);
        }
        boolean bl = flag = p_51730_.is((Block)((Object)this)) || p_51730_.is(Blocks.CHORUS_FLOWER) || p_51729_ == Direction.DOWN && p_51730_.is(Blocks.END_STONE);
        if (p_51729_ == Direction.DOWN && !(soilDecision = p_51730_.canSustainPlant(p_374320_, p_51733_.relative(p_51729_), p_51729_.getOpposite(), p_51728_)).isDefault()) {
            flag = soilDecision.isTrue();
        }
        return (BlockState)((Object)p_51728_.setValue((Property)PROPERTY_BY_DIRECTION.get(p_51729_), Boolean.valueOf(flag)));
    }

    protected void tick(BlockState p_220985_, ServerLevel p_220986_, BlockPos p_220987_, RandomSource p_220988_) {
        if (!p_220985_.canSurvive((LevelReader)((Object)p_220986_), p_220987_)) {
            p_220986_.destroyBlock(p_220987_, true);
        }
    }

    protected boolean canSurvive(BlockState p_51724_, LevelReader p_51725_, BlockPos p_51726_) {
        BlockState blockstate = p_51725_.getBlockState(p_51726_.below());
        boolean flag = !p_51725_.getBlockState(p_51726_.above()).isAir() && !blockstate.isAir();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = p_51726_.relative(direction);
            BlockState blockstate1 = p_51725_.getBlockState(blockpos);
            if (!blockstate1.is((Block)((Object)this))) continue;
            if (flag) {
                return false;
            }
            BlockState blockstate2 = p_51725_.getBlockState(blockpos.below());
            if (!blockstate2.is((Block)((Object)this)) && !blockstate2.is(Blocks.END_STONE)) continue;
            return true;
        }
        TriState soilDecision = blockstate.canSustainPlant(p_51725_, p_51726_.below(), Direction.UP, p_51724_);
        if (!soilDecision.isDefault()) {
            return soilDecision.isTrue();
        }
        return blockstate.is((Block)((Object)this)) || blockstate.is(Blocks.END_STONE);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_51735_) {
        p_51735_.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    protected boolean isPathfindable(BlockState p_51719_, PathComputationType p_51722_) {
        return false;
    }
}

