/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DoorBlock
extends Block {
    public static final MapCodec<DoorBlock> CODEC = RecordCodecBuilder.mapCodec(p_368420_ -> p_368420_.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(DoorBlock::type), DoorBlock.propertiesCodec()).apply((Applicative)p_368420_, DoorBlock::new));
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.DOOR_HINGE;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateHorizontal((VoxelShape)Block.boxZ(16.0, 13.0, 16.0));
    private final BlockSetType type;

    public MapCodec<? extends DoorBlock> codec() {
        return CODEC;
    }

    public DoorBlock(BlockSetType p_272854_, BlockBehaviour.Properties p_273303_) {
        super(p_273303_.sound(p_272854_.soundType()));
        this.type = p_272854_;
        this.registerDefaultState((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH))).setValue((Property)OPEN, Boolean.valueOf(false)))).setValue((Property)HINGE, (Comparable)DoorHingeSide.LEFT))).setValue((Property)POWERED, Boolean.valueOf(false)))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)));
    }

    public BlockSetType type() {
        return this.type;
    }

    @Override
    protected VoxelShape getShape(BlockState p_52807_, BlockGetter p_52808_, BlockPos p_52809_, CollisionContext p_52810_) {
        Direction direction = (Direction)p_52807_.getValue((Property)FACING);
        Direction direction1 = ((Boolean)p_52807_.getValue((Property)OPEN)).booleanValue() ? (p_52807_.getValue((Property)HINGE) == DoorHingeSide.RIGHT ? direction.getCounterClockWise() : direction.getClockWise()) : direction;
        return SHAPES.get(direction1);
    }

    @Override
    protected BlockState updateShape(BlockState p_52796_, LevelReader p_374501_, ScheduledTickAccess p_374380_, BlockPos p_52800_, Direction p_52797_, BlockPos p_52801_, BlockState p_52798_, RandomSource p_374395_) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)p_52796_.getValue((Property)HALF);
        if (p_52797_.getAxis() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (p_52797_ == Direction.UP)) {
            return doubleblockhalf == DoubleBlockHalf.LOWER && p_52797_ == Direction.DOWN && !p_52796_.canSurvive(p_374501_, p_52800_) ? Blocks.AIR.defaultBlockState() : super.updateShape(p_52796_, p_374501_, p_374380_, p_52800_, p_52797_, p_52801_, p_52798_, p_374395_);
        }
        return p_52798_.getBlock() instanceof DoorBlock && p_52798_.getValue((Property)HALF) != doubleblockhalf ? (BlockState)((Object)p_52798_.setValue((Property)HALF, (Comparable)doubleblockhalf)) : Blocks.AIR.defaultBlockState();
    }

    @Override
    protected void onExplosionHit(BlockState p_312769_, ServerLevel p_363080_, BlockPos p_311900_, Explosion p_312544_, BiConsumer<ItemStack, BlockPos> p_312107_) {
        if (p_312544_.canTriggerBlocks() && p_312769_.getValue((Property)HALF) == DoubleBlockHalf.LOWER && this.type.canOpenByWindCharge() && !((Boolean)p_312769_.getValue((Property)POWERED)).booleanValue()) {
            this.setOpen(null, p_363080_, p_312769_, p_311900_, !this.isOpen(p_312769_));
        }
        super.onExplosionHit(p_312769_, p_363080_, p_311900_, p_312544_, p_312107_);
    }

    @Override
    public BlockState playerWillDestroy(Level p_52755_, BlockPos p_52756_, BlockState p_52757_, Player p_52758_) {
        if (!(p_52755_.isClientSide || !p_52758_.isCreative() && p_52758_.hasCorrectToolForDrops(p_52757_, p_52755_, p_52756_))) {
            DoublePlantBlock.preventDropFromBottomPart(p_52755_, p_52756_, p_52757_, p_52758_);
        }
        return super.playerWillDestroy(p_52755_, p_52756_, p_52757_, p_52758_);
    }

    @Override
    protected boolean isPathfindable(BlockState p_52764_, PathComputationType p_52767_) {
        return switch (p_52767_) {
            default -> throw new MatchException(null, null);
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)p_52764_.getValue((Property)OPEN);
            case PathComputationType.WATER -> false;
        };
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_52739_) {
        BlockPos blockpos = p_52739_.getClickedPos();
        Level level = p_52739_.getLevel();
        if (blockpos.getY() < level.getMaxY() && level.getBlockState(blockpos.above()).canBeReplaced(p_52739_)) {
            boolean flag = level.hasNeighborSignal(blockpos) || level.hasNeighborSignal(blockpos.above());
            return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)this.defaultBlockState().setValue((Property)FACING, (Comparable)p_52739_.getHorizontalDirection()))).setValue((Property)HINGE, (Comparable)this.getHinge(p_52739_)))).setValue((Property)POWERED, Boolean.valueOf(flag)))).setValue((Property)OPEN, Boolean.valueOf(flag)))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER));
        }
        return null;
    }

    @Override
    public void setPlacedBy(Level p_52749_, BlockPos p_52750_, BlockState p_52751_, LivingEntity p_52752_, ItemStack p_52753_) {
        p_52749_.setBlock(p_52750_.above(), (BlockState)((Object)p_52751_.setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER)), 3);
    }

    private DoorHingeSide getHinge(BlockPlaceContext p_52805_) {
        boolean flag1;
        Level blockgetter = p_52805_.getLevel();
        BlockPos blockpos = p_52805_.getClickedPos();
        Direction direction = p_52805_.getHorizontalDirection();
        BlockPos blockpos1 = blockpos.above();
        Direction direction1 = direction.getCounterClockWise();
        BlockPos blockpos2 = blockpos.relative(direction1);
        BlockState blockstate = blockgetter.getBlockState(blockpos2);
        BlockPos blockpos3 = blockpos1.relative(direction1);
        BlockState blockstate1 = blockgetter.getBlockState(blockpos3);
        Direction direction2 = direction.getClockWise();
        BlockPos blockpos4 = blockpos.relative(direction2);
        BlockState blockstate2 = blockgetter.getBlockState(blockpos4);
        BlockPos blockpos5 = blockpos1.relative(direction2);
        BlockState blockstate3 = blockgetter.getBlockState(blockpos5);
        int i = (blockstate.isCollisionShapeFullBlock((BlockGetter)((Object)blockgetter), blockpos2) ? -1 : 0) + (blockstate1.isCollisionShapeFullBlock((BlockGetter)((Object)blockgetter), blockpos3) ? -1 : 0) + (blockstate2.isCollisionShapeFullBlock((BlockGetter)((Object)blockgetter), blockpos4) ? 1 : 0) + (blockstate3.isCollisionShapeFullBlock((BlockGetter)((Object)blockgetter), blockpos5) ? 1 : 0);
        boolean flag = blockstate.getBlock() instanceof DoorBlock && blockstate.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
        boolean bl = flag1 = blockstate2.getBlock() instanceof DoorBlock && blockstate2.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.getStepX();
                int k = direction.getStepZ();
                Vec3 vec3 = p_52805_.getClickLocation();
                double d0 = vec3.x - (double)blockpos.getX();
                double d1 = vec3.z - (double)blockpos.getZ();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_52769_, Level p_52770_, BlockPos p_52771_, Player p_52772_, BlockHitResult p_52774_) {
        if (!this.type.canOpenByHand()) {
            return InteractionResult.PASS;
        }
        p_52769_ = (BlockState)((Object)p_52769_.cycle((Property)OPEN));
        p_52770_.setBlock(p_52771_, p_52769_, 10);
        this.playSound(p_52772_, p_52770_, p_52771_, (Boolean)p_52769_.getValue((Property)OPEN));
        p_52770_.gameEvent(p_52772_, this.isOpen(p_52769_) ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, p_52771_);
        return InteractionResult.SUCCESS;
    }

    public boolean isOpen(BlockState p_52816_) {
        return (Boolean)p_52816_.getValue((Property)OPEN);
    }

    public void setOpen(@Nullable Entity p_153166_, Level p_153167_, BlockState p_153168_, BlockPos p_153169_, boolean p_153170_) {
        if (p_153168_.is(this) && (Boolean)p_153168_.getValue((Property)OPEN) != p_153170_) {
            p_153167_.setBlock(p_153169_, (BlockState)((Object)p_153168_.setValue((Property)OPEN, Boolean.valueOf(p_153170_))), 10);
            this.playSound(p_153166_, p_153167_, p_153169_, p_153170_);
            p_153167_.gameEvent(p_153166_, p_153170_ ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, p_153169_);
        }
    }

    @Override
    protected void neighborChanged(BlockState p_52776_, Level p_52777_, BlockPos p_52778_, Block p_52779_, @Nullable Orientation p_361881_, boolean p_52781_) {
        boolean flag;
        boolean bl = p_52777_.hasNeighborSignal(p_52778_) || p_52777_.hasNeighborSignal(p_52778_.relative(p_52776_.getValue((Property)HALF) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN)) ? true : (flag = false);
        if (!this.defaultBlockState().is(p_52779_) && flag != (Boolean)p_52776_.getValue((Property)POWERED)) {
            if (flag != (Boolean)p_52776_.getValue((Property)OPEN)) {
                this.playSound(null, p_52777_, p_52778_, flag);
                p_52777_.gameEvent(null, flag ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, p_52778_);
            }
            p_52777_.setBlock(p_52778_, (BlockState)((Object)((BlockState)((Object)p_52776_.setValue((Property)POWERED, Boolean.valueOf(flag)))).setValue((Property)OPEN, Boolean.valueOf(flag))), 2);
        }
    }

    @Override
    protected boolean canSurvive(BlockState p_52783_, LevelReader p_52784_, BlockPos p_52785_) {
        BlockPos blockpos = p_52785_.below();
        BlockState blockstate = p_52784_.getBlockState(blockpos);
        return p_52783_.getValue((Property)HALF) == DoubleBlockHalf.LOWER ? blockstate.isFaceSturdy(p_52784_, blockpos, Direction.UP) : blockstate.is(this);
    }

    private void playSound(@Nullable Entity p_251616_, Level p_249656_, BlockPos p_249439_, boolean p_251628_) {
        p_249656_.playSound(p_251616_, p_249439_, p_251628_ ? this.type.doorOpen() : this.type.doorClose(), SoundSource.BLOCKS, 1.0f, p_249656_.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    @Override
    protected BlockState rotate(BlockState p_52790_, Rotation p_52791_) {
        return (BlockState)((Object)p_52790_.setValue((Property)FACING, (Comparable)p_52791_.rotate((Direction)p_52790_.getValue((Property)FACING))));
    }

    @Override
    protected BlockState mirror(BlockState p_52787_, Mirror p_52788_) {
        return p_52788_ == Mirror.NONE ? p_52787_ : (BlockState)((Object)p_52787_.rotate(p_52788_.getRotation((Direction)p_52787_.getValue((Property)FACING))).cycle((Property)HINGE));
    }

    @Override
    protected long getSeed(BlockState p_52793_, BlockPos p_52794_) {
        return Mth.getSeed((int)p_52794_.getX(), (int)p_52794_.below(p_52793_.getValue((Property)HALF) == DoubleBlockHalf.LOWER ? 0 : 1).getY(), (int)p_52794_.getZ());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_52803_) {
        p_52803_.add(new Property[]{HALF, FACING, OPEN, HINGE, POWERED});
    }

    public static boolean isWoodenDoor(Level p_52746_, BlockPos p_52747_) {
        return DoorBlock.isWoodenDoor(p_52746_.getBlockState(p_52747_));
    }

    public static boolean isWoodenDoor(BlockState p_52818_) {
        DoorBlock doorblock;
        Block block = p_52818_.getBlock();
        return block instanceof DoorBlock && (doorblock = (DoorBlock)block).type().canOpenByHand();
    }
}

