/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FenceGateBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<FenceGateBlock> CODEC = RecordCodecBuilder.mapCodec(p_308823_ -> p_308823_.group((App)WoodType.CODEC.optionalFieldOf("wood_type").forGetter(p_304842_ -> Optional.ofNullable(p_304842_.type)), (App)FenceGateBlock.propertiesCodec(), (App)SoundEvent.DIRECT_CODEC.optionalFieldOf("open_sound").forGetter(fence -> Optional.of(fence.openSound).filter(s -> fence.type == null || s != fence.type.fenceGateOpen())), (App)SoundEvent.DIRECT_CODEC.optionalFieldOf("close_sound").forGetter(fence -> Optional.of(fence.closeSound).filter(s -> fence.type == null || s != fence.type.fenceGateClose()))).apply((Applicative)p_308823_, FenceGateBlock::new));
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty IN_WALL = BlockStateProperties.IN_WALL;
    private static final Map<Direction.Axis, VoxelShape> SHAPES = Shapes.rotateHorizontalAxis((VoxelShape)Block.cube(16.0, 16.0, 4.0));
    private static final Map<Direction.Axis, VoxelShape> SHAPES_WALL = Maps.newEnumMap(Util.mapValues(SHAPES, p_393358_ -> Shapes.join((VoxelShape)p_393358_, (VoxelShape)Block.column(16.0, 13.0, 16.0), (BooleanOp)BooleanOp.ONLY_FIRST)));
    private static final Map<Direction.Axis, VoxelShape> SHAPE_COLLISION = Shapes.rotateHorizontalAxis((VoxelShape)Block.column(16.0, 4.0, 0.0, 24.0));
    private static final Map<Direction.Axis, VoxelShape> SHAPE_SUPPORT = Shapes.rotateHorizontalAxis((VoxelShape)Block.column(16.0, 4.0, 5.0, 24.0));
    private static final Map<Direction.Axis, VoxelShape> SHAPE_OCCLUSION = Shapes.rotateHorizontalAxis((VoxelShape)Shapes.or((VoxelShape)Block.box(0.0, 5.0, 7.0, 2.0, 16.0, 9.0), (VoxelShape)Block.box(14.0, 5.0, 7.0, 16.0, 16.0, 9.0)));
    private static final Map<Direction.Axis, VoxelShape> SHAPE_OCCLUSION_WALL = Maps.newEnumMap(Util.mapValues(SHAPE_OCCLUSION, p_393359_ -> p_393359_.move(0.0, -0.1875, 0.0).optimize()));
    public final SoundEvent openSound;
    public final SoundEvent closeSound;
    @Nullable
    private final WoodType type;

    public MapCodec<FenceGateBlock> codec() {
        return CODEC;
    }

    public FenceGateBlock(WoodType p_273340_, BlockBehaviour.Properties p_273352_) {
        this(Optional.of(p_273340_), p_273352_.sound(p_273340_.soundType()), Optional.of(p_273340_.fenceGateOpen()), Optional.of(p_273340_.fenceGateClose()));
    }

    public FenceGateBlock(BlockBehaviour.Properties p_273352_, SoundEvent openSound, SoundEvent closeSound) {
        this(Optional.empty(), p_273352_, Optional.of(openSound), Optional.of(closeSound));
    }

    public FenceGateBlock(Optional<WoodType> p_273340_, BlockBehaviour.Properties p_273352_, Optional<SoundEvent> openSound, Optional<SoundEvent> closeSound) {
        super(p_273352_);
        Preconditions.checkArgument((p_273340_.isPresent() || openSound.isPresent() && closeSound.isPresent() ? 1 : 0) != 0, (Object)"Fence gates must have sounds set");
        this.type = p_273340_.orElse(null);
        this.openSound = openSound.orElseGet(() -> this.type.fenceGateOpen());
        this.closeSound = closeSound.orElseGet(() -> this.type.fenceGateClose());
        this.registerDefaultState((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.stateDefinition.any()).setValue((Property)OPEN, Boolean.valueOf(false)))).setValue((Property)POWERED, Boolean.valueOf(false)))).setValue((Property)IN_WALL, Boolean.valueOf(false))));
    }

    protected VoxelShape getShape(BlockState p_53391_, BlockGetter p_53392_, BlockPos p_53393_, CollisionContext p_53394_) {
        Direction.Axis direction$axis = ((Direction)p_53391_.getValue((Property)FACING)).getAxis();
        return ((Boolean)p_53391_.getValue((Property)IN_WALL) != false ? SHAPES_WALL : SHAPES).get(direction$axis);
    }

    protected BlockState updateShape(BlockState p_53382_, LevelReader p_374250_, ScheduledTickAccess p_374455_, BlockPos p_53386_, Direction p_53383_, BlockPos p_53387_, BlockState p_53384_, RandomSource p_374522_) {
        Direction.Axis direction$axis = p_53383_.getAxis();
        if (((Direction)p_53382_.getValue((Property)FACING)).getClockWise().getAxis() != direction$axis) {
            return super.updateShape(p_53382_, p_374250_, p_374455_, p_53386_, p_53383_, p_53387_, p_53384_, p_374522_);
        }
        boolean flag = this.isWall(p_53384_) || this.isWall(p_374250_.getBlockState(p_53386_.relative(p_53383_.getOpposite())));
        return (BlockState)((Object)p_53382_.setValue((Property)IN_WALL, Boolean.valueOf(flag)));
    }

    protected VoxelShape getBlockSupportShape(BlockState p_253862_, BlockGetter p_254569_, BlockPos p_254197_) {
        Direction.Axis direction$axis = ((Direction)p_253862_.getValue((Property)FACING)).getAxis();
        return (Boolean)p_253862_.getValue((Property)OPEN) != false ? Shapes.empty() : SHAPE_SUPPORT.get(direction$axis);
    }

    protected VoxelShape getCollisionShape(BlockState p_53396_, BlockGetter p_53397_, BlockPos p_53398_, CollisionContext p_53399_) {
        Direction.Axis direction$axis = ((Direction)p_53396_.getValue((Property)FACING)).getAxis();
        return (Boolean)p_53396_.getValue((Property)OPEN) != false ? Shapes.empty() : SHAPE_COLLISION.get(direction$axis);
    }

    protected VoxelShape getOcclusionShape(BlockState p_53401_) {
        Direction.Axis direction$axis = ((Direction)p_53401_.getValue((Property)FACING)).getAxis();
        return ((Boolean)p_53401_.getValue((Property)IN_WALL) != false ? SHAPE_OCCLUSION_WALL : SHAPE_OCCLUSION).get(direction$axis);
    }

    protected boolean isPathfindable(BlockState p_53360_, PathComputationType p_53363_) {
        switch (p_53363_) {
            case LAND: {
                return (Boolean)p_53360_.getValue((Property)OPEN);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return (Boolean)p_53360_.getValue((Property)OPEN);
            }
        }
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_53358_) {
        Level level = p_53358_.getLevel();
        BlockPos blockpos = p_53358_.getClickedPos();
        boolean flag = level.hasNeighborSignal(blockpos);
        Direction direction = p_53358_.getHorizontalDirection();
        Direction.Axis direction$axis = direction.getAxis();
        boolean flag1 = direction$axis == Direction.Axis.Z && (this.isWall(level.getBlockState(blockpos.west())) || this.isWall(level.getBlockState(blockpos.east()))) || direction$axis == Direction.Axis.X && (this.isWall(level.getBlockState(blockpos.north())) || this.isWall(level.getBlockState(blockpos.south())));
        return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction))).setValue((Property)OPEN, Boolean.valueOf(flag)))).setValue((Property)POWERED, Boolean.valueOf(flag)))).setValue((Property)IN_WALL, Boolean.valueOf(flag1)));
    }

    private boolean isWall(BlockState p_53405_) {
        return p_53405_.is(BlockTags.WALLS);
    }

    protected InteractionResult useWithoutItem(BlockState p_53365_, Level p_53366_, BlockPos p_53367_, Player p_53368_, BlockHitResult p_53370_) {
        if (((Boolean)p_53365_.getValue((Property)OPEN)).booleanValue()) {
            p_53365_ = (BlockState)((Object)p_53365_.setValue((Property)OPEN, Boolean.valueOf(false)));
            p_53366_.setBlock(p_53367_, p_53365_, 10);
        } else {
            Direction direction = p_53368_.getDirection();
            if (p_53365_.getValue((Property)FACING) == direction.getOpposite()) {
                p_53365_ = (BlockState)((Object)p_53365_.setValue((Property)FACING, (Comparable)direction));
            }
            p_53365_ = (BlockState)((Object)p_53365_.setValue((Property)OPEN, Boolean.valueOf(true)));
            p_53366_.setBlock(p_53367_, p_53365_, 10);
        }
        boolean flag = (Boolean)p_53365_.getValue((Property)OPEN);
        p_53366_.playSound((Entity)p_53368_, p_53367_, flag ? this.openSound : this.closeSound, SoundSource.BLOCKS, 1.0f, p_53366_.getRandom().nextFloat() * 0.1f + 0.9f);
        p_53366_.gameEvent(p_53368_, flag ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, p_53367_);
        return InteractionResult.SUCCESS;
    }

    protected void onExplosionHit(BlockState p_312699_, ServerLevel p_361116_, BlockPos p_312680_, Explosion p_312186_, BiConsumer<ItemStack, BlockPos> p_312187_) {
        if (p_312186_.canTriggerBlocks() && !((Boolean)p_312699_.getValue((Property)POWERED)).booleanValue()) {
            boolean flag = (Boolean)p_312699_.getValue((Property)OPEN);
            p_361116_.setBlockAndUpdate(p_312680_, (BlockState)((Object)p_312699_.setValue((Property)OPEN, Boolean.valueOf(!flag))));
            p_361116_.playSound(null, p_312680_, flag ? this.closeSound : this.openSound, SoundSource.BLOCKS, 1.0f, p_361116_.getRandom().nextFloat() * 0.1f + 0.9f);
            p_361116_.gameEvent(flag ? GameEvent.BLOCK_CLOSE : GameEvent.BLOCK_OPEN, p_312680_, GameEvent.Context.of((BlockState)p_312699_));
        }
        super.onExplosionHit(p_312699_, p_361116_, p_312680_, p_312186_, p_312187_);
    }

    protected void neighborChanged(BlockState p_53372_, Level p_53373_, BlockPos p_53374_, Block p_53375_, @javax.annotation.Nullable Orientation p_362989_, boolean p_53377_) {
        if (!p_53373_.isClientSide) {
            boolean flag = p_53373_.hasNeighborSignal(p_53374_);
            if ((Boolean)p_53372_.getValue((Property)POWERED) != flag) {
                p_53373_.setBlock(p_53374_, (BlockState)((Object)((BlockState)((Object)p_53372_.setValue((Property)POWERED, Boolean.valueOf(flag)))).setValue((Property)OPEN, Boolean.valueOf(flag))), 2);
                if ((Boolean)p_53372_.getValue((Property)OPEN) != flag) {
                    p_53373_.playSound(null, p_53374_, flag ? this.openSound : this.closeSound, SoundSource.BLOCKS, 1.0f, p_53373_.getRandom().nextFloat() * 0.1f + 0.9f);
                    p_53373_.gameEvent(null, flag ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, p_53374_);
                }
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_53389_) {
        p_53389_.add(new Property[]{FACING, OPEN, POWERED, IN_WALL});
    }

    public static boolean connectsToDirection(BlockState p_53379_, Direction p_53380_) {
        return ((Direction)p_53379_.getValue((Property)FACING)).getAxis() == p_53380_.getClockWise().getAxis();
    }
}

