/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.IShearable;

public abstract class LeavesBlock
extends Block
implements SimpleWaterloggedBlock,
IShearable {
    public static final int DECAY_DISTANCE = 7;
    public static final IntegerProperty DISTANCE = BlockStateProperties.DISTANCE;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected final float leafParticleChance;
    private static final int TICK_DELAY = 1;

    public abstract MapCodec<? extends LeavesBlock> codec();

    public LeavesBlock(float p_400083_, BlockBehaviour.Properties p_54422_) {
        super(p_54422_);
        this.leafParticleChance = p_400083_;
        this.registerDefaultState((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, Integer.valueOf(7)))).setValue((Property)PERSISTENT, Boolean.valueOf(false)))).setValue((Property)WATERLOGGED, Boolean.valueOf(false))));
    }

    @Override
    protected VoxelShape getBlockSupportShape(BlockState p_54456_, BlockGetter p_54457_, BlockPos p_54458_) {
        return Shapes.empty();
    }

    @Override
    protected boolean isRandomlyTicking(BlockState p_54449_) {
        return (Integer)p_54449_.getValue((Property)DISTANCE) == 7 && (Boolean)p_54449_.getValue((Property)PERSISTENT) == false;
    }

    @Override
    protected void randomTick(BlockState p_221379_, ServerLevel p_221380_, BlockPos p_221381_, RandomSource p_221382_) {
        if (this.decaying(p_221379_)) {
            LeavesBlock.dropResources(p_221379_, p_221380_, p_221381_);
            p_221380_.removeBlock(p_221381_, false);
        }
    }

    protected boolean decaying(BlockState p_221386_) {
        return (Boolean)p_221386_.getValue((Property)PERSISTENT) == false && (Integer)p_221386_.getValue((Property)DISTANCE) == 7;
    }

    @Override
    protected void tick(BlockState p_221369_, ServerLevel p_221370_, BlockPos p_221371_, RandomSource p_221372_) {
        p_221370_.setBlock(p_221371_, LeavesBlock.updateDistance(p_221369_, p_221370_, p_221371_), 3);
    }

    @Override
    protected int getLightBlock(BlockState p_54460_) {
        return 1;
    }

    @Override
    protected BlockState updateShape(BlockState p_54440_, LevelReader p_374064_, ScheduledTickAccess p_374538_, BlockPos p_54444_, Direction p_54441_, BlockPos p_54445_, BlockState p_54442_, RandomSource p_374122_) {
        int i;
        if (((Boolean)p_54440_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_374538_.scheduleTick(p_54444_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(p_374064_));
        }
        if ((i = LeavesBlock.getDistanceAt(p_54442_) + 1) != 1 || (Integer)p_54440_.getValue((Property)DISTANCE) != i) {
            p_374538_.scheduleTick(p_54444_, (Block)this, 1);
        }
        return p_54440_;
    }

    private static BlockState updateDistance(BlockState p_54436_, LevelAccessor p_54437_, BlockPos p_54438_) {
        int i = 7;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$mutableblockpos.setWithOffset((Vec3i)p_54438_, direction);
            i = Math.min(i, LeavesBlock.getDistanceAt(p_54437_.getBlockState((BlockPos)blockpos$mutableblockpos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)((Object)p_54436_.setValue((Property)DISTANCE, Integer.valueOf(i)));
    }

    private static int getDistanceAt(BlockState p_54464_) {
        return LeavesBlock.getOptionalDistanceAt(p_54464_).orElse(7);
    }

    public static OptionalInt getOptionalDistanceAt(BlockState p_277868_) {
        if (p_277868_.is(BlockTags.LOGS)) {
            return OptionalInt.of(0);
        }
        return p_277868_.hasProperty((Property)DISTANCE) ? OptionalInt.of((Integer)p_277868_.getValue((Property)DISTANCE)) : OptionalInt.empty();
    }

    @Override
    protected FluidState getFluidState(BlockState p_221384_) {
        return (Boolean)p_221384_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_221384_);
    }

    @Override
    public void animateTick(BlockState p_221374_, Level p_221375_, BlockPos p_221376_, RandomSource p_221377_) {
        super.animateTick(p_221374_, p_221375_, p_221376_, p_221377_);
        BlockPos blockpos = p_221376_.below();
        BlockState blockstate = p_221375_.getBlockState(blockpos);
        LeavesBlock.makeDrippingWaterParticles(p_221375_, p_221376_, p_221377_, blockstate, blockpos);
        this.makeFallingLeavesParticles(p_221375_, p_221376_, p_221377_, blockstate, blockpos);
    }

    private static void makeDrippingWaterParticles(Level p_394137_, BlockPos p_394032_, RandomSource p_393792_, BlockState p_393464_, BlockPos p_393946_) {
        if (!(!p_394137_.isRainingAt(p_394032_.above()) || p_393792_.nextInt(15) != 1 || p_393464_.canOcclude() && p_393464_.isFaceSturdy((BlockGetter)((Object)p_394137_), p_393946_, Direction.UP))) {
            ParticleUtils.spawnParticleBelow((Level)p_394137_, (BlockPos)p_394032_, (RandomSource)p_393792_, (ParticleOptions)ParticleTypes.DRIPPING_WATER);
        }
    }

    private void makeFallingLeavesParticles(Level p_394081_, BlockPos p_393863_, RandomSource p_394086_, BlockState p_394001_, BlockPos p_393715_) {
        if (!(p_394086_.nextFloat() >= this.leafParticleChance) && !LeavesBlock.isFaceFull(p_394001_.getCollisionShape((BlockGetter)((Object)p_394081_), p_393715_), Direction.UP)) {
            this.spawnFallingLeavesParticle(p_394081_, p_393863_, p_394086_);
        }
    }

    protected abstract void spawnFallingLeavesParticle(Level var1, BlockPos var2, RandomSource var3);

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_54447_) {
        p_54447_.add(new Property[]{DISTANCE, PERSISTENT, WATERLOGGED});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_54424_) {
        FluidState fluidstate = p_54424_.getLevel().getFluidState(p_54424_.getClickedPos());
        BlockState blockstate = (BlockState)((Object)((BlockState)((Object)this.defaultBlockState().setValue((Property)PERSISTENT, Boolean.valueOf(true)))).setValue((Property)WATERLOGGED, Boolean.valueOf(fluidstate.getType() == Fluids.WATER)));
        return LeavesBlock.updateDistance(blockstate, p_54424_.getLevel(), p_54424_.getClickedPos());
    }
}

