/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.CrashReportDetail;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.extensions.IBlockEntityExtension;
import org.slf4j.Logger;

public abstract class BlockEntity
extends AttachmentHolder
implements IBlockEntityExtension {
    private static final Codec<BlockEntityType<?>> TYPE_CODEC = BuiltInRegistries.BLOCK_ENTITY_TYPE.byNameCodec();
    private static final Logger LOGGER = LogUtils.getLogger();
    @Deprecated
    private final BlockEntityType<?> type;
    @Nullable
    protected Level level;
    protected final BlockPos worldPosition;
    protected boolean remove;
    private BlockState blockState;
    private DataComponentMap components = DataComponentMap.EMPTY;
    @Nullable
    private CompoundTag customPersistentData;

    public BlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        this.type = p_155228_;
        this.worldPosition = p_155229_.immutable();
        this.validateBlockState(p_155230_);
        this.blockState = p_155230_;
    }

    private void validateBlockState(BlockState p_353132_) {
        if (!this.isValidBlockState(p_353132_)) {
            throw new IllegalStateException("Invalid block entity " + this.getNameForReporting() + " state at " + String.valueOf(this.worldPosition) + ", got " + String.valueOf((Object)p_353132_));
        }
    }

    public boolean isValidBlockState(BlockState p_353131_) {
        return this.getType().isValid(p_353131_);
    }

    public static BlockPos getPosFromTag(ChunkPos p_412201_, CompoundTag p_187473_) {
        int i = p_187473_.getIntOr("x", 0);
        int j = p_187473_.getIntOr("y", 0);
        int k = p_187473_.getIntOr("z", 0);
        int l = SectionPos.blockToSectionCoord((int)i);
        int i1 = SectionPos.blockToSectionCoord((int)k);
        if (l != p_412201_.x || i1 != p_412201_.z) {
            LOGGER.warn("Block entity {} found in a wrong chunk, expected position from chunk {}", (Object)p_187473_, (Object)p_412201_);
            i = p_412201_.getBlockX(SectionPos.sectionRelative((int)i));
            k = p_412201_.getBlockZ(SectionPos.sectionRelative((int)k));
        }
        return new BlockPos(i, j, k);
    }

    @Nullable
    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level p_155231_) {
        this.level = p_155231_;
    }

    public boolean hasLevel() {
        return this.level != null;
    }

    protected void loadAdditional(CompoundTag p_338466_, HolderLookup.Provider p_338445_) {
        p_338466_.getCompound("NeoForgeData").ifPresent(neoData -> {
            this.customPersistentData = neoData;
        });
        p_338466_.getCompound("neoforge:attachments").ifPresent(attachments -> this.deserializeAttachments(p_338445_, (CompoundTag)attachments));
    }

    public final void loadWithComponents(CompoundTag p_338356_, HolderLookup.Provider p_338558_) {
        this.loadAdditional(p_338356_, p_338558_);
        this.components = p_338356_.read(ComponentHelper.COMPONENTS_CODEC, (DynamicOps<Tag>)p_338558_.createSerializationContext(NbtOps.INSTANCE)).orElse(DataComponentMap.EMPTY);
    }

    public final void loadCustomOnly(CompoundTag p_338387_, HolderLookup.Provider p_338713_) {
        this.loadAdditional(p_338387_, p_338713_);
    }

    protected void saveAdditional(CompoundTag p_187471_, HolderLookup.Provider p_323635_) {
        CompoundTag attachmentsTag;
        if (this.customPersistentData != null) {
            p_187471_.put("NeoForgeData", this.customPersistentData.copy());
        }
        if ((attachmentsTag = this.serializeAttachments(p_323635_)) != null) {
            p_187471_.put("neoforge:attachments", attachmentsTag);
        }
    }

    public final CompoundTag saveWithFullMetadata(HolderLookup.Provider p_323767_) {
        CompoundTag compoundtag = this.saveWithoutMetadata(p_323767_);
        this.saveMetadata(compoundtag);
        return compoundtag;
    }

    public final CompoundTag saveWithId(HolderLookup.Provider p_324357_) {
        CompoundTag compoundtag = this.saveWithoutMetadata(p_324357_);
        this.saveId(compoundtag);
        return compoundtag;
    }

    public final CompoundTag saveWithoutMetadata(HolderLookup.Provider p_324030_) {
        CompoundTag compoundtag = new CompoundTag();
        this.saveAdditional(compoundtag, p_324030_);
        compoundtag.store(ComponentHelper.COMPONENTS_CODEC, (DynamicOps<Tag>)p_324030_.createSerializationContext(NbtOps.INSTANCE), this.components);
        return compoundtag;
    }

    public final CompoundTag saveCustomOnly(HolderLookup.Provider p_338656_) {
        CompoundTag compoundtag = new CompoundTag();
        this.saveAdditional(compoundtag, p_338656_);
        return compoundtag;
    }

    public final CompoundTag saveCustomAndMetadata(HolderLookup.Provider p_339688_) {
        CompoundTag compoundtag = this.saveCustomOnly(p_339688_);
        this.saveMetadata(compoundtag);
        return compoundtag;
    }

    private void saveId(CompoundTag p_187475_) {
        BlockEntity.addEntityType(p_187475_, this.getType());
    }

    public static void addEntityType(CompoundTag p_187469_, BlockEntityType<?> p_187470_) {
        p_187469_.store("id", TYPE_CODEC, p_187470_);
    }

    private void saveMetadata(CompoundTag p_187479_) {
        this.saveId(p_187479_);
        p_187479_.putInt("x", this.worldPosition.getX());
        p_187479_.putInt("y", this.worldPosition.getY());
        p_187479_.putInt("z", this.worldPosition.getZ());
    }

    @Nullable
    public static BlockEntity loadStatic(BlockPos p_155242_, BlockState p_155243_, CompoundTag p_155244_, HolderLookup.Provider p_323542_) {
        Object blockentity;
        BlockEntityType blockentitytype = p_155244_.read("id", TYPE_CODEC).orElse(null);
        if (blockentitytype == null) {
            LOGGER.error("Skipping block entity with invalid type: {}", (Object)p_155244_.get("id"));
            return null;
        }
        try {
            blockentity = blockentitytype.create(p_155242_, p_155243_);
        }
        catch (Throwable throwable1) {
            LOGGER.error("Failed to create block entity {} for block {} at position {} ", new Object[]{blockentitytype, p_155242_, p_155243_, throwable1});
            return null;
        }
        try {
            ((BlockEntity)((Object)blockentity)).loadWithComponents(p_155244_, p_323542_);
            return blockentity;
        }
        catch (Throwable throwable) {
            LOGGER.error("Failed to load data for block entity {} for block {} at position {}", new Object[]{blockentitytype, p_155242_, p_155243_, throwable});
            return null;
        }
    }

    public void setChanged() {
        if (this.level != null) {
            BlockEntity.setChanged(this.level, this.worldPosition, this.blockState);
        }
    }

    protected static void setChanged(Level p_155233_, BlockPos p_155234_, BlockState p_155235_) {
        p_155233_.blockEntityChanged(p_155234_);
        if (!p_155235_.isAir()) {
            p_155233_.updateNeighbourForOutputSignal(p_155234_, p_155235_.getBlock());
        }
    }

    public BlockPos getBlockPos() {
        return this.worldPosition;
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return null;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider p_323910_) {
        return new CompoundTag();
    }

    public boolean isRemoved() {
        return this.remove;
    }

    public void setRemoved() {
        this.remove = true;
        this.invalidateCapabilities();
        this.requestModelDataUpdate();
    }

    public void clearRemoved() {
        this.remove = false;
        this.invalidateCapabilities();
    }

    public void preRemoveSideEffects(BlockPos p_394577_, BlockState p_394161_) {
        BlockEntity blockEntity = this;
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            if (this.level != null) {
                Containers.dropContents((Level)this.level, (BlockPos)p_394577_, (Container)container);
            }
        }
    }

    public boolean triggerEvent(int p_58889_, int p_58890_) {
        return false;
    }

    public void fillCrashReportCategory(CrashReportCategory p_58887_) {
        p_58887_.setDetail("Name", (CrashReportDetail<String>)((CrashReportDetail)this::getNameForReporting));
        p_58887_.setDetail("Cached block", (CrashReportDetail<String>)((CrashReportDetail)() -> ((BlockState)this.getBlockState()).toString()));
        if (this.level == null) {
            p_58887_.setDetail("Block location", (CrashReportDetail<String>)((CrashReportDetail)() -> String.valueOf(this.worldPosition) + " (world missing)"));
        } else {
            p_58887_.setDetail("Actual block", (CrashReportDetail<String>)((CrashReportDetail)() -> ((BlockState)this.level.getBlockState(this.worldPosition)).toString()));
            CrashReportCategory.populateBlockLocationDetails(p_58887_, (LevelHeightAccessor)this.level, this.worldPosition);
        }
    }

    private String getNameForReporting() {
        return String.valueOf(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(this.getType())) + " // " + ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public BlockEntityType<?> getType() {
        return this.type;
    }

    public CompoundTag getPersistentData() {
        if (this.customPersistentData == null) {
            this.customPersistentData = new CompoundTag();
        }
        return this.customPersistentData;
    }

    @Nullable
    public final <T> T setData(AttachmentType<T> type, T data) {
        this.setChanged();
        return (T)super.setData(type, data);
    }

    @Nullable
    public final <T> T removeData(AttachmentType<T> type) {
        this.setChanged();
        return (T)super.removeData(type);
    }

    @Deprecated
    public void setBlockState(BlockState p_155251_) {
        this.validateBlockState(p_155251_);
        this.blockState = p_155251_;
    }

    protected void applyImplicitComponents(DataComponentGetter p_397929_) {
    }

    public final void applyComponentsFromItemStack(ItemStack p_338428_) {
        this.applyComponents(p_338428_.getPrototype(), p_338428_.getComponentsPatch());
    }

    public final void applyComponents(DataComponentMap p_330364_, DataComponentPatch p_338381_) {
        final HashSet<DataComponentType> set = new HashSet<DataComponentType>();
        set.add(DataComponents.BLOCK_ENTITY_DATA);
        set.add(DataComponents.BLOCK_STATE);
        final PatchedDataComponentMap datacomponentmap = PatchedDataComponentMap.fromPatch(p_330364_, p_338381_);
        this.applyImplicitComponents(new DataComponentGetter(){

            @Override
            @Nullable
            public <T> T get(DataComponentType<? extends T> p_338266_) {
                set.add(p_338266_);
                return datacomponentmap.get(p_338266_);
            }

            @Override
            public <T> T getOrDefault(DataComponentType<? extends T> p_338358_, T p_338352_) {
                set.add(p_338358_);
                return datacomponentmap.getOrDefault(p_338358_, p_338352_);
            }
        });
        DataComponentPatch datacomponentpatch = p_338381_.forget(set::contains);
        this.components = datacomponentpatch.split().added();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder p_338210_) {
    }

    @Deprecated
    public void removeComponentsFromTag(CompoundTag p_332032_) {
    }

    public final DataComponentMap collectComponents() {
        DataComponentMap.Builder datacomponentmap$builder = DataComponentMap.builder();
        datacomponentmap$builder.addAll(this.components);
        this.collectImplicitComponents(datacomponentmap$builder);
        return datacomponentmap$builder.build();
    }

    public DataComponentMap components() {
        return this.components;
    }

    public void setComponents(DataComponentMap p_338529_) {
        this.components = p_338529_;
    }

    @Nullable
    public static Component parseCustomNameSafe(@Nullable Tag p_394142_, HolderLookup.Provider p_342030_) {
        return p_394142_ == null ? null : (Component)ComponentSerialization.CODEC.parse(p_342030_.createSerializationContext(NbtOps.INSTANCE), (Object)p_394142_).resultOrPartial(p_337987_ -> LOGGER.warn("Failed to parse custom name, discarding: {}", p_337987_)).orElse(null);
    }

    static class ComponentHelper {
        public static final MapCodec<DataComponentMap> COMPONENTS_CODEC = DataComponentMap.CODEC.optionalFieldOf("components", (Object)DataComponentMap.EMPTY);

        private ComponentHelper() {
        }
    }
}

