/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.neoforged.neoforge.common.LenientUnboundedMapCodec;

public record WorldDimensions(Map<ResourceKey<LevelStem>, LevelStem> dimensions) {
    public static final MapCodec<WorldDimensions> CODEC = RecordCodecBuilder.mapCodec(p_325905_ -> p_325905_.group((App)new LenientUnboundedMapCodec(ResourceKey.codec(Registries.LEVEL_STEM), LevelStem.CODEC).fieldOf("dimensions").forGetter(WorldDimensions::dimensions)).apply((Applicative)p_325905_, p_325905_.stable(WorldDimensions::new)));
    private static final Set<ResourceKey<LevelStem>> BUILTIN_ORDER = ImmutableSet.of((Object)LevelStem.OVERWORLD, (Object)LevelStem.NETHER, (Object)LevelStem.END);
    private static final int VANILLA_DIMENSION_COUNT = BUILTIN_ORDER.size();

    public WorldDimensions {
        LevelStem levelstem = dimensions.get(LevelStem.OVERWORLD);
        if (levelstem == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
    }

    public WorldDimensions(Registry<LevelStem> p_251356_) {
        this(p_251356_.listElements().collect(Collectors.toMap(Holder.Reference::key, Holder.Reference::value)));
    }

    public static Stream<ResourceKey<LevelStem>> keysInOrder(Stream<ResourceKey<LevelStem>> p_251309_) {
        return Stream.concat(BUILTIN_ORDER.stream(), p_251309_.filter(p_251885_ -> !BUILTIN_ORDER.contains(p_251885_)));
    }

    public WorldDimensions replaceOverworldGenerator(HolderLookup.Provider p_364954_, ChunkGenerator p_248755_) {
        HolderGetter holderlookup = p_364954_.lookupOrThrow(Registries.DIMENSION_TYPE);
        Map<ResourceKey<LevelStem>, LevelStem> map = WorldDimensions.withOverworld((HolderLookup<DimensionType>)holderlookup, this.dimensions, p_248755_);
        return new WorldDimensions(map);
    }

    public static Map<ResourceKey<LevelStem>, LevelStem> withOverworld(HolderLookup<DimensionType> p_362725_, Map<ResourceKey<LevelStem>, LevelStem> p_326250_, ChunkGenerator p_250220_) {
        LevelStem levelstem = p_326250_.get(LevelStem.OVERWORLD);
        Holder holder = levelstem == null ? p_362725_.getOrThrow(BuiltinDimensionTypes.OVERWORLD) : levelstem.type();
        return WorldDimensions.withOverworld(p_326250_, holder, p_250220_);
    }

    public static Map<ResourceKey<LevelStem>, LevelStem> withOverworld(Map<ResourceKey<LevelStem>, LevelStem> p_326287_, Holder<DimensionType> p_326403_, ChunkGenerator p_251737_) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(p_326287_);
        builder.put((Object)LevelStem.OVERWORLD, (Object)new LevelStem(p_326403_, p_251737_));
        return builder.buildKeepingLast();
    }

    public ChunkGenerator overworld() {
        LevelStem levelstem = this.dimensions.get(LevelStem.OVERWORLD);
        if (levelstem == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
        return levelstem.generator();
    }

    public Optional<LevelStem> get(ResourceKey<LevelStem> p_250824_) {
        return Optional.ofNullable(this.dimensions.get(p_250824_));
    }

    public ImmutableSet<ResourceKey<Level>> levels() {
        return (ImmutableSet)this.dimensions().keySet().stream().map(Registries::levelStemToLevel).collect(ImmutableSet.toImmutableSet());
    }

    public boolean isDebug() {
        return this.overworld() instanceof DebugLevelSource;
    }

    private static PrimaryLevelData.SpecialWorldProperty specialWorldProperty(Registry<LevelStem> p_251549_) {
        return p_251549_.getOptional(LevelStem.OVERWORLD).map(p_251481_ -> {
            ChunkGenerator chunkgenerator = p_251481_.generator();
            if (chunkgenerator instanceof DebugLevelSource) {
                return PrimaryLevelData.SpecialWorldProperty.DEBUG;
            }
            return chunkgenerator instanceof FlatLevelSource ? PrimaryLevelData.SpecialWorldProperty.FLAT : PrimaryLevelData.SpecialWorldProperty.NONE;
        }).orElse(PrimaryLevelData.SpecialWorldProperty.NONE);
    }

    static Lifecycle checkStability(ResourceKey<LevelStem> p_250764_, LevelStem p_248865_) {
        return WorldDimensions.isVanillaLike(p_250764_, p_248865_) ? Lifecycle.stable() : Lifecycle.experimental();
    }

    private static boolean isVanillaLike(ResourceKey<LevelStem> p_250556_, LevelStem p_250034_) {
        if (p_250556_ == LevelStem.OVERWORLD) {
            return WorldDimensions.isStableOverworld(p_250034_);
        }
        if (p_250556_ == LevelStem.NETHER) {
            return WorldDimensions.isStableNether(p_250034_);
        }
        return p_250556_ == LevelStem.END ? WorldDimensions.isStableEnd(p_250034_) : false;
    }

    private static boolean isStableOverworld(LevelStem p_250762_) {
        MultiNoiseBiomeSource multinoisebiomesource;
        BiomeSource biomeSource;
        Holder holder = p_250762_.type();
        return !holder.is(BuiltinDimensionTypes.OVERWORLD) && !holder.is(BuiltinDimensionTypes.OVERWORLD_CAVES) ? false : !((biomeSource = p_250762_.generator().getBiomeSource()) instanceof MultiNoiseBiomeSource) || (multinoisebiomesource = (MultiNoiseBiomeSource)biomeSource).stable(MultiNoiseBiomeSourceParameterLists.OVERWORLD);
    }

    private static boolean isStableNether(LevelStem p_250497_) {
        MultiNoiseBiomeSource multinoisebiomesource;
        NoiseBasedChunkGenerator noisebasedchunkgenerator;
        ChunkGenerator chunkGenerator;
        return p_250497_.type().is(BuiltinDimensionTypes.NETHER) && (chunkGenerator = p_250497_.generator()) instanceof NoiseBasedChunkGenerator && (noisebasedchunkgenerator = (NoiseBasedChunkGenerator)chunkGenerator).stable(NoiseGeneratorSettings.NETHER) && (chunkGenerator = noisebasedchunkgenerator.getBiomeSource()) instanceof MultiNoiseBiomeSource && (multinoisebiomesource = (MultiNoiseBiomeSource)chunkGenerator).stable(MultiNoiseBiomeSourceParameterLists.NETHER);
    }

    private static boolean isStableEnd(LevelStem p_250720_) {
        NoiseBasedChunkGenerator noisebasedchunkgenerator;
        ChunkGenerator chunkGenerator;
        return p_250720_.type().is(BuiltinDimensionTypes.END) && (chunkGenerator = p_250720_.generator()) instanceof NoiseBasedChunkGenerator && (noisebasedchunkgenerator = (NoiseBasedChunkGenerator)chunkGenerator).stable(NoiseGeneratorSettings.END) && noisebasedchunkgenerator.getBiomeSource() instanceof TheEndBiomeSource;
    }

    public Complete bake(Registry<LevelStem> p_248787_) {
        record Entry(ResourceKey<LevelStem> key, LevelStem value) {
            RegistrationInfo registrationInfo() {
                return new RegistrationInfo(Optional.empty(), WorldDimensions.checkStability(this.key, this.value));
            }
        }
        Stream<ResourceKey<LevelStem>> stream = Stream.concat(p_248787_.registryKeySet().stream(), this.dimensions.keySet().stream()).distinct();
        ArrayList list = new ArrayList();
        WorldDimensions.keysInOrder(stream).forEach(p_248571_ -> p_248787_.getOptional((ResourceKey<LevelStem>)p_248571_).or(() -> Optional.ofNullable(this.dimensions.get(p_248571_))).ifPresent(p_250263_ -> list.add(new Entry((ResourceKey<LevelStem>)p_248571_, (LevelStem)p_250263_))));
        Lifecycle lifecycle = list.size() == VANILLA_DIMENSION_COUNT ? Lifecycle.stable() : Lifecycle.experimental();
        MappedRegistry<LevelStem> writableregistry = new MappedRegistry<LevelStem>(Registries.LEVEL_STEM, lifecycle);
        list.forEach(p_325908_ -> writableregistry.register(p_325908_.key, p_325908_.value, p_325908_.registrationInfo()));
        Registry registry = writableregistry.freeze();
        PrimaryLevelData.SpecialWorldProperty primaryleveldata$specialworldproperty = WorldDimensions.specialWorldProperty(registry);
        return new Complete(registry.freeze(), primaryleveldata$specialworldproperty);
    }

    public record Complete(Registry<LevelStem> dimensions, PrimaryLevelData.SpecialWorldProperty specialWorldProperty) {
        public Lifecycle lifecycle() {
            return this.dimensions.registryLifecycle();
        }

        public RegistryAccess.Frozen dimensionsRegistryAccess() {
            return new RegistryAccess.ImmutableRegistryAccess(List.of(this.dimensions)).freeze();
        }
    }
}

