/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.InMemoryFormat;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.ParsingMode;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.electronwill.nightconfig.toml.TomlParser;
import com.electronwill.nightconfig.toml.TomlWriter;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LogMarkers;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;
import org.slf4j.Logger;

public class FMLConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FMLConfig INSTANCE = new FMLConfig();
    private static Map<String, List<DependencyOverride>> dependencyOverrides = Map.of();
    private static final ConfigSpec configSpec = new ConfigSpec(InMemoryFormat.withUniversalSupport().createConfig(LinkedHashMap::new));
    private static final CommentedConfig configComments = CommentedConfig.inMemory();
    private CommentedConfig configData;

    private static Object maxThreads(Object value) {
        int val = (Integer)value;
        if (val <= 0) {
            return Runtime.getRuntime().availableProcessors();
        }
        return val;
    }

    private void loadFrom(Path configFile) {
        this.configData = CommentedConfig.of(LinkedHashMap::new, (ConfigFormat)TomlFormat.instance());
        if (Files.exists(configFile, new LinkOption[0])) {
            try (InputStream configStream = Files.newInputStream(configFile, new OpenOption[0]);){
                new TomlParser().parse(configStream, (Config)this.configData, ParsingMode.REPLACE);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read FML config", e);
            }
            if (!configSpec.isCorrect((Config)this.configData)) {
                LOGGER.warn(LogMarkers.CORE, "Configuration file {} is not correct. Correcting", (Object)configFile);
                configSpec.correct((Config)this.configData, (action, path, incorrectValue, correctedValue) -> LOGGER.warn(LogMarkers.CORE, "Incorrect key {} was corrected from {} to {}", new Object[]{path, incorrectValue, correctedValue}));
            }
        } else {
            configSpec.correct((Config)this.configData);
            this.configData.set("dependencyOverrides", (Object)this.configData.createSubConfig());
        }
        this.configData.putAllComments((UnmodifiableCommentedConfig)configComments);
        this.saveConfig(configFile);
    }

    private void saveConfig(Path configFile) {
        new TomlWriter().write((UnmodifiableConfig)this.configData, configFile, WritingMode.REPLACE);
    }

    public static void load() {
        Path configFile = FMLPaths.FMLCONFIG.get();
        INSTANCE.loadFrom(configFile);
        if (LOGGER.isTraceEnabled(LogMarkers.CORE)) {
            LOGGER.trace(LogMarkers.CORE, "Loaded FML config from {}", (Object)FMLPaths.FMLCONFIG.get());
            for (ConfigValue cv : ConfigValue.values()) {
                LOGGER.trace(LogMarkers.CORE, "FMLConfig {} is {}", (Object)cv.entry, cv.getConfigValue(FMLConfig.INSTANCE.configData));
            }
        }
        FMLPaths.getOrCreateGameRelativePath(Paths.get(FMLConfig.getConfigValue(ConfigValue.DEFAULT_CONFIG_PATH), new String[0]));
        HashMap<String, List> dependencyOverrides = new HashMap<String, List>();
        Object overridesObject = FMLConfig.INSTANCE.configData.get("dependencyOverrides");
        if (overridesObject != null) {
            if (!(overridesObject instanceof Config)) {
                LOGGER.error("Invalid dependency overrides declaration in config. Expected object but found {}", overridesObject);
                return;
            }
            Config cfg = (Config)overridesObject;
            cfg.valueMap().forEach((modId, object) -> {
                List ls;
                List asList = object instanceof List ? (ls = (List)object) : List.of(object);
                List overrides = dependencyOverrides.computeIfAbsent((String)modId, k -> new ArrayList());
                for (Object o : asList) {
                    String str = (String)o;
                    char start = str.charAt(0);
                    if (start != '+' && start != '-') {
                        LOGGER.error("Found invalid dependency override for mod '{}'. Expected +/- in override '{}'. Did you forget to specify the override type?", modId, (Object)str);
                        continue;
                    }
                    boolean removal = start == '-';
                    String depMod = str.substring(1);
                    overrides.add(new DependencyOverride(depMod, removal));
                }
            });
        }
        if (!dependencyOverrides.isEmpty()) {
            LOGGER.warn("*".repeat(30) + " Found dependency overrides " + "*".repeat(30));
            dependencyOverrides.forEach((modId, ov) -> LOGGER.warn("Dependency overrides for mod '{}': {}", modId, (Object)ov.stream().map(DependencyOverride::getMessage).collect(Collectors.joining(", "))));
            LOGGER.warn("*".repeat(88));
        }
        dependencyOverrides.replaceAll((id, list) -> List.copyOf(list));
        FMLConfig.dependencyOverrides = Collections.unmodifiableMap(dependencyOverrides);
    }

    public static String getConfigValue(ConfigValue v) {
        return (String)v.getConfigValue(FMLConfig.INSTANCE.configData);
    }

    public static boolean getBoolConfigValue(ConfigValue v) {
        return (Boolean)v.getConfigValue(FMLConfig.INSTANCE.configData);
    }

    public static int getIntConfigValue(ConfigValue v) {
        return (Integer)v.getConfigValue(FMLConfig.INSTANCE.configData);
    }

    public static <A> List<A> getListConfigValue(ConfigValue v) {
        return (List)v.getConfigValue(FMLConfig.INSTANCE.configData);
    }

    public static <T> void updateConfig(ConfigValue v, T value) {
        if (FMLConfig.INSTANCE.configData != null) {
            v.setConfigValue(FMLConfig.INSTANCE.configData, value);
            INSTANCE.saveConfig(FMLPaths.FMLCONFIG.get());
        }
    }

    public static String defaultConfigPath() {
        return FMLConfig.getConfigValue(ConfigValue.DEFAULT_CONFIG_PATH);
    }

    public static @Unmodifiable List<DependencyOverride> getOverrides(String modId) {
        List<DependencyOverride> ov = dependencyOverrides.get(modId);
        if (ov == null) {
            return List.of();
        }
        return ov;
    }

    public static @UnmodifiableView Map<String, List<DependencyOverride>> getDependencyOverrides() {
        return Collections.unmodifiableMap(dependencyOverrides);
    }

    static {
        for (ConfigValue cv : ConfigValue.values()) {
            cv.buildConfigEntry(configSpec, configComments);
        }
        configSpec.define("dependencyOverrides", () -> null, object -> true);
        configComments.set("dependencyOverrides", (Object)configComments.createSubConfig());
        configComments.setComment("dependencyOverrides", "Define dependency overrides below\nDependency overrides can be used to forcibly remove a dependency constraint from a mod or to force a mod to load AFTER another mod\nUsing dependency overrides can cause issues. Use at your own risk.\nExample dependency override for the mod with the id 'targetMod': dependency constraints (incompatibility clauses or restrictive version ranges) against mod 'dep1' are removed, and the mod will now load after the mod 'dep2'\ndependencyOverrides.targetMod = [\"-dep1\", \"+dep2\"]");
    }

    public static enum ConfigValue {
        DISABLE_CONFIG_WATCHER("disableConfigWatcher", Boolean.FALSE, "Disables File Watcher. Used to automatically update config if its file has been modified."),
        EARLY_WINDOW_CONTROL("earlyWindowControl", Boolean.TRUE, "Shows an early loading screen for mod loading which improves the user experience with early feedback about mod loading."),
        MAX_THREADS("maxThreads", -1, "Max threads for early initialization parallelism,  -1 is based on processor count", FMLConfig::maxThreads),
        VERSION_CHECK("versionCheck", Boolean.TRUE, "Enable NeoForge global version checking"),
        DEBUG_OPENGL("debugOpenGl", Boolean.FALSE, "Enable synchronous OpenGL debug output and object labeling"),
        DEFAULT_CONFIG_PATH("defaultConfigPath", "defaultconfigs", "Default config path for servers"),
        DISABLE_OPTIMIZED_DFU("disableOptimizedDFU", Boolean.TRUE, "Disables Optimized DFU client-side - already disabled on servers"),
        EARLY_WINDOW_PROVIDER("earlyWindowProvider", "fmlearlywindow", "Early window provider"),
        EARLY_WINDOW_WIDTH("earlyWindowWidth", 854, "Early window width"),
        EARLY_WINDOW_HEIGHT("earlyWindowHeight", 480, "Early window height"),
        EARLY_WINDOW_FBSCALE("earlyWindowFBScale", 1, "Early window framebuffer scale"),
        EARLY_WINDOW_MAXIMIZED("earlyWindowMaximized", Boolean.FALSE, "Early window starts maximized"),
        EARLY_WINDOW_SQUIR("earlyWindowSquir", Boolean.FALSE, "Squir?");

        private final String entry;
        private final Object defaultValue;
        private final String comment;
        private final Class<?> valueType;
        private final Function<Object, Object> entryFunction;

        private ConfigValue(String entry, Object defaultValue, String comment) {
            this(entry, defaultValue, comment, Function.identity());
        }

        private ConfigValue(String entry, Object defaultValue, String comment, Function<Object, Object> entryFunction) {
            this.entry = entry;
            this.defaultValue = defaultValue;
            this.comment = comment;
            this.valueType = defaultValue.getClass();
            this.entryFunction = entryFunction;
        }

        void buildConfigEntry(ConfigSpec spec, CommentedConfig commentedConfig) {
            Object object = this.defaultValue;
            if (object instanceof List) {
                List list = (List)object;
                spec.defineList(this.entry, list, e -> e instanceof String);
            } else {
                spec.define(this.entry, this.defaultValue);
            }
            commentedConfig.add(this.entry, this.defaultValue);
            commentedConfig.setComment(this.entry, this.comment);
        }

        private <T> T getConfigValue(CommentedConfig config) {
            return (T)this.entryFunction.apply(config != null ? config.get(this.entry) : this.defaultValue);
        }

        private <T> void setConfigValue(CommentedConfig configData, T value) {
            configData.set(this.entry, value);
        }
    }

    public record DependencyOverride(String modId, boolean remove) {
        public String getMessage() {
            return (this.remove ? "softening dependency constraints against" : "adding explicit AFTER ordering against") + " '" + this.modId + "'";
        }
    }
}

