/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.targets;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.ServiceRunner;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.module.ModuleReader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.VersionInfo;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;

public abstract class CommonLaunchHandler
implements ILaunchHandlerService {
    protected static final Logger LOGGER = LogUtils.getLogger();

    public abstract Dist getDist();

    public abstract boolean isProduction();

    public void collectAdditionalModFileLocators(VersionInfo versionInfo, Consumer<IModFileCandidateLocator> output) {
    }

    protected String[] preLaunch(String[] arguments, ModuleLayer layer) {
        if (this.isProduction() || System.getProperty("log4j2.configurationFile") == null) {
            this.overwriteLoggingConfiguration(layer);
        }
        return arguments;
    }

    private void overwriteLoggingConfiguration(ModuleLayer layer) {
        URI uri;
        try (ModuleReader reader = layer.configuration().findModule("fml_loader").orElseThrow().reference().open();){
            uri = reader.find("log4j2.xml").orElseThrow();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Configurator.reconfigure((Configuration)ConfigurationFactory.getInstance().getConfiguration(LoggerContext.getContext(), ConfigurationSource.fromUri((URI)uri)));
    }

    public static Map<String, List<Path>> getGroupedModFolders() {
        Map<String, List<Path>> result;
        String modFolders = Optional.ofNullable(System.getenv("MOD_CLASSES")).orElse(System.getProperty("fml.modFolders", ""));
        String modFoldersFile = System.getProperty("fml.modFoldersFile", "");
        if (!modFoldersFile.isEmpty()) {
            LOGGER.debug(LogMarkers.CORE, "Reading additional mod folders from file {}", (Object)modFoldersFile);
            Properties p = new Properties();
            try (BufferedReader in = Files.newBufferedReader(Paths.get(modFoldersFile, new String[0]));){
                p.load(in);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read mod classes list from " + modFoldersFile, e);
            }
            result = p.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), modId -> Arrays.stream(p.getProperty((String)modId).split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).toList()));
        } else if (!modFolders.isEmpty()) {
            LOGGER.debug(LogMarkers.CORE, "Got mod coordinates {} from env", (Object)modFolders);
            record ExplodedModPath(String modId, Path path) {
            }
            result = Arrays.stream(modFolders.split(File.pathSeparator)).map(inp -> inp.split("%%", 2)).map(splitString -> new ExplodedModPath(((String[])splitString).length == 1 ? "defaultmodid" : splitString[0], Paths.get(splitString[((String[])splitString).length - 1], new String[0]))).collect(Collectors.groupingBy(ExplodedModPath::modId, Collectors.mapping(ExplodedModPath::path, Collectors.toList())));
        } else {
            result = Map.of();
        }
        LOGGER.debug(LogMarkers.CORE, "Found supplied mod coordinates [{}]", result);
        return result;
    }

    public ServiceRunner launchService(String[] arguments, ModuleLayer gameLayer) {
        FMLLoader.beforeStart(gameLayer);
        String[] args = this.preLaunch(arguments, gameLayer);
        return () -> this.runService(args, gameLayer);
    }

    protected abstract void runService(String[] var1, ModuleLayer var2) throws Throwable;

    protected void clientService(String[] arguments, ModuleLayer layer) throws Throwable {
        this.runTarget("net.minecraft.client.main.Main", arguments, layer);
    }

    protected void serverService(String[] arguments, ModuleLayer layer) throws Throwable {
        this.runTarget("net.minecraft.server.Main", arguments, layer);
    }

    protected void runTarget(String target, String[] arguments, ModuleLayer layer) throws Throwable {
        Class.forName(layer.findModule("minecraft").orElseThrow(), target).getMethod("main", String[].class).invoke(null, new Object[]{arguments});
    }
}

