/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.targets;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.targets.ArgumentList;
import net.neoforged.fml.loading.targets.NeoForgeDevLaunchHandler;

public class NeoForgeClientDevLaunchHandler
extends NeoForgeDevLaunchHandler {
    public String name() {
        return "neoforgeclientdev";
    }

    @Override
    public Dist getDist() {
        return Dist.CLIENT;
    }

    @Override
    protected String[] preLaunch(String[] arguments, ModuleLayer layer) {
        ArgumentList args = ArgumentList.from(arguments);
        String username = args.get("username");
        if (username != null) {
            Matcher m = Pattern.compile("#+").matcher(username);
            StringBuilder replaced = new StringBuilder();
            while (m.find()) {
                m.appendReplacement(replaced, NeoForgeClientDevLaunchHandler.getRandomNumbers(m.group().length()));
            }
            m.appendTail(replaced);
            args.put("username", replaced.toString());
        } else {
            args.putLazy("username", "Dev");
        }
        if (!args.hasValue("accessToken")) {
            args.put("accessToken", "0");
        }
        return super.preLaunch(args.getArguments(), layer);
    }

    @Override
    public void runService(String[] arguments, ModuleLayer layer) throws Throwable {
        this.clientService(arguments, layer);
    }

    private static String getRandomNumbers(int length) {
        return Long.toString(System.nanoTime() % (long)((int)Math.pow(10.0, length)));
    }
}

