/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.TimingData;
import co.aikar.timings.TimingHandler;
import co.aikar.timings.TimingHistoryEntry;
import co.aikar.timings.TimingsManager;
import co.aikar.util.JSONUtil;
import co.aikar.util.LoadingMap;
import co.aikar.util.MRUMapCache;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.SpongeEntityType;

public class TimingHistory {
    public static long lastMinuteTime;
    public static long timedTicks;
    public static long playerTicks;
    public static long entityTicks;
    public static long tileEntityTicks;
    public static long activatedEntityTicks;
    static int worldIdPool;
    static Map<String, Integer> worldMap;
    final long endTime;
    final long startTime;
    final long totalTicks;
    final long totalTime;
    final MinuteReport[] minuteReports;
    final TimingHistoryEntry[] entries;
    final Set<BlockType> blockTypeSet = Sets.newHashSet();
    final Set<EntityType> entityTypeSet = Sets.newHashSet();
    final JsonObject worlds;

    TimingHistory() {
        this.endTime = System.currentTimeMillis() / 1000L;
        this.startTime = TimingsManager.historyStart / 1000L;
        if (timedTicks % 1200L != 0L || TimingsManager.MINUTE_REPORTS.isEmpty()) {
            this.minuteReports = TimingsManager.MINUTE_REPORTS.toArray(new MinuteReport[TimingsManager.MINUTE_REPORTS.size() + 1]);
            this.minuteReports[this.minuteReports.length - 1] = new MinuteReport();
        } else {
            this.minuteReports = TimingsManager.MINUTE_REPORTS.toArray(new MinuteReport[TimingsManager.MINUTE_REPORTS.size()]);
        }
        long ticks = 0L;
        for (MinuteReport mp : this.minuteReports) {
            ticks += mp.ticksRecord.timed;
        }
        this.totalTicks = ticks;
        this.totalTime = TimingsManager.FULL_SERVER_TICK.record.totalTime;
        this.entries = new TimingHistoryEntry[TimingsManager.HANDLERS.size()];
        int i = 0;
        for (TimingHandler handler : TimingsManager.HANDLERS) {
            this.entries[i++] = new TimingHistoryEntry(handler);
        }
        Map entityCounts = MRUMapCache.of(LoadingMap.of(Maps.newHashMap(), Counter.loader()));
        Map tileEntityCounts = MRUMapCache.of(LoadingMap.of(Maps.newHashMap(), Counter.loader()));
        this.worlds = JSONUtil.mapArrayToObject(SpongeImpl.getGame().getServer().getWorlds(), world -> JSONUtil.singleObjectPair(String.valueOf(worldMap.get(world.getName())), (Object)JSONUtil.mapArray(world.getLoadedChunks(), chunk -> {
            entityCounts.clear();
            tileEntityCounts.clear();
            for (Entity entity : chunk.getEntities()) {
                if (entity.getType() == null) {
                    SpongeImpl.getLogger().error("Entity is not registered {}", new Object[]{entity});
                    continue;
                }
                ((Counter)entityCounts.get(entity.getType())).increment();
            }
            for (TileEntity tileEntity : chunk.getTileEntities()) {
                ((Counter)tileEntityCounts.get(tileEntity.getBlock().getType())).increment();
            }
            if (tileEntityCounts.isEmpty() && entityCounts.isEmpty()) {
                return null;
            }
            return JSONUtil.arrayOf(chunk.getPosition().getX(), chunk.getPosition().getZ(), JSONUtil.mapArrayToObject(entityCounts.entrySet(), entry -> {
                if (entry.getKey() == EntityTypes.UNKNOWN) {
                    return null;
                }
                this.entityTypeSet.add((EntityType)entry.getKey());
                return JSONUtil.singleObjectPair(((SpongeEntityType)entry.getKey()).entityTypeId, (Object)((Counter)entry.getValue()).count());
            }), JSONUtil.mapArrayToObject(tileEntityCounts.entrySet(), entry -> {
                this.blockTypeSet.add((BlockType)entry.getKey());
                return JSONUtil.singleObjectPair(Block.func_149682_b((Block)((Block)entry.getKey())), (Object)((Counter)entry.getValue()).count());
            }));
        })));
    }

    public static void resetTicks(boolean fullReset) {
        if (fullReset) {
            timedTicks = 0L;
        }
        lastMinuteTime = System.nanoTime();
        playerTicks = 0L;
        tileEntityTicks = 0L;
        entityTicks = 0L;
        activatedEntityTicks = 0L;
    }

    JsonObject export() {
        return JSONUtil.objectBuilder().add("s", (Object)this.startTime).add("e", (Object)this.endTime).add("tk", (Object)this.totalTicks).add("tm", (Object)this.totalTime).add("w", (Object)this.worlds).add("h", (Object)JSONUtil.mapArray(this.entries, entry -> entry.data.count == 0 ? null : entry.export())).add("mp", (Object)JSONUtil.mapArray(this.minuteReports, MinuteReport::export)).build();
    }

    static {
        worldIdPool = 1;
        worldMap = LoadingMap.newHashMap(input -> worldIdPool++);
    }

    static class Counter {
        int count = 0;
        private static final Function<?, Counter> LOADER = new LoadingMap.Feeder<Counter>(){

            @Override
            public Counter apply() {
                return new Counter();
            }
        };

        Counter() {
        }

        static <T> Function<T, Counter> loader() {
            return LOADER;
        }

        public int increment() {
            return ++this.count;
        }

        public int count() {
            return this.count;
        }
    }

    static class PingRecord {
        final double avg;

        PingRecord() {
            Collection<Player> onlinePlayers = SpongeImpl.getGame().getServer().getOnlinePlayers();
            int totalPing = 0;
            for (Player player : onlinePlayers) {
                totalPing += player.getConnection().getLatency();
            }
            this.avg = onlinePlayers.isEmpty() ? 0.0 : (double)(totalPing / onlinePlayers.size());
        }
    }

    static class TicksRecord {
        final long timed = timedTicks - (long)(TimingsManager.MINUTE_REPORTS.size() * 1200);
        final long player = playerTicks;
        final long entity = entityTicks;
        final long tileEntity = tileEntityTicks;
        final long activatedEntity = activatedEntityTicks;

        TicksRecord() {
        }
    }

    static class MinuteReport {
        final long time = System.currentTimeMillis() / 1000L;
        final TicksRecord ticksRecord = new TicksRecord();
        final PingRecord pingRecord = new PingRecord();
        final TimingData fst;
        final double tps;
        final double usedMemory;
        final double freeMemory;
        final double loadAvg;

        MinuteReport() {
            this.fst = TimingsManager.FULL_SERVER_TICK.minuteData.clone();
            this.tps = 1.0E9 / (double)(System.nanoTime() - lastMinuteTime) * (double)this.ticksRecord.timed;
            this.usedMemory = TimingsManager.FULL_SERVER_TICK.avgUsedMemory;
            this.freeMemory = TimingsManager.FULL_SERVER_TICK.avgFreeMemory;
            this.loadAvg = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
        }

        public JsonArray export() {
            return JSONUtil.arrayOf(this.time, (double)Math.round(this.tps * 100.0) / 100.0, (double)Math.round(this.pingRecord.avg * 100.0) / 100.0, this.fst.export(), JSONUtil.arrayOf(this.ticksRecord.timed, this.ticksRecord.player, this.ticksRecord.entity, this.ticksRecord.activatedEntity, this.ticksRecord.tileEntity), this.usedMemory, this.freeMemory, this.loadAvg);
        }
    }
}

