/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.Queries;

public class Transaction<T extends DataSerializable>
implements DataSerializable {
    private final T original;
    private final T defaultReplacement;
    private boolean valid = true;
    @Nullable
    private T custom;

    public Transaction(T original, T defaultReplacement) {
        this.original = (DataSerializable)Preconditions.checkNotNull(original);
        this.defaultReplacement = (DataSerializable)Preconditions.checkNotNull(defaultReplacement);
    }

    public final T getOriginal() {
        return this.original;
    }

    public final T getDefault() {
        return this.defaultReplacement;
    }

    public final Optional<T> getCustom() {
        return Optional.ofNullable(this.custom);
    }

    public final void setCustom(@Nullable T custom) {
        this.custom = custom;
    }

    public final T getFinal() {
        return this.custom == null ? this.defaultReplacement : this.custom;
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final void setValid(boolean valid) {
        this.valid = valid;
    }

    public int hashCode() {
        return Objects.hash(this.original, this.defaultReplacement, this.valid, this.custom);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Transaction other = (Transaction)obj;
        return Objects.equals(this.original, other.original) && Objects.equals(this.defaultReplacement, other.defaultReplacement) && Objects.equals(this.valid, other.valid) && Objects.equals(this.custom, other.custom);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("original", this.original).add("default", this.defaultReplacement).add("custom", this.custom).add("valid", this.valid).toString();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Queries.TYPE_CLASS, (Object)this.original.getClass().getName()).set(Queries.ORIGINAL, this.original).set(Queries.DEFAULT_REPLACEMENT, this.defaultReplacement).set(Queries.VALID, (Object)this.valid);
        if (this.custom != null) {
            container.set(Queries.CUSTOM_REPLACEMENT, this.custom);
        }
        return container;
    }
}

