/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.manipulator.mutable.common;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.immutable.ImmutableListData;
import org.spongepowered.api.data.manipulator.mutable.ListData;
import org.spongepowered.api.data.manipulator.mutable.common.AbstractSingleData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.ListValue;

public abstract class AbstractListData<E, M extends ListData<E, M, I>, I extends ImmutableListData<E, I, M>>
extends AbstractSingleData<List<E>, M, I>
implements ListData<E, M, I> {
    protected AbstractListData(List<E> value, Key<? extends BaseValue<List<E>>> usedKey) {
        super(Lists.newArrayList(value), usedKey);
    }

    @Override
    protected ListValue<E> getValueGetter() {
        return Sponge.getRegistry().getValueFactory().createListValue(this.usedKey, this.getValue());
    }

    @Override
    public <E> Optional<E> get(Key<? extends BaseValue<E>> key) {
        return key == this.usedKey ? Optional.of(this.getValue()) : super.get(key);
    }

    @Override
    public boolean supports(Key<?> key) {
        return Preconditions.checkNotNull(key) == this.usedKey;
    }

    @Override
    public abstract I asImmutable();

    @Override
    protected List<E> getValue() {
        return Lists.newArrayList((Iterable)((Iterable)super.getValue()));
    }

    @Override
    protected M setValue(List<E> value) {
        return (M)((ListData)super.setValue(Lists.newArrayList(value)));
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode((Object[])new Object[]{this.getValue()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractListData other = (AbstractListData)obj;
        return Objects.equal((Object)this.getValue(), (Object)other.getValue());
    }

    @Override
    public ListValue<E> getListValue() {
        return this.getValueGetter();
    }

    @Override
    public List<E> asList() {
        return this.getValue();
    }
}

