/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.effect.particle;

import com.flowpowered.math.vector.Vector3d;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.api.effect.particle.ParticleOptions;
import org.spongepowered.api.effect.particle.ParticleType;

public interface ParticleEffect
extends DataSerializable {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public ParticleType getType();

    public <V> Optional<V> getOption(ParticleOption<V> var1);

    default public <V> Optional<V> getOptionOrDefault(ParticleOption<V> option) {
        Optional<V> value = this.getOption(option);
        return value.isPresent() ? value : this.getType().getDefaultOption(option);
    }

    public Map<ParticleOption<?>, Object> getOptions();

    public static interface Builder
    extends DataBuilder<ParticleEffect> {
        @Override
        public Builder from(ParticleEffect var1);

        @Override
        public Builder reset();

        public Builder type(ParticleType var1);

        public <V> Builder option(ParticleOption<V> var1, V var2) throws IllegalArgumentException;

        default public Builder velocity(Vector3d velocity) {
            return this.option(ParticleOptions.VELOCITY, velocity);
        }

        default public Builder offset(Vector3d offset) {
            return this.option(ParticleOptions.OFFSET, offset);
        }

        default public Builder quantity(int quantity) throws IllegalArgumentException {
            return this.option(ParticleOptions.QUANTITY, quantity);
        }

        public ParticleEffect build();
    }
}

