/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.cause.entity.damage;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.ResettableBuilder;

@Immutable
public interface DamageModifier {
    public static Builder builder() {
        return new Builder();
    }

    public DamageModifierType getType();

    public Cause getCause();

    public Optional<ItemStackSnapshot> getContributingItem();

    public static final class Builder
    implements ResettableBuilder<DamageModifier, Builder> {
        @Nullable
        DamageModifierType type;
        @Nullable
        Cause cause;
        @Nullable
        ItemStackSnapshot snapshot;

        Builder() {
        }

        public Builder type(DamageModifierType damageModifierType) {
            this.type = (DamageModifierType)Preconditions.checkNotNull((Object)damageModifierType);
            return this;
        }

        public Builder item(ItemStack itemStack) {
            this.item(((ItemStack)Preconditions.checkNotNull((Object)itemStack, (Object)"ItemStack")).createSnapshot());
            return this;
        }

        public Builder item(ItemStackSnapshot snapshot) {
            this.snapshot = (ItemStackSnapshot)Preconditions.checkNotNull((Object)snapshot, (Object)"ItemStackSnapshot");
            return this;
        }

        public Builder cause(Cause cause) {
            this.cause = (Cause)Preconditions.checkNotNull((Object)cause);
            return this;
        }

        public DamageModifier build() {
            Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"The DamageModifierType must not be null!");
            Preconditions.checkState((this.cause != null ? 1 : 0) != 0, (Object)"The cause for the DamageModifier must not be null!");
            return new ImplementedDamageModifier(this);
        }

        @Override
        public Builder from(DamageModifier value) {
            this.type = value.getType();
            this.cause = value.getCause();
            this.snapshot = value.getContributingItem().orElse(null);
            return this;
        }

        @Override
        public Builder reset() {
            this.type = null;
            this.cause = null;
            return this;
        }

        private static class ImplementedDamageModifier
        implements DamageModifier {
            private final DamageModifierType type;
            private final Cause cause;
            @Nullable
            private final ItemStackSnapshot snapshot;

            ImplementedDamageModifier(Builder builder) {
                this.type = (DamageModifierType)Preconditions.checkNotNull((Object)builder.type, (Object)"DamageType is null!");
                this.cause = (Cause)Preconditions.checkNotNull((Object)builder.cause, (Object)"Cause is null!");
                this.snapshot = builder.snapshot;
            }

            @Override
            public DamageModifierType getType() {
                return this.type;
            }

            @Override
            public Cause getCause() {
                return this.cause;
            }

            @Override
            public Optional<ItemStackSnapshot> getContributingItem() {
                return Optional.ofNullable(this.snapshot);
            }

            public int hashCode() {
                return Objects.hashCode((Object[])new Object[]{this.type, this.cause});
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                ImplementedDamageModifier other = (ImplementedDamageModifier)obj;
                return Objects.equal((Object)this.type, (Object)other.type) && Objects.equal((Object)this.cause, (Object)other.cause) && Objects.equal((Object)this.snapshot, (Object)other.snapshot);
            }

            public String toString() {
                return Objects.toStringHelper((String)"DamageModifier").add("type", (Object)this.type).add("cause", (Object)this.cause).add("contributing", (Object)this.snapshot).toString();
            }
        }
    }
}

