/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.cause.entity.health;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.entity.health.HealthModifierType;
import org.spongepowered.api.util.ResettableBuilder;

public interface HealthModifier {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public HealthModifierType getType();

    public Cause getCause();

    public static final class Builder
    implements ResettableBuilder<HealthModifier, Builder> {
        HealthModifierType type;
        Cause cause;

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder type(HealthModifierType healthModifierType) {
            this.type = (HealthModifierType)Preconditions.checkNotNull((Object)healthModifierType);
            return this;
        }

        public Builder cause(Cause cause) {
            this.cause = (Cause)Preconditions.checkNotNull((Object)cause);
            return this;
        }

        public HealthModifier build() {
            Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"The HealthModifierType must not be null!");
            Preconditions.checkState((this.cause != null ? 1 : 0) != 0, (Object)"The cause for the HealthModifier must not be null!");
            return new ImplementedHealthModifier(this);
        }

        @Override
        public Builder from(HealthModifier value) {
            this.reset();
            this.type = value.getType();
            this.cause = value.getCause();
            return this;
        }

        @Override
        public Builder reset() {
            this.type = null;
            this.cause = null;
            return this;
        }

        private static class ImplementedHealthModifier
        implements HealthModifier {
            private final HealthModifierType type;
            private final Cause cause;

            ImplementedHealthModifier(Builder builder) {
                this.type = builder.type;
                this.cause = builder.cause;
            }

            @Override
            public HealthModifierType getType() {
                return this.type;
            }

            @Override
            public Cause getCause() {
                return this.cause;
            }

            public int hashCode() {
                return Objects.hashCode((Object[])new Object[]{this.type, this.cause});
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                ImplementedHealthModifier other = (ImplementedHealthModifier)obj;
                return Objects.equal((Object)this.type, (Object)other.type) && Objects.equal((Object)this.cause, (Object)other.cause);
            }

            public String toString() {
                return Objects.toStringHelper((Object)this).add("type", (Object)this.type).add("cause", (Object)this.cause).toString();
            }
        }
    }
}

