/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import org.spongepowered.api.Nameable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.util.ResettableBuilder;

public interface Inventory
extends Iterable<Inventory>,
Nameable {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public Inventory parent();

    public <T extends Inventory> Iterable<T> slots();

    public <T extends Inventory> T first();

    public <T extends Inventory> T next();

    public Optional<ItemStack> poll();

    public Optional<ItemStack> poll(int var1);

    public Optional<ItemStack> peek();

    public Optional<ItemStack> peek(int var1);

    public InventoryTransactionResult offer(ItemStack var1);

    public InventoryTransactionResult set(ItemStack var1);

    public void clear();

    public int size();

    public int totalItems();

    public int capacity();

    public boolean hasChildren();

    public boolean contains(ItemStack var1);

    public boolean contains(ItemType var1);

    public boolean containsAny(ItemStack var1);

    public int getMaxStackSize();

    public void setMaxStackSize(int var1);

    public <T extends InventoryProperty<?, ?>> Collection<T> getProperties(Inventory var1, Class<T> var2);

    public <T extends InventoryProperty<?, ?>> Collection<T> getProperties(Class<T> var1);

    public <T extends InventoryProperty<?, ?>> Optional<T> getProperty(Inventory var1, Class<T> var2, Object var3);

    public <T extends InventoryProperty<?, ?>> Optional<T> getProperty(Class<T> var1, Object var2);

    public <T extends Inventory> T query(Class<?> ... var1);

    public <T extends Inventory> T query(ItemType ... var1);

    public <T extends Inventory> T query(ItemStack ... var1);

    public <T extends Inventory> T query(InventoryProperty<?, ?> ... var1);

    public <T extends Inventory> T query(Translation ... var1);

    public <T extends Inventory> T query(String ... var1);

    public <T extends Inventory> T query(Object ... var1);

    public <T extends Inventory> T queryAny(ItemStack ... var1);

    public PluginContainer getPlugin();

    public InventoryArchetype getArchetype();

    public static interface Builder
    extends ResettableBuilder<Inventory, Builder> {
        public Builder of(InventoryArchetype var1);

        public Builder property(String var1, InventoryProperty<?, ?> var2);

        public Builder withCarrier(Carrier var1);

        public <E extends InteractInventoryEvent> Builder listener(Class<E> var1, Consumer<E> var2);

        public Builder forCarrier(Carrier var1);

        public Builder forCarrier(Class<? extends Carrier> var1);

        public Inventory build(Object var1);
    }
}

