/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.ScoreText;
import org.spongepowered.api.text.SelectorText;
import org.spongepowered.api.text.TextIterator;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.TranslatableText;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.ShiftClickAction;
import org.spongepowered.api.text.action.TextAction;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextFormat;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.text.selector.Selector;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.text.translation.Translation;

public abstract class Text
implements TextRepresentable,
DataSerializable,
Comparable<Text> {
    public static final Text EMPTY = LiteralText.EMPTY;
    static final char NEW_LINE_CHAR = '\n';
    static final String NEW_LINE_STRING = "\n";
    public static final LiteralText NEW_LINE = new LiteralText("\n");
    public static Comparator<Text> PLAIN_COMPARATOR = (text1, text2) -> text1.toPlain().compareTo(text2.toPlain());
    final TextFormat format;
    final ImmutableList<Text> children;
    final Optional<ClickAction<?>> clickAction;
    final Optional<HoverAction<?>> hoverAction;
    final Optional<ShiftClickAction<?>> shiftClickAction;
    final Iterable<Text> childrenIterable;

    Text() {
        this.format = TextFormat.NONE;
        this.children = ImmutableList.of();
        this.clickAction = Optional.empty();
        this.hoverAction = Optional.empty();
        this.shiftClickAction = Optional.empty();
        this.childrenIterable = () -> Iterators.singletonIterator((Object)this);
    }

    Text(TextFormat format, ImmutableList<Text> children, @Nullable ClickAction<?> clickAction, @Nullable HoverAction<?> hoverAction, @Nullable ShiftClickAction<?> shiftClickAction) {
        this.format = (TextFormat)Preconditions.checkNotNull((Object)format, (Object)"format");
        this.children = (ImmutableList)Preconditions.checkNotNull(children, (Object)"children");
        this.clickAction = Optional.ofNullable(clickAction);
        this.hoverAction = Optional.ofNullable(hoverAction);
        this.shiftClickAction = Optional.ofNullable(shiftClickAction);
        this.childrenIterable = () -> new TextIterator(this);
    }

    public final TextFormat getFormat() {
        return this.format;
    }

    public final TextColor getColor() {
        return this.format.getColor();
    }

    public final TextStyle getStyle() {
        return this.format.getStyle();
    }

    public final ImmutableList<Text> getChildren() {
        return this.children;
    }

    public final Iterable<Text> withChildren() {
        return this.childrenIterable;
    }

    public final Optional<ClickAction<?>> getClickAction() {
        return this.clickAction;
    }

    public final Optional<HoverAction<?>> getHoverAction() {
        return this.hoverAction;
    }

    public final Optional<ShiftClickAction<?>> getShiftClickAction() {
        return this.shiftClickAction;
    }

    public final boolean isEmpty() {
        return this == EMPTY;
    }

    public abstract Builder toBuilder();

    public final String toPlain() {
        return TextSerializers.PLAIN.serialize(this);
    }

    public final String toPlainSingle() {
        return TextSerializers.PLAIN.serializeSingle(this);
    }

    public final Text concat(Text other) {
        return this.toBuilder().append(other).build();
    }

    public final Text trim() {
        return this.toBuilder().trim().build();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Queries.JSON, (Object)TextSerializers.JSON.serialize(this));
    }

    @Override
    public int compareTo(Text o) {
        return PLAIN_COMPARATOR.compare(this, o);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Text)) {
            return false;
        }
        Text that = (Text)o;
        return this.format.equals(that.format) && this.children.equals(that.children) && this.clickAction.equals(that.clickAction) && this.hoverAction.equals(that.hoverAction) && this.shiftClickAction.equals(that.shiftClickAction);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.format, this.children, this.clickAction, this.hoverAction, this.shiftClickAction});
    }

    Objects.ToStringHelper toStringHelper() {
        return Objects.toStringHelper(Text.class).omitNullValues().add("format", (Object)(this.format.isEmpty() ? null : this.format)).add("children", this.children.isEmpty() ? null : this.children).add("clickAction", this.clickAction.orElse(null)).add("hoverAction", this.hoverAction.orElse(null)).add("shiftClickAction", this.shiftClickAction.orElse(null));
    }

    public final String toString() {
        return this.toStringHelper().toString();
    }

    @Override
    public final Text toText() {
        return this;
    }

    public static Text of() {
        return EMPTY;
    }

    public static LiteralText of(String content) {
        if (((String)Preconditions.checkNotNull((Object)content, (Object)"content")).isEmpty()) {
            return LiteralText.EMPTY;
        }
        if (content.equals(NEW_LINE_STRING)) {
            return NEW_LINE;
        }
        return new LiteralText(content);
    }

    public static LiteralText of(char content) {
        if (content == '\n') {
            return NEW_LINE;
        }
        return new LiteralText(String.valueOf(content));
    }

    public static TranslatableText of(Translation translation, Object ... args) {
        return new TranslatableText(translation, (ImmutableList<Object>)ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)args, (Object)"args"))));
    }

    public static TranslatableText of(Translatable translatable, Object ... args) {
        return Text.of(((Translatable)Preconditions.checkNotNull((Object)translatable, (Object)"translatable")).getTranslation(), args);
    }

    public static SelectorText of(Selector selector) {
        return new SelectorText(selector);
    }

    public static ScoreText of(Score score) {
        return new ScoreText(score);
    }

    public static Text of(Object ... objects) {
        if (objects.length == 1 && objects[0] instanceof TextRepresentable) {
            return ((TextRepresentable)objects[0]).toText();
        }
        Builder builder = Text.builder();
        TextFormat format = TextFormat.NONE;
        HoverAction hoverAction = null;
        ClickAction clickAction = null;
        ShiftClickAction shiftClickAction = null;
        boolean changedFormat = false;
        for (Object obj : objects) {
            Builder childBuilder;
            if (obj instanceof TextFormat) {
                changedFormat = true;
                format = (TextFormat)obj;
                continue;
            }
            if (obj instanceof TextColor) {
                changedFormat = true;
                format = format.color((TextColor)obj);
                continue;
            }
            if (obj instanceof TextStyle) {
                changedFormat = true;
                format = format.style(obj.equals(TextStyles.RESET) ? TextStyles.NONE : format.getStyle().and((TextStyle)obj));
                continue;
            }
            if (obj instanceof TextAction) {
                changedFormat = true;
                if (obj instanceof HoverAction) {
                    hoverAction = (HoverAction)obj;
                    continue;
                }
                if (obj instanceof ClickAction) {
                    clickAction = (ClickAction)obj;
                    continue;
                }
                if (!(obj instanceof ShiftClickAction)) continue;
                shiftClickAction = (ShiftClickAction)obj;
                continue;
            }
            if (obj instanceof TextRepresentable) {
                changedFormat = false;
                childBuilder = ((TextRepresentable)obj).toText().toBuilder();
                childBuilder.format(format.merge(childBuilder.format));
                if (childBuilder.clickAction == null) {
                    childBuilder.clickAction = clickAction;
                }
                if (childBuilder.hoverAction == null) {
                    childBuilder.hoverAction = hoverAction;
                }
                if (childBuilder.shiftClickAction == null) {
                    childBuilder.shiftClickAction = shiftClickAction;
                }
                builder.append(childBuilder.build());
                continue;
            }
            changedFormat = false;
            childBuilder = obj instanceof String ? Text.builder((String)obj) : (obj instanceof Translation ? Text.builder((Translation)obj, new Object[0]) : (obj instanceof Translatable ? Text.builder(((Translatable)obj).getTranslation(), new Object[0]) : (obj instanceof Selector ? Text.builder((Selector)obj) : (obj instanceof Score ? Text.builder((Score)obj) : Text.builder(String.valueOf(obj))))));
            if (hoverAction != null) {
                childBuilder.onHover(hoverAction);
            }
            if (clickAction != null) {
                childBuilder.onClick(clickAction);
            }
            if (shiftClickAction != null) {
                childBuilder.onShiftClick(shiftClickAction);
            }
            builder.append(childBuilder.format(format).build());
        }
        if (changedFormat) {
            Builder childBuilder = Text.builder();
            if (hoverAction != null) {
                childBuilder.onHover(hoverAction);
            }
            if (clickAction != null) {
                childBuilder.onClick(clickAction);
            }
            if (shiftClickAction != null) {
                childBuilder.onShiftClick(shiftClickAction);
            }
            builder.append(childBuilder.format(format).build());
        }
        if (builder.children.size() == 1) {
            return builder.children.get(0);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new LiteralText.Builder();
    }

    public static LiteralText.Builder builder(String content) {
        return new LiteralText.Builder(content);
    }

    public static LiteralText.Builder builder(char content) {
        return Text.builder(String.valueOf(content));
    }

    public static LiteralText.Builder builder(Text text, String content) {
        return new LiteralText.Builder(text, content);
    }

    public static TranslatableText.Builder builder(Translation translation, Object ... args) {
        return new TranslatableText.Builder(translation, args);
    }

    public static TranslatableText.Builder builder(Translatable translatable, Object ... args) {
        return new TranslatableText.Builder(translatable, args);
    }

    public static TranslatableText.Builder builder(Text text, Translation translation, Object ... args) {
        return new TranslatableText.Builder(text, translation, args);
    }

    public static TranslatableText.Builder builder(Text text, Translatable translatable, Object ... args) {
        return new TranslatableText.Builder(text, translatable, args);
    }

    public static SelectorText.Builder builder(Selector selector) {
        return new SelectorText.Builder(selector);
    }

    public static SelectorText.Builder builder(Text text, Selector selector) {
        return new SelectorText.Builder(text, selector);
    }

    public static ScoreText.Builder builder(Score score) {
        return new ScoreText.Builder(score);
    }

    public static ScoreText.Builder builder(Text text, Score score) {
        return new ScoreText.Builder(text, score);
    }

    public static Text join(Text ... texts) {
        return Text.builder().append(texts).build();
    }

    public static Text join(Iterable<? extends Text> texts) {
        return Text.builder().append(texts).build();
    }

    public static Text join(Iterator<? extends Text> texts) {
        return Text.builder().append(texts).build();
    }

    public static Text joinWith(Text separator, Text ... texts) {
        switch (texts.length) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return texts[0];
            }
        }
        Builder builder = Text.builder();
        boolean appendSeparator = false;
        for (Text text : texts) {
            if (appendSeparator) {
                builder.append(separator);
            } else {
                appendSeparator = true;
            }
            builder.append(text);
        }
        return builder.build();
    }

    public static Text joinWith(Text separator, Iterable<? extends Text> texts) {
        return Text.joinWith(separator, texts.iterator());
    }

    public static Text joinWith(Text separator, Iterator<? extends Text> texts) {
        if (!texts.hasNext()) {
            return EMPTY;
        }
        Text first = texts.next();
        if (!texts.hasNext()) {
            return first;
        }
        Builder builder = Text.builder().append(first);
        do {
            builder.append(separator);
            builder.append(texts.next());
        } while (texts.hasNext());
        return builder.build();
    }

    public static abstract class Builder
    implements TextRepresentable {
        TextFormat format = TextFormat.NONE;
        List<Text> children = new ArrayList<Text>();
        @Nullable
        ClickAction<?> clickAction;
        @Nullable
        HoverAction<?> hoverAction;
        @Nullable
        ShiftClickAction<?> shiftClickAction;

        Builder() {
        }

        Builder(Text text) {
            this.format = text.format;
            this.children = new ArrayList<Text>((Collection<Text>)text.children);
            this.clickAction = text.clickAction.orElse(null);
            this.hoverAction = text.hoverAction.orElse(null);
            this.shiftClickAction = text.shiftClickAction.orElse(null);
        }

        public final TextFormat getFormat() {
            return this.format;
        }

        public Builder format(TextFormat format) {
            this.format = (TextFormat)Preconditions.checkNotNull((Object)format, (Object)"format");
            return this;
        }

        public final TextColor getColor() {
            return this.format.getColor();
        }

        public Builder color(TextColor color) {
            this.format = this.format.color(color);
            return this;
        }

        public final TextStyle getStyle() {
            return this.format.getStyle();
        }

        public Builder style(TextStyle ... styles) {
            this.format = this.format.style(this.format.getStyle().and(styles));
            return this;
        }

        public final Optional<ClickAction<?>> getClickAction() {
            return Optional.ofNullable(this.clickAction);
        }

        public Builder onClick(@Nullable ClickAction<?> clickAction) {
            this.clickAction = clickAction;
            return this;
        }

        public final Optional<HoverAction<?>> getHoverAction() {
            return Optional.ofNullable(this.hoverAction);
        }

        public Builder onHover(@Nullable HoverAction<?> hoverAction) {
            this.hoverAction = hoverAction;
            return this;
        }

        public final Optional<ShiftClickAction<?>> getShiftClickAction() {
            return Optional.ofNullable(this.shiftClickAction);
        }

        public Builder onShiftClick(@Nullable ShiftClickAction<?> shiftClickAction) {
            this.shiftClickAction = shiftClickAction;
            return this;
        }

        public final List<Text> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        public Builder append(Text ... children) {
            Collections.addAll(this.children, children);
            return this;
        }

        public Builder append(Collection<? extends Text> children) {
            this.children.addAll(children);
            return this;
        }

        public Builder append(Iterable<? extends Text> children) {
            for (Text text : children) {
                this.children.add(text);
            }
            return this;
        }

        public Builder append(Iterator<? extends Text> children) {
            while (children.hasNext()) {
                this.children.add(children.next());
            }
            return this;
        }

        public Builder insert(int pos, Text ... children) {
            this.children.addAll(pos, Arrays.asList(children));
            return this;
        }

        public Builder insert(int pos, Collection<? extends Text> children) {
            this.children.addAll(pos, children);
            return this;
        }

        public Builder insert(int pos, Iterable<? extends Text> children) {
            for (Text text : children) {
                this.children.add(pos++, text);
            }
            return this;
        }

        public Builder insert(int pos, Iterator<? extends Text> children) {
            while (children.hasNext()) {
                this.children.add(pos++, children.next());
            }
            return this;
        }

        public Builder remove(Text ... children) {
            this.children.removeAll(Arrays.asList(children));
            return this;
        }

        public Builder remove(Collection<? extends Text> children) {
            this.children.removeAll(children);
            return this;
        }

        public Builder remove(Iterable<? extends Text> children) {
            for (Text text : children) {
                this.children.remove(text);
            }
            return this;
        }

        public Builder remove(Iterator<? extends Text> children) {
            while (children.hasNext()) {
                this.children.remove(children.next());
            }
            return this;
        }

        public Builder removeAll() {
            this.children.clear();
            return this;
        }

        public Builder trim() {
            Iterator<Text> front = this.children.iterator();
            while (front.hasNext() && front.next().isEmpty()) {
                front.remove();
            }
            ListIterator<Text> back = this.children.listIterator(this.children.size());
            while (back.hasPrevious() && back.previous().isEmpty()) {
                back.remove();
            }
            return this;
        }

        public abstract Text build();

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder that = (Builder)o;
            return Objects.equal((Object)this.format, (Object)that.format) && Objects.equal(this.clickAction, that.clickAction) && Objects.equal(this.hoverAction, that.hoverAction) && Objects.equal(this.shiftClickAction, that.shiftClickAction) && Objects.equal(this.children, that.children);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.format, this.clickAction, this.hoverAction, this.shiftClickAction, this.children});
        }

        Objects.ToStringHelper toStringHelper() {
            return Objects.toStringHelper(Builder.class).omitNullValues().add("format", (Object)(this.format.isEmpty() ? null : this.format)).add("children", this.children.isEmpty() ? null : this.children).add("clickAction", this.clickAction).add("hoverAction", this.hoverAction).add("shiftClickAction", this.shiftClickAction);
        }

        public final String toString() {
            return this.toStringHelper().toString();
        }

        @Override
        public final Text toText() {
            return this.build();
        }
    }
}

