/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextElement;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.TextTemplateArgumentException;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextFormat;
import org.spongepowered.api.text.format.TextStyle;

public final class TextTemplate
implements TextRepresentable,
Iterable<Object> {
    public static final String DEFAULT_OPEN_ARG = "{";
    public static final String DEFAULT_CLOSE_ARG = "}";
    public static final TextTemplate EMPTY = new TextTemplate("{", "}", new Object[0]);
    final ImmutableList<Object> elements;
    final ImmutableMap<String, Arg> arguments;
    final Text text;
    final String openArg;
    final String closeArg;

    TextTemplate(String openArg, String closeArg, Object[] elements) {
        this.openArg = openArg;
        this.closeArg = closeArg;
        ImmutableList.Builder elementList = ImmutableList.builder();
        HashMap<String, Arg> argumentMap = new HashMap<String, Arg>();
        for (Object element : elements) {
            if (element instanceof Arg.Builder) {
                element = ((Arg.Builder)element).build();
            }
            if (element instanceof Arg) {
                Arg newArg = new Arg((Arg)element, this.openArg, this.closeArg);
                Arg oldArg = (Arg)argumentMap.get(newArg.name);
                if (oldArg != null && !oldArg.equals(newArg)) {
                    throw new TextTemplateArgumentException("Tried to supply an unequal argument with a duplicate name \"" + newArg.name + "\" to TextTemplate.");
                }
                argumentMap.put(newArg.name, newArg);
                element = newArg;
            }
            elementList.add(element);
        }
        this.elements = elementList.build();
        this.arguments = ImmutableMap.copyOf(argumentMap);
        Text.Builder builder = null;
        for (Object element : this.elements) {
            builder = this.apply(element, builder);
        }
        this.text = ((Text.Builder)Optional.ofNullable(builder).orElse(Text.builder())).build();
    }

    public List<Object> getElements() {
        return this.elements;
    }

    public Map<String, Arg> getArguments() {
        return this.arguments;
    }

    public String getOpenArgString() {
        return this.openArg;
    }

    public String getCloseArgString() {
        return this.closeArg;
    }

    public TextTemplate concat(TextTemplate other) {
        ArrayList<Object> elements = new ArrayList<Object>((Collection<Object>)this.elements);
        elements.addAll((Collection<Object>)other.elements);
        return TextTemplate.of(this.openArg, this.closeArg, elements.toArray(new Object[elements.size()]));
    }

    public Text.Builder apply() {
        return this.apply(Collections.emptyMap());
    }

    public Text.Builder apply(Map<String, ?> params) {
        return this.apply(null, params);
    }

    private Text.Builder apply(@Nullable Text.Builder result, Map<String, ?> params) {
        Preconditions.checkNotNull(params, (Object)"params");
        for (Object element : this.elements) {
            result = this.apply(element, result, params);
        }
        return Optional.ofNullable(result).orElse(Text.builder());
    }

    @Nullable
    private Text.Builder apply(Object element, @Nullable Text.Builder builder, Map<String, ?> params) {
        if (element instanceof Arg) {
            Arg arg = (Arg)element;
            Object param = params.get(arg.name);
            if (param == null) {
                arg.checkOptional();
                if (arg.defaultValue != null) {
                    builder = this.applyArg(arg.defaultValue, arg, builder);
                }
            } else {
                builder = this.applyArg(param, arg, builder);
            }
        } else {
            builder = this.apply(element, builder);
        }
        return builder;
    }

    private Text.Builder apply(Object element, @Nullable Text.Builder builder) {
        if (element instanceof Text) {
            Text text = (Text)element;
            if (builder == null) {
                builder = text.toBuilder();
            } else {
                builder.append(text);
            }
        } else if (element instanceof TextElement) {
            if (builder == null) {
                builder = Text.builder();
            }
            ((TextElement)element).applyTo(builder);
        } else {
            String str = element.toString();
            if (builder == null) {
                builder = Text.builder(str);
            } else {
                builder.append(Text.of(str));
            }
        }
        return builder;
    }

    private Text.Builder applyArg(Object param, Arg arg, @Nullable Text.Builder builder) {
        if (builder == null) {
            builder = Text.builder();
        }
        Text.Builder wrapper = Text.builder().format(arg.format);
        this.apply(param, wrapper);
        builder.append(wrapper.build());
        return builder;
    }

    public static TextTemplate of(String openArg, String closeArg, Object[] elements) {
        Preconditions.checkNotNull((Object)openArg, (Object)"open arg");
        Preconditions.checkArgument((!openArg.isEmpty() ? 1 : 0) != 0, (Object)"open arg cannot be empty");
        Preconditions.checkNotNull((Object)closeArg, (Object)"close arg");
        Preconditions.checkArgument((!closeArg.isEmpty() ? 1 : 0) != 0, (Object)"close arg cannot be empty");
        Preconditions.checkNotNull((Object)elements, (Object)"elements");
        if (elements.length == 0) {
            return TextTemplate.of();
        }
        return new TextTemplate(openArg, closeArg, elements);
    }

    public static TextTemplate of(Object ... elements) {
        return TextTemplate.of(DEFAULT_OPEN_ARG, DEFAULT_CLOSE_ARG, elements);
    }

    public static TextTemplate of() {
        return EMPTY;
    }

    public static Arg.Builder arg(String name) {
        return new Arg.Builder(name);
    }

    @Override
    public Text toText() {
        return this.text;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.elements.iterator();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("elements", this.elements).add("arguments", this.arguments).add("text", (Object)this.text).add("openArg", (Object)this.openArg).add("closeArg", (Object)this.closeArg).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.elements, this.openArg, this.closeArg});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextTemplate)) {
            return false;
        }
        TextTemplate that = (TextTemplate)obj;
        return that.elements.equals(this.elements) && that.openArg.equals(this.openArg) && that.closeArg.equals(this.closeArg);
    }

    @ConfigSerializable
    public static final class Arg
    implements TextRepresentable {
        @Setting
        final boolean optional;
        @Setting
        @Nullable
        final Text defaultValue;
        final String name;
        final TextFormat format;
        final String openArg;
        final String closeArg;

        Arg(String name, boolean optional, @Nullable Text defaultValue, TextFormat format, String openArg, String closeArg) {
            this.name = name;
            this.optional = optional;
            this.defaultValue = defaultValue;
            this.format = format;
            this.openArg = openArg;
            this.closeArg = closeArg;
        }

        Arg(String name, boolean optional, @Nullable Text defaultValue, TextFormat format) {
            this(name, optional, defaultValue, format, TextTemplate.DEFAULT_OPEN_ARG, TextTemplate.DEFAULT_CLOSE_ARG);
        }

        Arg(Arg arg, String openArg, String closeArg) {
            this(arg.name, arg.optional, arg.defaultValue, arg.format, openArg, closeArg);
        }

        void checkOptional() {
            if (!this.optional) {
                throw new TextTemplateArgumentException("Missing required argument in TextTemplate \"" + this.name + "\".");
            }
        }

        public String getName() {
            return this.name;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public Optional<Text> getDefaultValue() {
            return Optional.ofNullable(this.defaultValue);
        }

        public TextFormat getFormat() {
            return this.format;
        }

        public String getOpenArgString() {
            return this.openArg;
        }

        public String getCloseArgString() {
            return this.closeArg;
        }

        @Override
        public Text toText() {
            return Text.builder(this.openArg + this.name + this.closeArg).format(this.format).build();
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).omitNullValues().add("optional", this.optional).add("defaultValue", (Object)this.defaultValue).add("name", (Object)this.name).add("format", (Object)(this.format.isEmpty() ? null : this.format)).add("openArg", (Object)this.openArg).add("closeArg", (Object)this.closeArg).toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.optional, this.defaultValue, this.openArg, this.closeArg});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Arg)) {
                return false;
            }
            Arg that = (Arg)obj;
            return that.name.equals(this.name) && that.optional == this.optional && (that.defaultValue != null ? that.defaultValue.equals(this.defaultValue) : this.defaultValue == null) && that.openArg.equals(this.openArg) && that.closeArg.equals(this.closeArg);
        }

        public static final class Builder {
            final String name;
            boolean optional = false;
            @Nullable
            Text defaultValue;
            TextFormat format = TextFormat.NONE;

            Builder(String name) {
                this.name = name;
            }

            public Arg build() {
                return new Arg(this.name, this.optional, this.defaultValue, this.format);
            }

            public Builder optional(boolean optional) {
                this.optional = optional;
                return this;
            }

            public Builder optional() {
                return this.optional(true);
            }

            public Builder defaultValue(Text defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            public Builder format(TextFormat format) {
                this.format = format;
                return this;
            }

            public Builder color(TextColor color) {
                this.format = this.format.color(color);
                return this;
            }

            public Builder style(TextStyle style) {
                this.format = this.format.style(style);
                return this;
            }

            public String toString() {
                return Objects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("optional", this.optional).add("defaultValue", (Object)this.defaultValue).add("format", (Object)(this.format.isEmpty() ? null : this.format)).toString();
            }
        }
    }
}

