/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.title;

import com.google.common.base.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.text.Text;

public final class Title {
    public static final Title EMPTY = new Title();
    public static final Title CLEAR = new Title(null, null, null, null, null, null, true, false);
    public static final Title RESET = new Title(null, null, null, null, null, null, false, true);
    final Optional<Text> title;
    final Optional<Text> subtitle;
    final Optional<Text> actionBar;
    final Optional<Integer> fadeIn;
    final Optional<Integer> stay;
    final Optional<Integer> fadeOut;
    final boolean clear;
    final boolean reset;

    private Title() {
        this(null, null, null, null, null, null, false, false);
    }

    Title(@Nullable Text title, @Nullable Text subtitle, @Nullable Text actionBar, @Nullable Integer fadeIn, @Nullable Integer stay, @Nullable Integer fadeOut, boolean clear, boolean reset) {
        this.title = Optional.ofNullable(title);
        this.subtitle = Optional.ofNullable(subtitle);
        this.actionBar = Optional.ofNullable(actionBar);
        this.fadeIn = Optional.ofNullable(fadeIn);
        this.stay = Optional.ofNullable(stay);
        this.fadeOut = Optional.ofNullable(fadeOut);
        this.clear = clear;
        this.reset = reset;
    }

    public Optional<Text> getTitle() {
        return this.title;
    }

    public Optional<Text> getSubtitle() {
        return this.subtitle;
    }

    public Optional<Text> getActionBar() {
        return this.actionBar;
    }

    public Optional<Integer> getFadeIn() {
        return this.fadeIn;
    }

    public Optional<Integer> getStay() {
        return this.stay;
    }

    public Optional<Integer> getFadeOut() {
        return this.fadeOut;
    }

    public boolean isClear() {
        return this.clear;
    }

    public boolean isReset() {
        return this.reset;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Title)) {
            return false;
        }
        Title that = (Title)o;
        return this.title.equals(that.title) && this.subtitle.equals(that.subtitle) && this.actionBar.equals(that.actionBar) && this.fadeIn.equals(that.fadeIn) && this.stay.equals(that.stay) && this.fadeOut.equals(that.fadeOut) && this.clear == that.clear && this.reset == that.reset;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.title, this.subtitle, this.actionBar, this.fadeIn, this.stay, this.fadeOut, this.clear, this.reset});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("title", this.title.orElse(null)).add("subtitle", this.subtitle.orElse(null)).add("actionBar", this.actionBar.orElse(null)).add("fadeIn", this.fadeIn.orElse(null)).add("stay", this.stay.orElse(null)).add("fadeOut", this.fadeOut.orElse(null)).add("clear", this.clear).add("reset", this.reset).toString();
    }

    public static Title of() {
        return EMPTY;
    }

    public static Title of(Text title) {
        return Title.builder().title(title).build();
    }

    public static Title of(Text title, Text subtitle) {
        return Title.builder().title(title).subtitle(subtitle).build();
    }

    public static Title clear() {
        return CLEAR;
    }

    public static Title reset() {
        return RESET;
    }

    public static Builder builder() {
        return Title.update().reset();
    }

    public static Builder update() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Text title;
        @Nullable
        private Text subtitle;
        @Nullable
        private Text actionBar;
        @Nullable
        private Integer fadeIn;
        @Nullable
        private Integer stay;
        @Nullable
        private Integer fadeOut;
        private boolean clear;
        private boolean reset;

        Builder() {
        }

        Builder(Title title) {
            this.title = title.title.orElse(null);
            this.subtitle = title.subtitle.orElse(null);
            this.actionBar = title.actionBar.orElse(null);
            this.fadeIn = title.fadeIn.orElse(null);
            this.stay = title.stay.orElse(null);
            this.fadeOut = title.fadeOut.orElse(null);
            this.clear = title.clear;
            this.reset = title.reset;
        }

        public Optional<Text> getTitle() {
            return Optional.ofNullable(this.title);
        }

        public Builder title(@Nullable Text title) {
            this.title = title;
            return this;
        }

        public Optional<Text> getSubtitle() {
            return Optional.ofNullable(this.subtitle);
        }

        public Builder subtitle(@Nullable Text subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Optional<Text> getActionBar() {
            return Optional.ofNullable(this.actionBar);
        }

        public Builder actionBar(@Nullable Text actionBar) {
            this.actionBar = actionBar;
            return this;
        }

        public Optional<Integer> getFadeIn() {
            return Optional.ofNullable(this.fadeIn);
        }

        public Builder fadeIn(@Nullable Integer fadeIn) {
            this.fadeIn = fadeIn;
            return this;
        }

        public Optional<Integer> getStay() {
            return Optional.ofNullable(this.stay);
        }

        public Builder stay(@Nullable Integer stay) {
            this.stay = stay;
            return this;
        }

        public Optional<Integer> getFadeOut() {
            return Optional.ofNullable(this.fadeOut);
        }

        public Builder fadeOut(@Nullable Integer fadeOut) {
            this.fadeOut = fadeOut;
            return this;
        }

        public boolean isClear() {
            return this.clear;
        }

        public Builder clear() {
            return this.clear(true);
        }

        public Builder clear(boolean clear) {
            this.clear = clear;
            if (this.clear) {
                this.title = null;
            }
            return this;
        }

        public boolean isReset() {
            return this.reset;
        }

        public Builder reset() {
            return this.reset(true);
        }

        public Builder reset(boolean reset) {
            this.reset = reset;
            if (this.reset) {
                this.title = null;
                this.subtitle = null;
                this.fadeIn = null;
                this.stay = null;
                this.fadeOut = null;
            }
            return this;
        }

        public Title build() {
            if (this.title == null && this.subtitle == null && this.actionBar == null && this.fadeIn == null && this.stay == null && this.fadeOut == null) {
                if (this.clear) {
                    if (!this.reset) {
                        return CLEAR;
                    }
                } else {
                    if (this.reset) {
                        return RESET;
                    }
                    return EMPTY;
                }
            }
            return new Title(this.title, this.subtitle, this.actionBar, this.fadeIn, this.stay, this.fadeOut, this.clear, this.reset);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder that = (Builder)o;
            return Objects.equal((Object)this.title, (Object)that.title) && Objects.equal((Object)this.subtitle, (Object)that.subtitle) && Objects.equal((Object)this.actionBar, (Object)that.actionBar) && Objects.equal((Object)this.fadeIn, (Object)that.fadeIn) && Objects.equal((Object)this.stay, (Object)that.stay) && Objects.equal((Object)this.fadeOut, (Object)that.fadeOut) && this.clear == that.clear && this.reset == that.reset;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.title, this.subtitle, this.actionBar, this.fadeIn, this.stay, this.fadeOut, this.clear, this.reset});
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).omitNullValues().add("title", (Object)this.title).add("subtitle", (Object)this.subtitle).add("actionBar", (Object)this.actionBar).add("fadeIn", (Object)this.fadeIn).add("stay", (Object)this.stay).add("fadeOut", (Object)this.fadeOut).add("clear", this.clear).add("reset", this.reset).toString();
        }
    }
}

