/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.ban;

import java.net.InetAddress;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.util.ban.BanType;
import org.spongepowered.api.util.ban.BanTypes;

public interface Ban {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public static Ban of(GameProfile profile) {
        return Ban.builder().type(BanTypes.PROFILE).profile(profile).build();
    }

    public static Ban of(GameProfile profile, Text reason) {
        return Ban.builder().type(BanTypes.PROFILE).profile(profile).reason(reason).build();
    }

    public BanType getType();

    public Optional<Text> getReason();

    public Instant getCreationDate();

    public Optional<Text> getBanSource();

    public Optional<CommandSource> getBanCommandSource();

    public Optional<Instant> getExpirationDate();

    default public boolean isIndefinite() {
        return !this.getExpirationDate().isPresent();
    }

    public static interface Builder
    extends ResettableBuilder<Ban, Builder> {
        public Builder profile(GameProfile var1);

        public Builder address(InetAddress var1);

        public Builder type(BanType var1);

        public Builder reason(@Nullable Text var1);

        public Builder startDate(Instant var1);

        public Builder expirationDate(@Nullable Instant var1);

        public Builder source(@Nullable CommandSource var1);

        public Builder source(@Nullable Text var1);

        public Ban build();
    }

    public static interface Ip
    extends Ban {
        public InetAddress getAddress();
    }

    public static interface Profile
    extends Ban {
        public GameProfile getProfile();
    }
}

