/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.extent;

import com.flowpowered.math.imaginary.Quaterniond;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.property.AbstractProperty;
import org.spongepowered.api.data.property.entity.EyeLocationProperty;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.AABB;

public interface EntityUniverse {
    public Optional<Entity> getEntity(UUID var1);

    public Collection<Entity> getEntities();

    public Collection<Entity> getEntities(Predicate<Entity> var1);

    public Entity createEntity(EntityType var1, Vector3d var2) throws IllegalArgumentException, IllegalStateException;

    default public Entity createEntity(EntityType type, Vector3i position) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkNotNull((Object)position, (Object)"position");
        return this.createEntity(type, position.toDouble());
    }

    public Optional<Entity> createEntity(DataContainer var1);

    public Optional<Entity> createEntity(DataContainer var1, Vector3d var2);

    public Entity createEntityNaturally(EntityType var1, Vector3d var2) throws IllegalArgumentException, IllegalStateException;

    default public Entity createEntityNaturally(EntityType type, Vector3i position) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkNotNull((Object)position, (Object)"position");
        return this.createEntityNaturally(type, position.toDouble());
    }

    public Optional<Entity> restoreSnapshot(EntitySnapshot var1, Vector3d var2);

    public boolean spawnEntity(Entity var1, Cause var2);

    public boolean spawnEntities(Iterable<? extends Entity> var1, Cause var2);

    default public Set<Entity> getIntersectingEntities(AABB box) {
        return this.getIntersectingEntities(box, (Entity entity) -> true);
    }

    public Set<Entity> getIntersectingEntities(AABB var1, Predicate<Entity> var2);

    default public Set<EntityHit> getIntersectingEntities(Vector3d start, Vector3d end) {
        return this.getIntersectingEntities(start, end, (EntityHit hit) -> true);
    }

    public Set<EntityHit> getIntersectingEntities(Vector3d var1, Vector3d var2, Predicate<EntityHit> var3);

    default public Set<EntityHit> getIntersectingEntities(Entity looker, double distance) {
        return this.getIntersectingEntities(looker, distance, (EntityHit hit) -> true);
    }

    default public Set<EntityHit> getIntersectingEntities(Entity looker, double distance, Predicate<EntityHit> filter) {
        Preconditions.checkNotNull((Object)looker, (Object)"looker");
        Vector3d rotation = looker.getRotation();
        Vector3d direction = Quaterniond.fromAxesAnglesDeg(rotation.getX(), -rotation.getY(), rotation.getZ()).getDirection();
        Optional<EyeLocationProperty> data = looker.getProperty(EyeLocationProperty.class);
        Vector3d start = data.map(AbstractProperty::getValue).orElse(looker.getLocation().getPosition());
        return this.getIntersectingEntities(start, direction, distance, filter);
    }

    default public Set<EntityHit> getIntersectingEntities(Vector3d start, Vector3d direction, double distance) {
        return this.getIntersectingEntities(start, direction, distance, hit -> true);
    }

    public Set<EntityHit> getIntersectingEntities(Vector3d var1, Vector3d var2, double var3, Predicate<EntityHit> var5);

    public static class EntityHit {
        private final Entity entity;
        private final Vector3d intersection;
        private final Vector3d normal;
        private final double distance;

        public EntityHit(Entity entity, Vector3d intersection, Vector3d normal, double distance) {
            this.entity = (Entity)Preconditions.checkNotNull((Object)entity, (Object)"entity");
            this.intersection = (Vector3d)Preconditions.checkNotNull((Object)intersection, (Object)"intersection");
            this.normal = (Vector3d)Preconditions.checkNotNull((Object)normal, (Object)"normal");
            this.distance = distance;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public Vector3d getIntersection() {
            return this.intersection;
        }

        public Vector3d getNormal() {
            return this.normal;
        }

        public double getDistance() {
            return this.distance;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EntityHit)) {
                return false;
            }
            EntityHit entityHit = (EntityHit)other;
            return this.entity.equals(entityHit.entity) && this.intersection.equals(entityHit.intersection) && this.normal.equals(entityHit.normal) && this.distance == entityHit.distance;
        }

        public int hashCode() {
            int result = this.entity.hashCode();
            result = 31 * result + this.intersection.hashCode();
            result = 31 * result + this.normal.hashCode();
            result = 31 * result + Double.hashCode(this.distance);
            return result;
        }

        public String toString() {
            return "EntityHit(" + this.entity + " at " + this.intersection + " on " + this.normal + ")";
        }
    }
}

