/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapStorage;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.ItemDropData;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;

public final class SpongeImplHooks {
    public static boolean isVanilla() {
        return true;
    }

    public static boolean isDeobfuscatedEnvironment() {
        return true;
    }

    public static String getModIdFromClass(Class<?> clazz) {
        String className = clazz.getName();
        if (className.startsWith("net.minecraft.")) {
            return "minecraft";
        }
        if (className.startsWith("org.spongepowered.")) {
            return "sponge";
        }
        return "unknown";
    }

    public static boolean isCreatureOfType(Entity entity, EnumCreatureType type) {
        return type.func_75598_a().isAssignableFrom(entity.getClass());
    }

    public static boolean isFakePlayer(Entity entity) {
        return false;
    }

    public static void firePlayerJoinSpawnEvent(EntityPlayerMP playerMP) {
    }

    public static void handlePostChangeDimensionEvent(EntityPlayerMP playerIn, WorldServer fromWorld, WorldServer toWorld) {
    }

    public static boolean checkAttackEntity(EntityPlayer entityPlayer, Entity targetEntity) {
        return true;
    }

    public static double getBlockReachDistance(EntityPlayerMP player) {
        return 5.0;
    }

    @Nullable
    public static Class<? extends Entity> getEntityClass(ResourceLocation name) {
        return (Class)EntityList.field_191308_b.func_82594_a((Object)name);
    }

    @Nullable
    public static String getEntityTranslation(ResourceLocation name) {
        return EntityList.func_191302_a((ResourceLocation)name);
    }

    public static int getEntityId(Class<? extends Entity> entityClass) {
        return EntityList.field_191308_b.func_148757_b(entityClass);
    }

    public static boolean isBlockFlammable(Block block, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return Blocks.field_150480_ab.func_176532_c(block) > 0;
    }

    public static int getBlockLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_185891_c();
    }

    public static int getChunkPosLight(IBlockState blockState, World world, BlockPos pos) {
        return blockState.func_185906_d();
    }

    @Nullable
    public static TileEntity createTileEntity(Block block, World world, IBlockState state) {
        if (block instanceof ITileEntityProvider) {
            return ((ITileEntityProvider)block).func_149915_a(world, block.func_176201_c(state));
        }
        return null;
    }

    public static boolean hasBlockTileEntity(Block block, IBlockState state) {
        return block instanceof ITileEntityProvider;
    }

    public static boolean shouldRefresh(TileEntity tile, World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public static void onTileChunkUnload(TileEntity te) {
    }

    public static Iterator<Chunk> getChunkIterator(WorldServer world) {
        return world.func_184164_w().func_187300_b();
    }

    public static void registerPortalAgentType(@Nullable Teleporter teleporter) {
    }

    public static boolean canDoLightning(WorldProvider provider, Chunk chunk) {
        return true;
    }

    public static boolean canDoRainSnowIce(WorldProvider provider, Chunk chunk) {
        return true;
    }

    public static int getRespawnDimension(WorldProvider targetDimension, EntityPlayerMP player) {
        return 0;
    }

    public static BlockPos getRandomizedSpawnPoint(WorldServer world) {
        BlockPos ret = world.func_175694_M();
        boolean isAdventure = world.func_72912_H().func_76077_q() == GameType.ADVENTURE;
        int spawnFuzz = Math.max(0, world.func_73046_m().func_184108_a(world));
        int border = MathHelper.func_76128_c((double)world.func_175723_af().func_177729_b((double)ret.func_177958_n(), (double)ret.func_177952_p()));
        if (border < spawnFuzz) {
            spawnFuzz = border;
        }
        if (!world.field_73011_w.func_177495_o() && !isAdventure && spawnFuzz != 0) {
            if (spawnFuzz < 2) {
                spawnFuzz = 2;
            }
            int spawnFuzzHalf = spawnFuzz / 2;
            ret = world.func_175672_r(ret.func_177982_a(world.field_73012_v.nextInt(spawnFuzzHalf) - spawnFuzz, 0, world.field_73012_v.nextInt(spawnFuzzHalf) - spawnFuzz));
        }
        return ret;
    }

    public static void addItemStackToListForSpawning(Collection<ItemDropData> itemStacks, @Nullable ItemDropData itemStack) {
        if (itemStack != null) {
            itemStacks.add(itemStack);
        }
    }

    public static MapStorage getWorldMapStorage(World world) {
        return world.func_175693_T();
    }

    public static int countEntities(WorldServer worldServer, EnumCreatureType type, boolean forSpawnCount) {
        return worldServer.func_72907_a(type.func_75598_a());
    }

    public static int getMaxSpawnPackSize(EntityLiving entityLiving) {
        return entityLiving.func_70641_bl();
    }

    public static boolean canEntitySpawnHere(EntityLiving entityLiving, IEntityLivingData entityLivingData, boolean entityNotColliding) {
        if (entityLiving.func_70601_bi() && entityNotColliding) {
            entityLivingData = entityLiving.func_180482_a(entityLiving.field_70170_p.func_175649_E(new BlockPos((Entity)entityLiving)), entityLivingData);
            return true;
        }
        return false;
    }

    @Nullable
    public static Object onUtilRunTask(FutureTask<?> task, Logger logger) {
        CauseTracker causeTracker = CauseTracker.getInstance();
        causeTracker.switchToPhase(PluginPhase.State.SCHEDULED_TASK, PhaseContext.start().add(NamedCause.source(task)).addCaptures().complete());
        try {
            Object o = Util.func_181617_a(task, (Logger)logger);
            causeTracker.completePhase(PluginPhase.State.SCHEDULED_TASK);
            return o;
        }
        catch (Exception e) {
            causeTracker.abortCurrentPhase(e);
            return null;
        }
    }

    public static void onEntityError(Entity entity, CrashReport crashReport) {
        throw new ReportedException(crashReport);
    }

    public static void onTileEntityError(TileEntity tileEntity, CrashReport crashReport) {
        throw new ReportedException(crashReport);
    }

    public static void blockExploded(Block block, World world, BlockPos blockpos, Explosion explosion) {
        world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 2);
        block.func_180652_a(world, blockpos, explosion);
    }

    public static boolean isRestoringBlocks(World world) {
        return CauseTracker.getInstance().getCurrentState() == BlockPhase.State.RESTORING_BLOCKS;
    }

    public static void onTileEntityChunkUnload(TileEntity tileEntity) {
    }

    public static boolean canConnectRedstone(Block block, IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return state.func_185897_m() && side != null;
    }
}

