/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.boss;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import org.spongepowered.api.boss.BossBarColor;
import org.spongepowered.api.boss.BossBarOverlay;
import org.spongepowered.api.boss.ServerBossBar;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.text.SpongeTexts;

public final class ServerBossBarBuilder
implements ServerBossBar.Builder {
    @Nullable
    private Text name;
    private float percent;
    @Nullable
    private BossBarColor color;
    @Nullable
    private BossBarOverlay overlay;
    private boolean darkenSky;
    private boolean playEndBossMusic;
    private boolean createFog;
    private boolean visible = true;

    @Override
    public ServerBossBar.Builder name(Text name) {
        this.name = name;
        return this;
    }

    @Override
    public ServerBossBar.Builder percent(float percent) {
        Preconditions.checkArgument(((double)percent >= 0.0 && (double)percent <= 1.0 ? 1 : 0) != 0, (String)"percent must be between 0.0f and 1.0f (was %s)", (Object[])new Object[]{Float.valueOf(percent)});
        this.percent = percent;
        return this;
    }

    @Override
    public ServerBossBar.Builder color(BossBarColor color) {
        this.color = (BossBarColor)Preconditions.checkNotNull((Object)color, (Object)"color");
        return this;
    }

    @Override
    public ServerBossBar.Builder overlay(BossBarOverlay overlay) {
        this.overlay = (BossBarOverlay)Preconditions.checkNotNull((Object)overlay, (Object)"overlay");
        return this;
    }

    @Override
    public ServerBossBar.Builder darkenSky(boolean darkenSky) {
        this.darkenSky = darkenSky;
        return this;
    }

    @Override
    public ServerBossBar.Builder playEndBossMusic(boolean playEndBossMusic) {
        this.playEndBossMusic = playEndBossMusic;
        return this;
    }

    @Override
    public ServerBossBar.Builder createFog(boolean createFog) {
        this.createFog = createFog;
        return this;
    }

    @Override
    public ServerBossBar.Builder visible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    public ServerBossBar.Builder from(ServerBossBar value) {
        this.name = value.getName();
        this.percent = value.getPercent();
        this.color = value.getColor();
        this.overlay = value.getOverlay();
        this.darkenSky = value.shouldDarkenSky();
        this.playEndBossMusic = value.shouldPlayEndBossMusic();
        this.createFog = value.shouldCreateFog();
        this.visible = value.isVisible();
        return this;
    }

    @Override
    public ServerBossBar.Builder reset() {
        this.name = null;
        this.percent = 0.0f;
        this.color = null;
        this.overlay = null;
        this.darkenSky = false;
        this.playEndBossMusic = false;
        this.createFog = false;
        this.visible = true;
        return this;
    }

    @Override
    public ServerBossBar build() {
        Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"name must be set");
        Preconditions.checkState((this.color != null ? 1 : 0) != 0, (Object)"color must be set");
        Preconditions.checkState((this.overlay != null ? 1 : 0) != 0, (Object)"overlay must be set");
        BossInfoServer bar = new BossInfoServer(SpongeTexts.toComponent(this.name), (BossInfo.Color)this.color, (BossInfo.Overlay)this.overlay);
        bar.func_186735_a(this.percent);
        bar.func_186741_a(this.darkenSky);
        bar.func_186742_b(this.playEndBossMusic);
        bar.func_186743_c(this.createFog);
        bar.func_186758_d(this.visible);
        return (ServerBossBar)bar;
    }
}

