/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.inject.Singleton;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandManager;
import org.spongepowered.api.command.CommandMapping;
import org.spongepowered.api.command.CommandMessageFormatting;
import org.spongepowered.api.command.CommandPermissionException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.InvocationCommandException;
import org.spongepowered.api.command.dispatcher.Disambiguator;
import org.spongepowered.api.command.dispatcher.SimpleDispatcher;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.command.SendCommandEvent;
import org.spongepowered.api.event.command.TabCompleteEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.SpongeApiTranslationHelper;
import org.spongepowered.api.util.TextMessageException;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.command.MinecraftCommandWrapper;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;

@Singleton
public class SpongeCommandManager
implements CommandManager {
    private final Logger log;
    private final SimpleDispatcher dispatcher;
    private final Multimap<PluginContainer, CommandMapping> owners = HashMultimap.create();
    private final Map<CommandMapping, PluginContainer> reverseOwners = new ConcurrentHashMap<CommandMapping, PluginContainer>();
    private final Object lock = new Object();

    @Inject
    public SpongeCommandManager(Logger logger) {
        this(logger, SimpleDispatcher.FIRST_DISAMBIGUATOR);
    }

    public SpongeCommandManager(Logger logger, Disambiguator disambiguator) {
        this.log = logger;
        this.dispatcher = new SimpleDispatcher(disambiguator);
    }

    @Override
    public Optional<CommandMapping> register(Object plugin, CommandCallable callable, String ... alias) {
        return this.register(plugin, callable, Arrays.asList(alias));
    }

    @Override
    public Optional<CommandMapping> register(Object plugin, CommandCallable callable, List<String> aliases) {
        return this.register(plugin, callable, aliases, Function.identity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<CommandMapping> register(Object plugin, CommandCallable callable, List<String> aliases, Function<List<String>, List<String>> callback) {
        Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        Optional<PluginContainer> containerOptional = Sponge.getGame().getPluginManager().fromInstance(plugin);
        if (!containerOptional.isPresent()) {
            throw new IllegalArgumentException("The provided plugin object does not have an associated plugin container (in other words, is 'plugin' actually your plugin object?");
        }
        PluginContainer container = containerOptional.get();
        Object object = this.lock;
        synchronized (object) {
            ArrayList<String> aliasesWithPrefix = new ArrayList<String>(aliases.size() * 3);
            for (String alias : aliases) {
                if (alias.contains(" ")) {
                    throw new IllegalArgumentException("Plugin '" + container.getId() + "' attempted to register an alias ('" + alias + "') which contained a space.");
                }
                Collection ownedCommands = this.owners.get((Object)container);
                for (CommandMapping mapping : this.dispatcher.getAll(alias)) {
                    boolean isWrapper;
                    if (!ownedCommands.contains(mapping) || (isWrapper = callable instanceof MinecraftCommandWrapper) && ((MinecraftCommandWrapper)callable).suppressDuplicateAlias(alias)) continue;
                    throw new IllegalArgumentException("A plugin may not register multiple commands for the same alias ('" + alias + "')!");
                }
                aliasesWithPrefix.add(alias);
                aliasesWithPrefix.add(container.getId() + ':' + alias);
            }
            Optional<CommandMapping> mapping = this.dispatcher.register(callable, aliasesWithPrefix, callback);
            if (mapping.isPresent()) {
                this.owners.put((Object)container, (Object)mapping.get());
                this.reverseOwners.put(mapping.get(), container);
            }
            return mapping;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<CommandMapping> removeMapping(CommandMapping mapping) {
        Object object = this.lock;
        synchronized (object) {
            Optional<CommandMapping> removed = this.dispatcher.removeMapping(mapping);
            if (removed.isPresent()) {
                this.forgetMapping(removed.get());
            }
            return removed;
        }
    }

    private void forgetMapping(CommandMapping mapping) {
        Iterator it = this.owners.values().iterator();
        while (it.hasNext()) {
            if (!((CommandMapping)it.next()).equals(mapping)) continue;
            it.remove();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PluginContainer> getPluginContainers() {
        Object object = this.lock;
        synchronized (object) {
            return ImmutableSet.copyOf((Collection)this.owners.keySet());
        }
    }

    public Set<CommandMapping> getCommands() {
        return this.dispatcher.getCommands();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<CommandMapping> getOwnedBy(Object instance) {
        Optional<PluginContainer> container = Sponge.getGame().getPluginManager().fromInstance(instance);
        if (!container.isPresent()) {
            throw new IllegalArgumentException("The provided plugin object does not have an associated plugin container (in other words, is 'plugin' actually your plugin object?)");
        }
        Object object = this.lock;
        synchronized (object) {
            return ImmutableSet.copyOf((Collection)this.owners.get((Object)container.get()));
        }
    }

    @Override
    public Optional<PluginContainer> getOwner(CommandMapping mapping) {
        return Optional.ofNullable(this.reverseOwners.get(Preconditions.checkNotNull((Object)mapping, (Object)"mapping")));
    }

    @Override
    public Set<String> getPrimaryAliases() {
        return this.dispatcher.getPrimaryAliases();
    }

    @Override
    public Set<String> getAliases() {
        return this.dispatcher.getAliases();
    }

    public Optional<CommandMapping> get(String alias) {
        return this.dispatcher.get(alias);
    }

    @Override
    public Optional<? extends CommandMapping> get(String alias, @Nullable CommandSource source) {
        return this.dispatcher.get(alias, source);
    }

    @Override
    public Set<? extends CommandMapping> getAll(String alias) {
        return this.dispatcher.getAll(alias);
    }

    @Override
    public Multimap<String, CommandMapping> getAll() {
        return this.dispatcher.getAll();
    }

    @Override
    public boolean containsAlias(String alias) {
        return this.dispatcher.containsAlias(alias);
    }

    @Override
    public boolean containsMapping(CommandMapping mapping) {
        return this.dispatcher.containsMapping(mapping);
    }

    @Override
    public CommandResult process(CommandSource source, String commandLine) {
        String[] argSplit = commandLine.split(" ", 2);
        SendCommandEvent event = SpongeEventFactory.createSendCommandEvent(Cause.of(NamedCause.source(source)), argSplit.length > 1 ? argSplit[1] : "", argSplit[0], CommandResult.empty());
        Sponge.getGame().getEventManager().post(event);
        if (event.isCancelled()) {
            return event.getResult();
        }
        argSplit[0] = event.getCommand();
        commandLine = event.getCommand();
        if (!event.getArguments().isEmpty()) {
            commandLine = commandLine + ' ' + event.getArguments();
        }
        try {
            try {
                if (CauseTracker.ENABLED && SpongeImpl.getServer().func_152345_ab()) {
                    CauseTracker.getInstance().switchToPhase(GeneralPhase.State.COMMAND, PhaseContext.start().add(NamedCause.source(source)).addCaptures().addEntityDropCaptures().complete());
                }
                CommandResult result = this.dispatcher.process(source, commandLine);
                this.completeCommandPhase();
                return result;
            }
            catch (InvocationCommandException ex) {
                this.completeCommandPhase();
                if (ex.getCause() != null) {
                    throw ex.getCause();
                }
            }
            catch (CommandPermissionException ex) {
                this.completeCommandPhase();
                Text text = ex.getText();
                if (text != null) {
                    source.sendMessage(CommandMessageFormatting.error(text));
                }
            }
            catch (CommandException ex) {
                Optional<CommandMapping> mapping;
                this.completeCommandPhase();
                Text text = ex.getText();
                if (text != null) {
                    source.sendMessage(CommandMessageFormatting.error(text));
                }
                if (ex.shouldIncludeUsage() && (mapping = this.dispatcher.get(argSplit[0], source)).isPresent()) {
                    source.sendMessage(CommandMessageFormatting.error(SpongeApiTranslationHelper.t("Usage: /%s %s", argSplit[0], mapping.get().getCallable().getUsage(source))));
                }
            }
        }
        catch (Throwable thr) {
            Text text;
            this.completeCommandPhase();
            Text.Builder excBuilder = thr instanceof TextMessageException ? ((text = ((TextMessageException)thr).getText()) == null ? Text.builder("null") : Text.builder()) : Text.builder(String.valueOf(thr.getMessage()));
            if (source.hasPermission("sponge.debug.hover-stacktrace")) {
                StringWriter writer = new StringWriter();
                thr.printStackTrace(new PrintWriter(writer));
                excBuilder.onHover(TextActions.showText(Text.of(writer.toString().replace("\t", "    ").replace("\r\n", "\n").replace("\r", "\n"))));
            }
            source.sendMessage(CommandMessageFormatting.error(SpongeApiTranslationHelper.t("Error occurred while executing command: %s", excBuilder.build())));
            this.log.error(TextSerializers.PLAIN.serialize(SpongeApiTranslationHelper.t("Error occurred while executing command '%s' for source %s: %s", commandLine, source.toString(), String.valueOf(thr.getMessage()))), thr);
        }
        return CommandResult.empty();
    }

    @Override
    public List<String> getSuggestions(CommandSource src, String arguments, @Nullable Location<World> targetPosition) {
        return this.getSuggestions(src, arguments, targetPosition, false);
    }

    public List<String> getSuggestions(CommandSource src, String arguments, @Nullable Location<World> targetPosition, boolean usingBlock) {
        try {
            String[] argSplit = arguments.split(" ", 2);
            ArrayList<String> suggestions = new ArrayList<String>(this.dispatcher.getSuggestions(src, arguments, targetPosition));
            TabCompleteEvent.Command event = SpongeEventFactory.createTabCompleteEventCommand(Cause.source(src).build(), (List)ImmutableList.copyOf(suggestions), suggestions, argSplit.length > 1 ? argSplit[1] : "", argSplit[0], arguments, Optional.ofNullable(targetPosition), usingBlock);
            Sponge.getGame().getEventManager().post(event);
            if (event.isCancelled()) {
                return ImmutableList.of();
            }
            return ImmutableList.copyOf(event.getTabCompletions());
        }
        catch (Exception e) {
            if (e instanceof CommandException) {
                src.sendMessage(CommandMessageFormatting.error(SpongeApiTranslationHelper.t("Error getting suggestions: %s", ((CommandException)e).getText())));
                return Collections.emptyList();
            }
            throw new RuntimeException(String.format("Error occured while tab completing '%s'", arguments), e);
        }
    }

    @Override
    public boolean testPermission(CommandSource source) {
        return this.dispatcher.testPermission(source);
    }

    @Override
    public Optional<Text> getShortDescription(CommandSource source) {
        return this.dispatcher.getShortDescription(source);
    }

    @Override
    public Optional<Text> getHelp(CommandSource source) {
        return this.dispatcher.getHelp(source);
    }

    @Override
    public Text getUsage(CommandSource source) {
        return this.dispatcher.getUsage(source);
    }

    @Override
    public int size() {
        return this.dispatcher.size();
    }

    private void completeCommandPhase() {
        if (CauseTracker.ENABLED && SpongeImpl.getServer().func_152345_ab()) {
            CauseTracker.getInstance().completePhase(GeneralPhase.State.COMMAND);
        }
    }
}

