/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.data.DataManager;
import org.spongepowered.api.data.DataRegistration;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.ImmutableDataBuilder;
import org.spongepowered.api.data.ImmutableDataHolder;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.DataSerializableTypeSerializer;
import org.spongepowered.common.data.DataUpdaterDelegate;
import org.spongepowered.common.data.SpongeDataRegistration;
import org.spongepowered.common.data.SpongeDataRegistrationBuilder;
import org.spongepowered.common.data.SpongeManipulatorRegistry;
import org.spongepowered.common.data.builder.manipulator.SpongeDataManipulatorBuilder;
import org.spongepowered.common.data.builder.manipulator.SpongeImmutableDataManipulatorBuilder;
import org.spongepowered.common.data.persistence.DataTranslatorTypeSerializer;
import org.spongepowered.common.data.util.ComparatorUtil;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.registry.type.data.DataTranslatorRegistryModule;

@Singleton
public final class SpongeDataManager
implements DataManager {
    private static final TypeToken<CatalogType> catalogTypeToken = TypeToken.of(CatalogType.class);
    private static final TypeToken<DataSerializable> dataSerializableTypeToken = TypeToken.of(DataSerializable.class);
    private final Map<Class<?>, DataBuilder<?>> builders = Maps.newHashMap();
    final Map<Class<? extends DataManipulator<?, ?>>, DataManipulatorBuilder<?, ?>> builderMap = new MapMaker().concurrencyLevel(4).makeMap();
    private final Map<Class<? extends ImmutableDataManipulator<?, ?>>, DataManipulatorBuilder<?, ?>> immutableBuilderMap = new MapMaker().concurrencyLevel(4).makeMap();
    private final Map<Class<? extends ImmutableDataHolder<?>>, ImmutableDataBuilder<?, ?>> immutableDataBuilderMap = new MapMaker().concurrencyLevel(4).makeMap();
    private final Map<Class<?>, DataTranslator<?>> dataSerializerMap = new MapMaker().concurrencyLevel(4).makeMap();
    private final Map<Class<? extends DataSerializable>, List<DataContentUpdater>> updatersMap = new IdentityHashMap<Class<? extends DataSerializable>, List<DataContentUpdater>>();
    static boolean allowRegistrations;

    public static SpongeDataManager getInstance() {
        return SpongeImpl.getDataManager();
    }

    @Inject
    private SpongeDataManager() {
    }

    @Override
    public <T extends DataSerializable> void registerBuilder(Class<T> clazz, DataBuilder<T> builder) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(builder);
        if (!this.builders.containsKey(clazz)) {
            if (!(builder instanceof AbstractDataBuilder || builder instanceof SpongeDataManipulatorBuilder || builder instanceof SpongeImmutableDataManipulatorBuilder)) {
                SpongeImpl.getLogger().warn("A custom DataBuilder is not extending AbstractDataBuilder! It is recommended that the custom data builder does extend it to gain automated content versioning updates and maintain simplicity. The offending builder's class is: {}", new Object[]{builder.getClass()});
            }
            this.builders.put(clazz, builder);
        } else {
            SpongeImpl.getLogger().warn("A DataBuilder has already been registered for {}. Attempted to register {} instead.", new Object[]{clazz, builder.getClass()});
        }
    }

    @Override
    public <T extends DataSerializable> void registerContentUpdater(Class<T> clazz, DataContentUpdater updater) {
        Preconditions.checkNotNull((Object)updater, (Object)"DataContentUpdater was null!");
        if (!this.updatersMap.containsKey(Preconditions.checkNotNull(clazz, (Object)"DataSerializable class was null!"))) {
            this.updatersMap.put(clazz, new ArrayList());
        }
        List<DataContentUpdater> updaters = this.updatersMap.get(clazz);
        updaters.add(updater);
        Collections.sort(updaters, ComparatorUtil.DATA_CONTENT_UPDATER_COMPARATOR);
    }

    @Override
    public <T extends DataSerializable> Optional<DataContentUpdater> getWrappedContentUpdater(Class<T> clazz, int fromVersion, int toVersion) {
        Preconditions.checkArgument((fromVersion != toVersion ? 1 : 0) != 0, (Object)"Attempting to convert to the same version!");
        Preconditions.checkArgument((fromVersion < toVersion ? 1 : 0) != 0, (Object)"Attempting to backwards convert data! This isn't supported!");
        List<DataContentUpdater> updaters = this.updatersMap.get(Preconditions.checkNotNull(clazz, (Object)"DataSerializable class was null!"));
        if (updaters == null) {
            return Optional.empty();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int version = fromVersion;
        for (DataContentUpdater updater : updaters) {
            if (updater.getInputVersion() != version || updater.getOutputVersion() > toVersion) continue;
            version = updater.getOutputVersion();
            builder.add((Object)updater);
        }
        if (version < toVersion || version > toVersion) {
            IllegalStateException e = new IllegalStateException("The requested content version for: " + clazz.getSimpleName() + " was requested, \nhowever, the versions supplied: from " + fromVersion + " to " + toVersion + " is impossible\nas the latest version registered is: " + version + ". Please notify the developer of\nthe requested consumed DataSerializable of this error.");
            e.printStackTrace();
            return Optional.empty();
        }
        return Optional.of(new DataUpdaterDelegate((ImmutableList<DataContentUpdater>)builder.build(), fromVersion, toVersion));
    }

    public <T extends DataSerializable> void registerBuilderAndImpl(Class<T> clazz, Class<? extends T> implClass, DataBuilder<T> builder) {
        this.registerBuilder(clazz, builder);
        this.registerBuilder(implClass, builder);
    }

    @Override
    public <T extends DataSerializable> Optional<DataBuilder<T>> getBuilder(Class<T> clazz) {
        Preconditions.checkNotNull(clazz);
        if (this.builders.containsKey(clazz)) {
            return Optional.of(this.builders.get(clazz));
        }
        if (this.builderMap.containsKey(clazz)) {
            return Optional.of((DataBuilder)this.builderMap.get(clazz));
        }
        if (this.immutableDataBuilderMap.containsKey(clazz)) {
            return Optional.of((DataBuilder)this.immutableDataBuilderMap.get(clazz));
        }
        return Optional.empty();
    }

    @Override
    public <T extends DataSerializable> Optional<T> deserialize(Class<T> clazz, DataView dataView) {
        Optional<DataBuilder<DataBuilder>> optional = this.getBuilder(clazz);
        return optional.flatMap(tDataBuilder -> tDataBuilder.build(dataView));
    }

    @Override
    public <T extends ImmutableDataHolder<T>, B extends ImmutableDataBuilder<T, B>> void register(Class<T> holderClass, B builder) {
        if (this.immutableDataBuilderMap.containsKey(Preconditions.checkNotNull(holderClass))) {
            throw new IllegalStateException("Already registered the DataUtil for " + holderClass.getCanonicalName());
        }
        this.immutableDataBuilderMap.put((Class<ImmutableDataHolder<?>>)holderClass, (ImmutableDataBuilder<?, ?>)Preconditions.checkNotNull(builder));
    }

    @Override
    public <T extends ImmutableDataHolder<T>, B extends ImmutableDataBuilder<T, B>> Optional<B> getImmutableBuilder(Class<T> holderClass) {
        return Optional.ofNullable(this.immutableDataBuilderMap.get(Preconditions.checkNotNull(holderClass)));
    }

    public static void finalizeRegistration() {
        allowRegistrations = false;
        SpongeManipulatorRegistry.getInstance().bake();
    }

    @Override
    public <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> void register(Class<? extends T> manipulatorClass, Class<? extends I> immutableManipulatorClass, DataManipulatorBuilder<T, I> builder) {
        Preconditions.checkState((boolean)allowRegistrations, (Object)"Registrations are no longer allowed!");
        Optional<PluginContainer> activeContainer = CauseTracker.getInstance().getCurrentContext().getActiveContainer();
        if (!activeContainer.isPresent()) {
            new PrettyPrinter(60).centre().add("Unknown Plugin registering custom data!").hr().addWrapped("Sponge's Custom Data system must know what plugin container is registeringwhat custom data to assign a \"legacy\" id for the custom data! It is notrecommended for developers to continue using the old registration methodsas they will be removed in future API versions! Please notify the developerof the offending plugin to update!", new Object[0]).addWrapped("Since the plugin id cannot be determined, custom data will not be registered! The following custom data was attempted", new Object[0]).add("%s : %s", "DataManipulator", manipulatorClass.getName()).add("%s : %s", "ImmutableManipulator", immutableManipulatorClass.getName()).add("%s : %s", "ManipulatorBuilder", builder.getClass().getName()).add(new Exception()).trace();
            return;
        }
        SpongeImpl.getLogger().log(Level.WARN, "Detected $1 being registered with the old way! Please notify the developer", new Object[]{builder});
        String manipulatorSimpleNamePriorToProcessing = manipulatorClass.getSimpleName().replace("data", "").replace("Data", "");
        String generatedManipulatorId = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, manipulatorSimpleNamePriorToProcessing);
        PluginContainer pluginContainer = activeContainer.get();
        String finalId = pluginContainer.getId() + ":" + generatedManipulatorId;
        new PrettyPrinter(60).add("Legacy Data Registration").centre().hr().addWrapped("Sponge's Custom Data Registration is changing! Plugin developers are strongly advised to update their data registrations!However, because of this, Sponge is automatically applying an upgrade policy for their old registrations that will persistuntil an unknown future time. Likely for the next few Minecraft versions.", new Object[0]).hr().add("%s: %s", "Plugin registering custom data", pluginContainer.getId()).add("%s: %s", "Custom Data Class", manipulatorClass.getSimpleName()).add("%s: %s", "Generated id to use for registration", generatedManipulatorId).addWrapped(60, "This generated id is what the developer should use provided their plugin id has not changed.", new Object[0]).add("%s: %s", "Generated Manipulator Id", finalId).addWrapped("The generated Id is already registered with Sponge, and is likely advisable for the plugin developer to utilizethe id for future registrations.", new Object[0]).trace();
        DataRegistration<? extends T, ? extends I> registration = DataRegistration.builder().dataClass(manipulatorClass).immutableClass(immutableManipulatorClass).manipulatorId(generatedManipulatorId).dataName(manipulatorSimpleNamePriorToProcessing).builder(builder).buildAndRegister(pluginContainer);
        SpongeManipulatorRegistry.getInstance().registerLegacyId(registration);
    }

    @Override
    public void registerLegacyManipulatorIds(String legacyId, DataRegistration<?, ?> registration) {
        Preconditions.checkState((boolean)allowRegistrations);
        SpongeManipulatorRegistry.getInstance().registerLegacyId(legacyId, registration);
    }

    public <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> void register(DataRegistration<T, I> registration) {
        Preconditions.checkState((boolean)allowRegistrations, (Object)"Registrations are no longer allowed!");
        Class<T> manipulatorClass = registration.getManipulatorClass();
        Class<I> immutableManipulatorClass = registration.getImmutableManipulatorClass();
        DataManipulatorBuilder<T, I> builder = registration.getDataManipulatorBuilder();
        String manipulatorId = registration.getId();
        PluginContainer pluginContainer = registration.getPluginContainer();
        String pluginId = pluginContainer.getId().toLowerCase();
    }

    @Override
    public <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> Optional<DataManipulatorBuilder<T, I>> getManipulatorBuilder(Class<T> manipulatorClass) {
        return Optional.ofNullable(this.builderMap.get(Preconditions.checkNotNull(manipulatorClass)));
    }

    @Override
    public <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> Optional<DataManipulatorBuilder<T, I>> getImmutableManipulatorBuilder(Class<I> immutableManipulatorClass) {
        return Optional.ofNullable(this.immutableBuilderMap.get(Preconditions.checkNotNull(immutableManipulatorClass)));
    }

    @Override
    public <T> void registerTranslator(Class<T> objectClass, DataTranslator<T> translator) {
        Preconditions.checkState((boolean)allowRegistrations, (Object)"Registrations are no longer allowed");
        Preconditions.checkNotNull(objectClass, (Object)"Target object class cannot be null!");
        Preconditions.checkNotNull(translator, (Object)("DataTranslator for : " + objectClass + " cannot be null!"));
        Preconditions.checkArgument((boolean)translator.getToken().isAssignableFrom(objectClass), (Object)("DataTranslator is not compatible with the target object class: " + objectClass));
        if (this.dataSerializerMap.containsKey(Preconditions.checkNotNull(objectClass, (Object)"Target class cannot be null!"))) {
            throw new IllegalStateException("Already registered the DataTranslator for " + objectClass.getCanonicalName());
        }
        this.dataSerializerMap.put(objectClass, translator);
        DataTranslatorRegistryModule.getInstance().registerAdditionalCatalog(translator);
        if (TypeSerializers.getDefaultSerializers().get(translator.getToken()) == null) {
            TypeSerializers.getDefaultSerializers().registerType(translator.getToken(), DataTranslatorTypeSerializer.from(translator));
        }
    }

    @Override
    public <T> Optional<DataTranslator<T>> getTranslator(Class<T> objectclass) {
        return Optional.ofNullable(this.dataSerializerMap.get(Preconditions.checkNotNull(objectclass, (Object)"Target class cannot be null!")));
    }

    @Override
    public Collection<Class<? extends DataManipulator<?, ?>>> getAllRegistrationsFor(PluginContainer container) {
        return SpongeManipulatorRegistry.getInstance().getRegistrations(container);
    }

    public Optional<DataManipulatorBuilder<?, ?>> getWildManipulatorBuilder(Class<? extends DataManipulator<?, ?>> manipulatorClass) {
        return Optional.ofNullable(this.builderMap.get(Preconditions.checkNotNull(manipulatorClass)));
    }

    public Optional<DataManipulatorBuilder<?, ?>> getWildBuilderForImmutable(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return Optional.ofNullable(this.immutableBuilderMap.get(Preconditions.checkNotNull(immutable)));
    }

    public <M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>> void validateRegistration(SpongeDataRegistrationBuilder<M, I> builder) {
        Preconditions.checkState((boolean)allowRegistrations);
        Class manipulatorClass = builder.manipulatorClass;
        Class immutableClass = builder.immutableClass;
        DataManipulatorBuilder manipulatorBuilder = builder.manipulatorBuilder;
        Preconditions.checkState((!this.builders.containsKey(manipulatorClass) ? 1 : 0) != 0, (Object)"DataManipulator already registered!");
        Preconditions.checkState((!this.builderMap.containsKey(manipulatorClass) ? 1 : 0) != 0, (Object)"DataManipulator already registered!");
        Preconditions.checkState((!this.builderMap.containsValue(manipulatorBuilder) ? 1 : 0) != 0, (Object)"DataManipulatorBuilder already registered!");
        Preconditions.checkState((!this.builders.containsKey(immutableClass) ? 1 : 0) != 0, (Object)"ImmutableDataManipulator already registered!");
        Preconditions.checkState((!this.immutableBuilderMap.containsKey(immutableClass) ? 1 : 0) != 0, (Object)"ImmutableDataManipulator already registered!");
        Preconditions.checkState((!this.immutableBuilderMap.containsValue(manipulatorBuilder) ? 1 : 0) != 0, (Object)"DataManipulatorBuilder already registered!");
    }

    public static boolean areRegistrationsComplete() {
        return !allowRegistrations;
    }

    public <M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>> void registerInternally(SpongeDataRegistration<M, I> registration) {
        this.builders.put(registration.getManipulatorClass(), registration.getDataManipulatorBuilder());
        this.builderMap.put(registration.getManipulatorClass(), registration.getDataManipulatorBuilder());
        this.immutableBuilderMap.put(registration.getImmutableManipulatorClass(), registration.getDataManipulatorBuilder());
    }

    static {
        TypeSerializers.getDefaultSerializers().registerPredicate(x -> dataSerializableTypeToken.isAssignableFrom(x) && !catalogTypeToken.isAssignableFrom(x), new DataSerializableTypeSerializer());
        allowRegistrations = true;
    }
}

