/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.spongepowered.api.data.DataRegistration;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.data.SpongeDataRegistrationBuilder;

public final class SpongeDataRegistration<M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
implements DataRegistration<M, I>,
Comparable<SpongeDataRegistration<?, ?>> {
    private final Class<M> manipulatorClass;
    private final Class<I> immutableClass;
    private final DataManipulatorBuilder<M, I> manipulatorBuilder;
    private final PluginContainer container;
    private final String id;
    private final String name;

    SpongeDataRegistration(SpongeDataRegistrationBuilder<M, I> builder) {
        this.manipulatorClass = (Class)Preconditions.checkNotNull(builder.manipulatorClass, (Object)"DataManipulator class is null!");
        this.immutableClass = (Class)Preconditions.checkNotNull(builder.immutableClass, (Object)"ImmutableDataManipulator class is null!");
        this.manipulatorBuilder = (DataManipulatorBuilder)Preconditions.checkNotNull(builder.manipulatorBuilder, (Object)"DataManipulatorBuilder is null!");
        this.container = (PluginContainer)Preconditions.checkNotNull((Object)builder.container, (Object)"PluginContainer is null!");
        this.id = this.container.getId() + ":" + (String)Preconditions.checkNotNull((Object)builder.id, (Object)"Data ID is null!");
        this.name = (String)Preconditions.checkNotNull((Object)builder.name, (Object)"Data name is null!");
    }

    @Override
    public Class<M> getManipulatorClass() {
        return this.manipulatorClass;
    }

    @Override
    public Class<I> getImmutableManipulatorClass() {
        return this.immutableClass;
    }

    @Override
    public DataManipulatorBuilder<M, I> getDataManipulatorBuilder() {
        return this.manipulatorBuilder;
    }

    @Override
    public PluginContainer getPluginContainer() {
        return this.container;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeDataRegistration that = (SpongeDataRegistration)o;
        return Objects.equal(this.manipulatorClass, that.manipulatorClass) && Objects.equal(this.immutableClass, that.immutableClass) && Objects.equal(this.manipulatorBuilder, that.manipulatorBuilder) && Objects.equal((Object)this.container, (Object)that.container) && Objects.equal((Object)this.id, (Object)that.id);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.manipulatorClass, this.immutableClass, this.manipulatorBuilder, this.container, this.id});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("manipulatorClass", this.manipulatorClass).add("immutableClass", this.immutableClass).add("manipulatorBuilder", this.manipulatorBuilder).add("container", (Object)this.container).toString();
    }

    @Override
    public int compareTo(SpongeDataRegistration<?, ?> o) {
        return this.getId().compareTo(o.getId());
    }
}

