/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.manipulator.immutable.item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.ImmutableDataHolder;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulatorBuilder;
import org.spongepowered.api.data.manipulator.immutable.item.ImmutableEnchantmentData;
import org.spongepowered.api.data.manipulator.mutable.item.EnchantmentData;
import org.spongepowered.api.data.meta.ItemEnchantment;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.common.data.manipulator.immutable.item.ImmutableSpongeEnchantmentData;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.data.util.NbtDataUtil;

public class ImmutableItemEnchantmentDataBuilder
extends AbstractDataBuilder<ImmutableEnchantmentData>
implements ImmutableDataManipulatorBuilder<ImmutableEnchantmentData, EnchantmentData> {
    public ImmutableItemEnchantmentDataBuilder() {
        super(ImmutableEnchantmentData.class, 1);
    }

    @Override
    public ImmutableEnchantmentData createImmutable() {
        return new ImmutableSpongeEnchantmentData((List<ItemEnchantment>)ImmutableList.of());
    }

    @Override
    public Optional<ImmutableEnchantmentData> createFrom(DataHolder dataHolder) {
        if (dataHolder instanceof ItemStack) {
            if (!((ItemStack)dataHolder).func_77948_v()) {
                return Optional.empty();
            }
            List<ItemEnchantment> enchantments = NbtDataUtil.getItemEnchantments((ItemStack)dataHolder);
            return Optional.of(new ImmutableSpongeEnchantmentData(enchantments));
        }
        return Optional.empty();
    }

    @Override
    public Optional<ImmutableEnchantmentData> createFrom(ImmutableDataHolder<?> dataHolder) {
        return Optional.empty();
    }

    @Override
    public ImmutableItemEnchantmentDataBuilder reset() {
        return this;
    }

    @Override
    protected Optional<ImmutableEnchantmentData> buildContent(DataView container) throws InvalidDataException {
        DataUtil.checkDataExists(container, Keys.ITEM_ENCHANTMENTS.getQuery());
        List<ItemEnchantment> enchantments = container.getSerializableList(Keys.ITEM_ENCHANTMENTS.getQuery(), ItemEnchantment.class).get();
        return Optional.of(new ImmutableSpongeEnchantmentData(enchantments));
    }
}

