/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableAgeableData;
import org.spongepowered.api.data.manipulator.mutable.entity.AgeableData;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeAgeableData;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class ImmutableSpongeAgeableData
extends AbstractImmutableData<ImmutableAgeableData, AgeableData>
implements ImmutableAgeableData {
    private int age;
    private boolean adult;
    private final ImmutableBoundedValue<Integer> ageValue;

    public ImmutableSpongeAgeableData(int age, boolean adult) {
        super(ImmutableAgeableData.class);
        this.age = age;
        this.adult = adult;
        this.ageValue = SpongeValueFactory.boundedBuilder(Keys.AGE).actualValue(this.age).defaultValue(0).minimum(Integer.MIN_VALUE).maximum(Integer.MAX_VALUE).build().asImmutable();
        this.registerGetters();
    }

    @Override
    public AgeableData asMutable() {
        return new SpongeAgeableData(this.age, this.adult);
    }

    @Override
    public ImmutableBoundedValue<Integer> age() {
        return this.ageValue;
    }

    @Override
    public ImmutableValue<Boolean> baby() {
        return ImmutableSpongeValue.cachedOf(Keys.IS_BABY, false, !this.adult);
    }

    @Override
    public ImmutableValue<Boolean> adult() {
        return ImmutableSpongeValue.cachedOf(Keys.IS_ADULT, true, this.adult);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.AGE, (Object)this.age).set(Keys.IS_ADULT, (Object)this.adult);
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.AGE, this::getAge);
        this.registerKeyValue(Keys.AGE, this::age);
        this.registerFieldGetter(Keys.IS_ADULT, this::isAdult);
        this.registerKeyValue(Keys.IS_ADULT, this::adult);
    }

    public int getAge() {
        return this.age;
    }

    public boolean isAdult() {
        return this.adult;
    }
}

