/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable;

import com.google.common.collect.Multimap;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableRepresentedPlayerData;
import org.spongepowered.api.data.manipulator.mutable.RepresentedPlayerData;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.property.ProfileProperty;
import org.spongepowered.common.data.manipulator.immutable.ImmutableSpongeRepresentedPlayerData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractSingleData;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SpongeRepresentedPlayerData
extends AbstractSingleData<GameProfile, RepresentedPlayerData, ImmutableRepresentedPlayerData>
implements RepresentedPlayerData {
    public static final GameProfile NULL_PROFILE = new GameProfile(){

        @Override
        public UUID getUniqueId() {
            return null;
        }

        @Override
        public int getContentVersion() {
            return 0;
        }

        @Override
        public DataContainer toContainer() {
            return DataContainer.createNew();
        }

        @Override
        public Optional<String> getName() {
            return Optional.empty();
        }

        @Override
        public Multimap<String, ProfileProperty> getPropertyMap() {
            return null;
        }

        @Override
        public boolean isFilled() {
            return false;
        }
    };

    public SpongeRepresentedPlayerData() {
        this(NULL_PROFILE);
    }

    public SpongeRepresentedPlayerData(GameProfile profile) {
        super(RepresentedPlayerData.class, profile, Keys.REPRESENTED_PLAYER);
    }

    @Override
    public Value<GameProfile> owner() {
        return new SpongeValue<GameProfile>(this.usedKey, (GameProfile)this.getValue());
    }

    @Override
    public RepresentedPlayerData copy() {
        return new SpongeRepresentedPlayerData((GameProfile)this.getValue());
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = super.toContainer();
        if (((GameProfile)this.getValue()).getUniqueId() != null) {
            container.set(this.usedKey.getQuery().then(DataQueries.GAME_PROFILE_ID), (Object)((GameProfile)this.getValue()).getUniqueId().toString());
        }
        if (((GameProfile)this.getValue()).getName().isPresent()) {
            container.set(this.usedKey.getQuery().then(DataQueries.GAME_PROFILE_NAME), (Object)((GameProfile)this.getValue()).getName().get());
        }
        return container;
    }

    @Override
    protected Value<?> getValueGetter() {
        return this.owner();
    }

    @Override
    public ImmutableRepresentedPlayerData asImmutable() {
        return new ImmutableSpongeRepresentedPlayerData((GameProfile)this.getValue());
    }
}

