/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import com.google.common.base.Preconditions;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableHorseData;
import org.spongepowered.api.data.manipulator.mutable.entity.HorseData;
import org.spongepowered.api.data.type.HorseColor;
import org.spongepowered.api.data.type.HorseColors;
import org.spongepowered.api.data.type.HorseStyle;
import org.spongepowered.api.data.type.HorseStyles;
import org.spongepowered.api.data.type.HorseVariant;
import org.spongepowered.api.data.type.HorseVariants;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeHorseData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.util.DataConstants;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SpongeHorseData
extends AbstractData<HorseData, ImmutableHorseData>
implements HorseData {
    private HorseColor horseColor;
    private HorseStyle horseStyle;
    private HorseVariant horseVariant;

    public SpongeHorseData(HorseColor horseColor, HorseStyle horseStyle, HorseVariant horseVariant) {
        super(HorseData.class);
        this.horseColor = (HorseColor)Preconditions.checkNotNull((Object)horseColor, (Object)"The Horse Color was null!");
        this.horseStyle = (HorseStyle)Preconditions.checkNotNull((Object)horseStyle, (Object)"The Horse Style was null!");
        this.horseVariant = (HorseVariant)Preconditions.checkNotNull((Object)horseVariant, (Object)"The Horse Variant was null!");
        this.registerGettersAndSetters();
    }

    public SpongeHorseData() {
        this(HorseColors.WHITE, HorseStyles.NONE, HorseVariants.HORSE);
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.HORSE_COLOR, this::getHorseColor);
        this.registerFieldSetter(Keys.HORSE_COLOR, this::setHorseColor);
        this.registerKeyValue(Keys.HORSE_COLOR, this::color);
        this.registerFieldGetter(Keys.HORSE_STYLE, this::getHorseStyle);
        this.registerFieldSetter(Keys.HORSE_STYLE, this::setHorseStyle);
        this.registerKeyValue(Keys.HORSE_STYLE, this::style);
        this.registerFieldGetter(Keys.HORSE_VARIANT, this::getHorseVariant);
        this.registerFieldSetter(Keys.HORSE_VARIANT, this::setHorseVariant);
        this.registerKeyValue(Keys.HORSE_VARIANT, this::variant);
    }

    @Override
    public Value<HorseColor> color() {
        return new SpongeValue<HorseColor>(Keys.HORSE_COLOR, DataConstants.Horse.DEFAULT_COLOR, this.horseColor);
    }

    @Override
    public Value<HorseStyle> style() {
        return new SpongeValue<HorseStyle>(Keys.HORSE_STYLE, DataConstants.Horse.DEFAULT_STYLE, this.horseStyle);
    }

    @Override
    public Value<HorseVariant> variant() {
        return new SpongeValue<HorseVariant>(Keys.HORSE_VARIANT, DataConstants.Horse.DEFAULT_VARIANT, this.horseVariant);
    }

    @Override
    public HorseData copy() {
        return new SpongeHorseData(this.horseColor, this.horseStyle, this.horseVariant);
    }

    @Override
    public ImmutableHorseData asImmutable() {
        return new ImmutableSpongeHorseData(this.horseColor, this.horseStyle, this.horseVariant);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.HORSE_COLOR.getQuery(), (Object)this.horseColor.getId()).set(Keys.HORSE_STYLE.getQuery(), (Object)this.horseStyle.getId()).set(Keys.HORSE_VARIANT.getQuery(), (Object)this.horseVariant.getId());
    }

    private HorseColor getHorseColor() {
        return this.horseColor;
    }

    private void setHorseColor(HorseColor horseColor) {
        this.horseColor = horseColor;
    }

    private HorseStyle getHorseStyle() {
        return this.horseStyle;
    }

    private void setHorseStyle(HorseStyle horseStyle) {
        this.horseStyle = horseStyle;
    }

    private HorseVariant getHorseVariant() {
        return this.horseVariant;
    }

    private void setHorseVariant(HorseVariant horseVariant) {
        this.horseVariant = horseVariant;
    }
}

