/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableMovementSpeedData;
import org.spongepowered.api.data.manipulator.mutable.entity.MovementSpeedData;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeMovementSpeedData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SpongeMovementSpeedData
extends AbstractData<MovementSpeedData, ImmutableMovementSpeedData>
implements MovementSpeedData {
    private double walkSpeed;
    private double flySpeed;

    public SpongeMovementSpeedData(double walkSpeed, double flySpeed) {
        super(MovementSpeedData.class);
        this.walkSpeed = walkSpeed;
        this.flySpeed = flySpeed;
        this.registerGettersAndSetters();
    }

    public SpongeMovementSpeedData() {
        this(0.7, 0.05);
    }

    public double getWalkSpeed() {
        return this.walkSpeed;
    }

    public SpongeMovementSpeedData setWalkSpeed(double value) {
        this.walkSpeed = value;
        return this;
    }

    public double getFlySpeed() {
        return this.flySpeed;
    }

    public SpongeMovementSpeedData setFlySpeed(double value) {
        this.flySpeed = value;
        return this;
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.WALKING_SPEED, this::getWalkSpeed);
        this.registerFieldSetter(Keys.WALKING_SPEED, this::setWalkSpeed);
        this.registerKeyValue(Keys.WALKING_SPEED, this::walkSpeed);
        this.registerFieldGetter(Keys.FLYING_SPEED, this::getFlySpeed);
        this.registerFieldSetter(Keys.FLYING_SPEED, this::setFlySpeed);
        this.registerKeyValue(Keys.FLYING_SPEED, this::flySpeed);
    }

    @Override
    public Value<Double> walkSpeed() {
        return new SpongeValue<Double>(Keys.WALKING_SPEED, 0.7, this.walkSpeed);
    }

    @Override
    public Value<Double> flySpeed() {
        return new SpongeValue<Double>(Keys.FLYING_SPEED, 0.05, this.flySpeed);
    }

    @Override
    public MovementSpeedData copy() {
        return new SpongeMovementSpeedData(this.walkSpeed, this.flySpeed);
    }

    @Override
    public ImmutableMovementSpeedData asImmutable() {
        return new ImmutableSpongeMovementSpeedData(this.walkSpeed, this.flySpeed);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.WALKING_SPEED, (Object)this.walkSpeed).set(Keys.FLYING_SPEED, (Object)this.flySpeed);
    }
}

